/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.swing;

import java.io.File;
import javax.swing.JFileChooser;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.Undef;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.TernaryArgs;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.lisp.swing.GUIElement;
import net.morilib.util.mapset.HashOneToOneSet;
import net.morilib.util.mapset.OneToOneSet;
import net.morilib.util.swing.ExtensionFileFilter;

public class LispFileChooser
extends Datum2 {
    private static final OneToOneSet<Datum, Integer> _MODES = new HashOneToOneSet<Datum, Integer>({Symbol.getSymbol("files"), 0}, {Symbol.getSymbol("directories"), 1}, {Symbol.getSymbol("files-and-directories"), 2});
    private JFileChooser filechooser;

    public LispFileChooser(JFileChooser chooser) {
        this.filechooser = chooser;
    }

    private static Datum _result(JFileChooser fc, int r) {
        switch (r) {
            case 0: {
                if (fc.isMultiSelectionEnabled()) {
                    File[] fs = fc.getSelectedFiles();
                    ConsListBuilder b = new ConsListBuilder();
                    int i = 0;
                    while (i < fs.length) {
                        b.append(new LispString(fs[i].getPath()));
                        ++i;
                    }
                    return b.get();
                }
                return new LispString(fc.getSelectedFile().getPath());
            }
            case 1: {
                return LispBoolean.FALSE;
            }
        }
        throw new RuntimeException();
    }

    public void toDisplayString(StringBuilder buf) {
        buf.append("#<file-chooser>");
    }

    public static class MakeFileChooser
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(c1a);
            JFileChooser fc = new JFileChooser();
            while (itr.hasNext()) {
                Datum d = itr.next();
                if (!(d instanceof Cons)) continue;
                Cons c = (Cons)d;
                if (!(c.getCar() instanceof LispString)) {
                    throw mesg.getError("err.require.string", c.getCar());
                }
                if (!(c.getCdr() instanceof LispString)) {
                    throw mesg.getError("err.require.string", c.getCdr());
                }
                fc.addChoosableFileFilter(new ExtensionFileFilter(c.getCar().getString(), c.getCdr().getString()));
            }
            if (!itr.getTerminal().isNil()) {
                throw mesg.getError("err.list", c1a);
            }
            return new LispFileChooser(fc);
        }
    }

    public static class SetAcceptAllFileFilterUsedS
    extends BinaryArgs {
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispFileChooser) {
                ((LispFileChooser)c1a).filechooser.setAcceptAllFileFilterUsed(c2a.isTrue());
                return Undef.UNDEF;
            }
            throw mesg.getError("err.swing.require.filechooser", c1a);
        }
    }

    public static class SetFileSelectionModeS
    extends BinaryArgs {
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispFileChooser) {
                Integer i = (Integer)_MODES.getValue(c2a);
                if (i == null) {
                    throw mesg.getError("err.swing.invalidfileselectionmode", c2a);
                }
                ((LispFileChooser)c1a).filechooser.setFileSelectionMode(i);
                return Undef.UNDEF;
            }
            throw mesg.getError("err.swing.require.filechooser", c1a);
        }
    }

    public static class ShowFileChooser
    extends TernaryArgs {
        protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispFileChooser) {
                String t = SubrUtils.getString(c3a, mesg);
                JFileChooser fc = ((LispFileChooser)c1a).filechooser;
                if (c2a instanceof GUIElement) {
                    return LispFileChooser._result(fc, fc.showDialog(((GUIElement)c2a).getAWTComponent(), t));
                }
                if (!c2a.isTrue()) {
                    return LispFileChooser._result(fc, fc.showDialog(null, t));
                }
                throw mesg.getError("err.swing.require.guielement", c2a);
            }
            throw mesg.getError("err.swing.require.filechooser", c1a);
        }
    }

    public static class ShowOpenFileChooser
    extends BinaryArgs {
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispFileChooser) {
                JFileChooser fc = ((LispFileChooser)c1a).filechooser;
                if (c2a instanceof GUIElement) {
                    return LispFileChooser._result(fc, fc.showOpenDialog(((GUIElement)c2a).getAWTComponent()));
                }
                if (!c2a.isTrue()) {
                    return LispFileChooser._result(fc, fc.showOpenDialog(null));
                }
                throw mesg.getError("err.swing.require.guielement", c2a);
            }
            throw mesg.getError("err.swing.require.filechooser", c1a);
        }
    }

    public static class ShowSaveFileChooser
    extends BinaryArgs {
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispFileChooser) {
                JFileChooser fc = ((LispFileChooser)c1a).filechooser;
                if (c2a instanceof GUIElement) {
                    return LispFileChooser._result(fc, fc.showSaveDialog(((GUIElement)c2a).getAWTComponent()));
                }
                if (!c2a.isTrue()) {
                    return LispFileChooser._result(fc, fc.showSaveDialog(null));
                }
                throw mesg.getError("err.swing.require.guielement", c2a);
            }
            throw mesg.getError("err.swing.require.filechooser", c1a);
        }
    }
}

