/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.swing;

import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Subr;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.swing.ActionListenable;
import net.morilib.lisp.swing.GUIElement;
import net.morilib.lisp.swing.ILispButton;
import net.morilib.lisp.swing.LispSwing;

public class LispButton
extends GUIElement
implements ILispButton,
ActionListenable {
    private JButton button;

    public LispButton(JButton label) {
        this.button = label;
    }

    public JButton getComponent() {
        return this.button;
    }

    public void addActionListener(ActionListener listener) {
        this.button.addActionListener(listener);
    }

    public Component getAWTComponent() {
        return this.getComponent();
    }

    public void toDisplayString(StringBuilder buf) {
        buf.append("#<button>");
    }

    public static class MakeButton
    extends BinaryArgs {
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (!(c1a instanceof LispString)) {
                throw mesg.getError("err.require.string", c1a);
            }
            if (!(c2a instanceof Procedure)) {
                throw mesg.getError("err.require.procedure", c2a);
            }
            JButton b = new JButton(c1a.getString());
            b.addActionListener(LispSwing.createActionListener(c2a, env, mesg));
            return new LispButton(b);
        }
    }

    public static class MakeButtonWithAction
    extends Subr {
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            JButton b = new JButton(LispSwing.createAction(body, body, env, mesg));
            return new LispButton(b);
        }
    }
}

