/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.collection.hash;

import java.util.Iterator;
import java.util.Map;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.collection.ImmutableException;
import net.morilib.lisp.collection.LispBag;
import net.morilib.lisp.collection.LispCollection;
import net.morilib.lisp.collection.LispSet;
import net.morilib.lisp.collection.hash.LispHash;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LispHashSet
extends Datum2
implements LispSet {
    private LispHash hash;

    public LispHashSet(LispHashSet hash) {
        this(hash.hash.duplicate());
    }

    private LispHashSet(LispHash hash) {
        this.hash = hash;
    }

    @Override
    public Symbol getCollectionName() {
        return Symbol.getSymbol("hash-set");
    }

    @Override
    public Datum toList() {
        return this.hash.keysToList();
    }

    @Override
    public int count(Datum c2a) {
        return this.hash.count(c2a);
    }

    @Override
    public int size() {
        return this.hash.size();
    }

    @Override
    public LispHashSet prototype() {
        return new LispHashSet((LispHash)this.hash.prototype());
    }

    @Override
    public Datum clear() throws ImmutableException {
        this.hash = (LispHash)this.hash.clear();
        return this;
    }

    @Override
    public boolean equalTo(LispCollection col) {
        for (Datum x : col) {
            if (this.contains(x)) continue;
            return false;
        }
        for (Datum x : this) {
            if (col.contains(x)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalTo(LispCollection col, Procedure p, Environment env, LispMessage mesg) {
        block0: for (Datum x : col) {
            for (Datum y : this) {
                if (Scheme.callva(p, env, mesg, x, y).isTrue()) continue block0;
            }
            return false;
        }
        return true;
    }

    @Override
    public LispHashSet duplicate() {
        return new LispHashSet(this);
    }

    @Override
    public boolean contains(Datum d) {
        return this.hash.containsKey(d);
    }

    @Override
    public Iterator<Datum> iterator() {
        final Iterator<Map.Entry<Datum, Datum>> ei = this.hash.entryIterator();
        return new Iterator<Datum>(){

            @Override
            public boolean hasNext() {
                return ei.hasNext();
            }

            @Override
            public Datum next() {
                return (Datum)((Map.Entry)ei.next()).getKey();
            }

            @Override
            public void remove() {
                ei.remove();
            }
        };
    }

    @Override
    public Procedure equivalence() {
        return this.hash.keyEquivalence();
    }

    @Override
    public boolean equivalence(Datum a, Datum b) {
        return this.hash.equivalenceKey(a, b);
    }

    @Override
    public boolean subset(LispSet set) {
        for (Datum x : set) {
            if (this.contains(x)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Datum copyAdd(Datum d) {
        return this.duplicate().add(d);
    }

    @Override
    public Datum add(Datum d) {
        this.hash.put0(d, Nil.NIL);
        return this;
    }

    @Override
    public Datum copyDelete(Datum d) {
        return this.duplicate().delete(d);
    }

    @Override
    public Datum delete(Datum d) {
        this.hash.remove(d);
        return this;
    }

    @Override
    public Datum union(LispSet s) {
        return this.duplicate().addAll(s);
    }

    @Override
    public Datum addAll(LispSet s) {
        for (Datum x : s) {
            this.add(x);
        }
        return this;
    }

    @Override
    public Datum intersection(LispSet s) {
        LispHashSet r = this.prototype();
        for (Datum x : this) {
            if (!s.contains(x)) continue;
            r.add(x);
        }
        return r;
    }

    @Override
    public Datum retainAll(LispSet s) {
        Iterator<Datum> i = this.iterator();
        while (i.hasNext()) {
            if (s.contains(i.next())) continue;
            i.remove();
        }
        return this;
    }

    @Override
    public Datum difference(LispSet s) {
        LispHashSet r = this.prototype();
        for (Datum x : this) {
            if (s.contains(x)) continue;
            r.add(x);
        }
        return r;
    }

    @Override
    public Datum removeAll(LispSet s) {
        Iterator<Datum> i = this.iterator();
        while (i.hasNext()) {
            if (!s.contains(i.next())) continue;
            i.remove();
        }
        return this;
    }

    @Override
    public Datum symmetricDifference(LispSet s) {
        LispHashSet r = this.prototype();
        for (Datum x : this) {
            if (s.contains(x)) continue;
            r.add(x);
        }
        for (Datum x : s) {
            if (this.contains(x)) continue;
            r.add(x);
        }
        return r;
    }

    @Override
    public Datum symmetricDifferenceModify(LispSet s) {
        return this.symmetricDifference(s);
    }

    @Override
    public Datum copyAddFrom(LispBag d) {
        return this.duplicate().addFrom(d);
    }

    @Override
    public Datum addFrom(LispBag d) {
        for (Datum x : d) {
            this.add(x);
        }
        return this;
    }

    @Override
    public Datum copyDeleteFrom(LispBag d) {
        LispHashSet r = this.prototype();
        for (Datum x : this) {
            if (d.contains(x)) continue;
            r.add(x);
        }
        return r;
    }

    @Override
    public Datum deleteFrom(LispBag d) {
        Iterator<Datum> i = this.iterator();
        while (i.hasNext()) {
            if (!d.contains(i.next())) continue;
            i.remove();
        }
        return this;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<hash-set>" + LispUtils.print(this.toList()));
    }
}

