/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lang.number;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import net.morilib.lang.algebra.QuotientAndRemainder;
import net.morilib.lang.number.Integer2;
import net.morilib.util.IntMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SmallInt
extends Integer2
implements Serializable {
    private static final long serialVersionUID = -4912159628063856328L;
    private int value;

    SmallInt(int value) {
        this.value = value;
    }

    @Override
    public Integer2 add(Integer2 x) {
        if (x instanceof SmallInt) {
            long vr1 = this.value;
            long vr2 = x.toLong();
            return Integer2.valueOf(vr1 + vr2);
        }
        BigInteger vb = BigInteger.valueOf(this.value);
        return Integer2.valueOf(vb.add(x.toBigInteger()));
    }

    @Override
    public Integer2 divide(Integer2 x) {
        if (x instanceof SmallInt) {
            return Integer2.valueOf(this.value / x.toInt());
        }
        BigInteger vb = BigInteger.valueOf(this.value);
        return Integer2.valueOf(vb.divide(x.toBigInteger()));
    }

    @Override
    public Integer2 multiply(Integer2 x) {
        if (x instanceof SmallInt) {
            long vr1 = this.value;
            long vr2 = x.toLong();
            return Integer2.valueOf(vr1 * vr2);
        }
        BigInteger vb = BigInteger.valueOf(this.value);
        return Integer2.valueOf(vb.multiply(x.toBigInteger()));
    }

    @Override
    public Integer2 subtract(Integer2 x) {
        if (x instanceof SmallInt) {
            long vr1 = this.value;
            long vr2 = x.toLong();
            return Integer2.valueOf(vr1 - vr2);
        }
        BigInteger vb = BigInteger.valueOf(this.value);
        return Integer2.valueOf(vb.subtract(x.toBigInteger()));
    }

    @Override
    public Integer2 negate() {
        return new SmallInt(-this.value);
    }

    @Override
    public int signum() {
        return IntMath.signum(this.value);
    }

    public boolean isEqualTo(Integer2 x) {
        if (x instanceof SmallInt) {
            return this.value == x.toInt();
        }
        BigInteger vb = BigInteger.valueOf(this.value);
        return vb.equals(x.toBigInteger());
    }

    @Override
    public BigInteger toBigInteger() {
        return BigInteger.valueOf(this.value);
    }

    @Override
    public int toInt() {
        return this.value;
    }

    @Override
    public long toLong() {
        return this.value;
    }

    public BigDecimal getBigDecimal() {
        return new BigDecimal(this.value);
    }

    @Override
    public Integer2 remainder(Integer2 x) {
        if (x instanceof SmallInt) {
            return Integer2.valueOf(this.value % x.toInt());
        }
        BigInteger vb = BigInteger.valueOf(this.value);
        return Integer2.valueOf(vb.remainder(x.toBigInteger()));
    }

    @Override
    public QuotientAndRemainder<Integer2> divideAndRemainder(Integer2 x) {
        if (x instanceof SmallInt) {
            return new QuotientAndRemainder<Integer2>(Integer2.valueOf(this.value / x.toInt()), Integer2.valueOf(this.value % x.toInt()));
        }
        BigInteger vb = BigInteger.valueOf(this.value);
        BigInteger[] dr = vb.divideAndRemainder(x.toBigInteger());
        return new QuotientAndRemainder<Integer2>(Integer2.valueOf(dr[0]), Integer2.valueOf(dr[1]));
    }

    @Override
    public boolean isZero() {
        return this.value == 0;
    }

    @Override
    public Integer2 multiply(int n) {
        return Integer2.valueOf(this.value * n);
    }

    @Override
    public Integer2 power(int n) {
        BigInteger vb = BigInteger.valueOf(this.value);
        return Integer2.valueOf(vb.pow(n));
    }

    @Override
    public int compareTo(Integer2 o) {
        if (o instanceof SmallInt) {
            int z = o.toInt();
            return this.value > z ? 1 : (this.value < z ? -1 : 0);
        }
        BigInteger vb = BigInteger.valueOf(this.value);
        return vb.compareTo(o.toBigInteger());
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    public BigDecimal getBigDecimal(MathContext mc) {
        return new BigDecimal(this.value);
    }

    @Override
    public boolean inByteRange() {
        return this.value >= -128 && this.value <= 127;
    }

    @Override
    public boolean inIntRange() {
        return true;
    }

    @Override
    public boolean inLongRange() {
        return true;
    }

    @Override
    public boolean inShortRange() {
        return this.value >= Short.MIN_VALUE && this.value <= Short.MAX_VALUE;
    }

    @Override
    public boolean isUnit() {
        return this.value == 1;
    }

    public boolean equals(Object x) {
        if (x instanceof SmallInt) {
            return this.value == ((SmallInt)x).value;
        }
        return false;
    }

    public int hashCode() {
        int l = 17;
        l = 37 * l + this.value;
        return l;
    }

    public String toString() {
        return Integer.toString(this.value);
    }
}

