/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp;

import java.util.List;

public class SynSetS extends Syntax {
	
	private Datum getSetval(Datum bcdr, LispMessage mesg) {
		if(bcdr instanceof Cons) {
			Cons c1 = (Cons)bcdr;
			
			if(c1.getCdr() != Nil.NIL) {
				throw mesg.getError("err.set.malform");
			}
			return c1.getCar();
		} else {
			//throw new LispException("Syntax error");
			throw mesg.getError("err.set.malform");
		}
	}
	
	private Datum replaceSetval(
			Datum bcar,
			Datum bcdr,
			Environment env,
			LispCompiler comp,
			Environment ienv,
			LispMessage mesg) {
		if(bcdr instanceof Cons) {
			Datum d1 = ((Cons)bcdr).getCar();
			Cons r1 = new Cons();
			Cons r2 = new Cons();
			//Datum fd = ienv.findDatum(bcar);
			
			// ֤ꥹȤ˥ܥ뤬Ȥ֤
			//if(fd != null) {
			//	bcar = fd;
			//}
			
			//r1.setCar(bcar);
			r1.setCar(comp.replaceLocalVals(bcar, env, ienv, false));
			r1.setCdr(r2);
			r2.setCar(comp.replaceLocalVals(d1, env, ienv, false));
			return r1;
		} else {
			//throw new LispException("Syntax error");
			throw mesg.getError("err.set.malform");
		}
	}
	
	
	/*package*/ void compile(
			Datum body,
			Environment env,
			LispCompiler comp,
			CompiledCode.Builder build,
			boolean toplevel,
			Cons callsym,
			boolean istail,
			LispMessage mesg,
			List<Cons> symlist, CodeExecutor exec, IntStack memento) {
		if(body instanceof Cons) {
			Datum bcar = ((Cons)body).getCar();
			Datum bcdr = ((Cons)body).getCdr();
			
			if(bcar instanceof SymbolName) {
				// 
				// create a temporary Closure
				CompiledCode.Builder mbuild = new CompiledCode.Builder();
				Environment  menv = new Environment(env);
				
				comp.compile(
						getSetval(bcdr, mesg),
						menv, mbuild,
						callsym, false, symlist,
						exec, memento);
				mbuild.addReturnOp();
				
				// ŪClosure
				ClosureClass cl = new ClosureClass(
						Nil.NIL, mbuild.getCodeRef());
				
				// ŪClosureƤӽФ
				build.addPush(cl);
				build.addBeginList();
				build.addEndList();
				build.addCall();
				
				build.addSet(bcar);
				build.addPop();
				build.addPush(Undef.UNDEF);
			} else if(bcar instanceof Cons) {
				// SRFI-17
				Cons c1 = (Cons)bcar;
				
				build.addReferSetter(c1.getCar());
				build.addBeginList();
				SyntaxUtils.compileListApply(
						c1.getCdr(), env, comp, build,
						callsym, mesg, symlist,
						exec, memento);
				comp.compile(
						getSetval(bcdr, mesg),
						env, build,
						callsym, false, symlist,
						exec, memento);
				build.addAppendList();
				build.addEndList();
				build.addCall();
				build.addPop();
				build.addPush(Undef.UNDEF);
			} else {
				//throw new LispException("must be symbol");
				throw mesg.getError("err.set.name");
			}
		} else {
			//throw new LispException("Wrong arguments");
			throw mesg.getError("err.set.malform");
		}
	}
	
	
	/*package*/ Datum replaceLocalVals(
			Datum body,
			Environment env,
			LispCompiler comp,
			Environment ienv, LispMessage mesg, boolean toplv) {
		if(body instanceof Cons) {
			Datum bcar = ((Cons)body).getCar();
			Datum bcdr = ((Cons)body).getCdr();
			
			if(bcar instanceof SymbolName) {
				// 
				return replaceSetval(
						bcar, bcdr, env, comp, ienv, mesg);
			} else if(bcar instanceof Cons) {
				// SRFI-17
				return replaceSetval(
						bcar, bcdr, env, comp, ienv, mesg);
			} else {
				//throw new LispException("must be symbol");
				throw mesg.getError("err.set.name");
			}
		} else {
			//throw new LispException("Wrong arguments");
			throw mesg.getError("err.set.malform");
		}
	}
	
}
