/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.util;

import java.math.BigInteger;

public final class NullInclimentor implements Inclimentor<Void> {
	
	public static final NullInclimentor INSTANCE =
		new NullInclimentor();
	
	public boolean equalIncliment(Inclimentor<?> i) {
		return i.isZero();
	}

	public boolean equalInt(int i) {
		return i == 0;
	}

	public Void getObject() {
		return null;
	}

	public boolean isZero() {
		return true;
	}

	public Inclimentor<Void> suc() {
		throw new OutOfBoundsException();
	}

	public Inclimentor<Void> suc(int step) {
		throw new OutOfBoundsException();
	}

	public int toInt() {
		return 0;
	}

	public boolean hasNext() {
		return false;
	}

	public Inclimentor<Void> getZero() {
		return INSTANCE;
	}

	public boolean equalInt(BigInteger i) {
		return i.equals(BigInteger.ZERO);
	}

}
