/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp;

import java.util.List;

import net.morilib.lisp.CompiledCode.Builder;

public class SynJavaCall extends Syntax {

	@Override
	/*package*/ void compile(
			Datum body,
			Environment env,
			LispCompiler comp,
			Builder build,
			boolean toplevel,
			Cons callsym,
			boolean istail,
			LispMessage mesg,
			List<Cons> symlist, CodeExecutor exec, IntStack memento) {
		Datum method, klass, args;
		
		if(body instanceof Cons) {
			Cons p1 = (Cons)body;
			
			method = p1.getCar();
			if(!IntLispUtils.isSymbolName(method)) {
				throw mesg.getError("err.require.symbol", method);
			} else if(p1.getCdr() instanceof Cons) {
				Cons p2 = (Cons)p1.getCdr();
				
				klass = p2.getCar();
				args  = p2.getCdr();
			} else {
				throw mesg.getError("err.java-call.malform");
			}
		} else {
			throw mesg.getError("err.java-call.malform");
		}
		
		comp.compile(
				klass, env, build, callsym, false, symlist,
				exec, memento);
		comp.compileArgs(
				args, env, build, callsym, symlist,
				exec, memento);
		build.addJavaCall((SymbolName)method, klass);
	}

	@Override
	Datum replaceLocalVals(
			Datum body,
			Environment env,
			LispCompiler comp,
			Environment ienv,
			LispMessage mesg, boolean toplv) {
		ConsListBuilder bld = new ConsListBuilder();
		Datum method, klass, args, rargs;
		
		if(body instanceof Cons) {
			Cons p1 = (Cons)body;
			
			method = p1.getCar();
			if(!(method instanceof Symbol)) {
				throw mesg.getError("err.require.symbol", method);
			} else if(p1.getCdr() instanceof Cons) {
				Cons p2 = (Cons)p1.getCdr();
				
				klass = p2.getCar();
				args  = p2.getCdr();
			} else {
				throw mesg.getError("err.java-call.malform");
			}
		} else {
			throw mesg.getError("err.java-call.malform");
		}
		
		rargs = SyntaxUtils.replaceLocalValsList(
				args, env, comp, ienv, mesg);
		bld.append(method);
		bld.append(comp.replaceLocalVals(klass, env, ienv, false));
		
		return bld.get(rargs);
	}

}
