/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public final class NullSet<E> extends AbstractSet<E> {
	
	private NullSet() {
		// do nothing
	}
	
	private static final Set<Object> NULL = new NullSet<Object>();
	
	
	@SuppressWarnings("unchecked")
	public static <T> Set<T> getInstance() {
		return (NullSet<T>)NULL;
	}
	
	
	public boolean add(E o) {
		return false;
	}

	public boolean addAll(Collection<? extends E> c) {
		return false;
	}

	public void clear() {
		// do nothing
	}

	public boolean contains(Object o) {
		return false;
	}

	public boolean containsAll(Collection<?> c) {
		return false;
	}

	public boolean isEmpty() {
		return true;
	}

	public Iterator<E> iterator() {
		return NullIterator.getInstance();
	}

	public boolean remove(Object o) {
		return false;
	}

	public boolean removeAll(Collection<?> c) {
		return false;
	}

	public boolean retainAll(Collection<?> c) {
		return false;
	}

	public int size() {
		return 0;
	}

}
