/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp;

/*package*/ class SymbolScope extends Datum implements SymbolName {
	
	//
	private Symbol symbol;
	private UserSyntax scope;
	
	
	/*package*/ SymbolScope(Symbol symbol, UserSyntax scope) {
		if(symbol == null || scope == null) {
			throw new NullPointerException();
		}
		this.symbol = symbol;
		this.scope = scope;
	}

	/**
	 * @return the symbol
	 */
	public Symbol getSymbol() {
		return symbol;
	}
	
	
	public UserSyntax getUserSyntax() {
		return scope;
	}
	
	
	public Environment getExecuteEnv() {
		if(scope.getExecuteEnv() == null) {
			throw new LispException(
					"environment has not been initialized");
		}
		return scope.getExecuteEnv();
	}
	
	
	public String toString() {
		return symbol + ":" + scope;
	}
	
	
	public boolean isTypeSymbol() {
		return true;
	}

	
	public String getName() {
		return symbol.getName();
	}
	
}
