/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.range;

import net.morilib.util.Objects;

/**
 * Useful methods and constants for the Range library.
 * <p>Range饤֥ΤͭѤʥ᥽åɤǤ.
 * 
 * @author MORIGUCHI, Yuichiro 2008/01/01
 */
public final class Ranges {
	
	//
	private Ranges() {}
	
	//
	static int compareInfimum(
			Object o1, boolean b1, Object o2, boolean b2) {
		int r = Objects.compareBound(o1, o2);
		
		return (r != 0) ? r : (
				(b1 && !b2) ? 1 : ((!b1 && b2) ? -1 : 0));
	}
	
	//
	static int compareSupremum(
			Object o1, boolean b1, Object o2, boolean b2) {
		int r = Objects.compareBound(o1, o2);
		
		return (r != 0) ? r : (
				(b1 && !b2) ? -1 : ((!b1 && b2) ? 1 : 0));
	}
	
	//
	static
	boolean inCoveredLowerHalfPlane(Range src, Range d) {
		if(d.isSupremumClosed() || src.isSupremumOpen()) {
			return !src.isSupremumBoundAboveAllClosureOf(d);
		} else {
			return src.isSupremumBoundBelowAllClosureOf(d);
		}
	}
	
	//
	static
	boolean inCoveredUpperHalfPlane(Range src, Range d) {
		if(d.isInfimumClosed() || src.isInfimumOpen()) {
			return !src.isInfimumBoundBelowAllClosureOf(d);
		} else {
			return d.isInfimumBoundAboveAllClosureOf(src);
		}
	}

	/**
	 * calculates the sum set of the given {@link Range} objects.
	 * <p>Ϳ줿{@link Range}½׻.
	 */
	public static
	Range sum(Range r1, Range r2) {
		return r1.join(r2);
	}
	
	/**
	 * Returns the overlap of the given ranges.
	 * <p>Ϳ줿{@link Range}ζʬ׻.
	 */
	public static
	Range overlap(Range r1, Range r2) {
		return r1.meet(r2);
	}
	
	/**
	 * returns true if the given object is in the interval between
	 * the both edges of {@link Range}.
	 * <p>Ϳ줿֥Ȥ{@link Range}֥Ȥüǹ
	 * ֤ˤȤtrue.
	 * 
	 * @param t  a {@link Range}
	 * @param o  an object to be tested
	 */
	public static
	boolean inBounds(Range t, Object o) {
		return !t.isInfimumAbove(o) && !t.isSupremumBelow(o);
	}

}
