using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using SCFiler2.FileSystem;
using SCFiler2.Action;

namespace SCFiler2 {
	public partial class HistoryView : UserControl {
		HistoryManager manager = null;

		public HistoryView() {
			InitializeComponent();
		}

		/// <summary>
		/// r[őIĂACeԂ
		/// </summary>
		public FilerItem SelectedItem {
			get {
				return (FilerItem)item_list.FocusedItem.Tag;
			}
		}

		public void initialise(HistoryManager history_manager, string title) {
			//֘Ȁ
			manager = history_manager;

			//ŏ̕\
			view_title_label.Text = title;
			updateView();
			title_panel.BackColor = SCFiler2System.Instance.Option.Color.InactiveViewTitleBack;
			view_title_label.ForeColor = SCFiler2System.Instance.Option.Color.InactiveViewTitleText;
		}

		public void updateView() {
			//r[̏Ԃ̍XV
			item_list.Columns.Add("", item_list.Width);

			item_list.Items.Clear();
			foreach (FilerItem item in manager.ItemList) {
				ListViewItem list_item = new ListViewItem(item.Info.Name);
				list_item.Tag = item;
				item_list.Items.Add(list_item);
			}
			if (item_list.Items.Count > 0) {
				item_list.Items[0].Selected = true;
				item_list.Items[0].Focused = true;
			}
		}

		/// <summary>
		/// Xgr[̃ACeSĂIBSđIԂSĉBtH[JX̂ACe̐Ԃɖ߂
		/// </summary>
		public void selectAll() {
			if (item_list.SelectedItems.Count == item_list.Items.Count) {
				foreach (ListViewItem item in item_list.Items) {
					if (item.Focused != true) {
						item.Selected = false;
					}
				}
			} else {
				foreach (ListViewItem item in item_list.Items) {
					item.Selected = true;
				}
			}
		}

		private void setViewActiveColor() {
			title_panel.BackColor = SCFiler2System.Instance.Option.Color.ActiveViewTitleBack;
			view_title_label.ForeColor = SCFiler2System.Instance.Option.Color.ActiveViewTitleText;
		}

		private void setViewInactiveColor() {
			title_panel.BackColor = SCFiler2System.Instance.Option.Color.InactiveViewTitleBack;
			view_title_label.ForeColor = SCFiler2System.Instance.Option.Color.InactiveViewTitleText;
		}

		private void HistoryView_Enter(object sender, EventArgs e) {
			MainForm.Instance.notifyHistoryViewFocused(this);
			displayCurrentItemInformation();
			setViewActiveColor();
		}

		private void HistoryView_Leave(object sender, EventArgs e) {
			MainForm.Instance.printToStatusbar("");
			setViewInactiveColor();
		}

		private void item_list_KeyDown(object sender, KeyEventArgs e) {
			KeyCommandManager.Instance.executeAction(e.Control, e.Alt, e.Shift, e.KeyCode);
		}

		private void item_list_DoubleClick(object sender, EventArgs e) {
			Action.Action.ExecuteFocusedItem.execute();
		}

		private void item_list_SelectedIndexChanged(object sender, EventArgs e) {
			if (item_list.Focused == false) {
				return;
			}
			displayCurrentItemInformation();
		}

		private void displayCurrentItemInformation() {
			if (item_list.SelectedItems.Count > 0) {
				FilerItem item = (FilerItem)item_list.SelectedItems[0].Tag;
				MainForm.Instance.printToStatusbar(item.Info.FullName);
			} else {
				MainForm.Instance.printToStatusbar("");
			}
		}

		private void item_list_ItemDrag(object sender, ItemDragEventArgs e) {
			//IACeFullNameXg
			string[] selected_files = new string[item_list.SelectedItems.Count];
			for (int i = 0; i < item_list.SelectedItems.Count; i++) {
				FilerItem item = (FilerItem)item_list.SelectedItems[i].Tag;
				selected_files[i] = item.Info.FullName;
			}

			//hbO
			DataObject data = new DataObject(DataFormats.FileDrop, selected_files);
			item_list.DoDragDrop(data, DragDropEffects.Copy | DragDropEffects.Link);
		}
	}
}
