﻿using System;
using System.IO;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using SCFiler2.FileSystem;

namespace SCFiler2.FileSystem {
	class ClipboardManager {

		public enum EffectType : int {
			None = 0,
			Copy = 1,
			Cut = 2,
			Link = 4,
		}

		public static bool isConatinFiles() {
			if (Clipboard.ContainsFileDropList()) {
				return true;
			} else {
				return false;
			}
		}

		public static List<FilerItem> getFilesInClipboard() {
			IDataObject obj = Clipboard.GetDataObject();
			if (obj.GetDataPresent(DataFormats.FileDrop)) {
				string[] files = (string[])obj.GetData(DataFormats.FileDrop);

				return FilerItem.getFileListFromStringArray(files);
			} else {
				return null;
			}
		}

		/// <summary>
		/// クリップボードに入っているファイルが"コピー"か"切り取り"かを判断する
		/// </summary>
		/// <returns>EffectType</returns>
		public static EffectType getDropEffect() {
			IDataObject obj = Clipboard.GetDataObject();
			object effect = obj.GetData("Preferred DropEffect");
			if (effect == null) {
				return EffectType.None;
			}
			if (effect.GetType() == typeof(MemoryStream)) {
				MemoryStream stream = (MemoryStream)effect;
				EffectType type = (EffectType)BitConverter.ToInt32(stream.ToArray(), 0);
				return type;
			} else {
				return EffectType.None;
			}
		}

		/// <summary>
		/// クリップボードに"コピー"や"切り取り"を指定してコピー
		/// </summary>
		/// <param name="effect"></param>
		/// <param name="items_to_send"></param>
		public static void sendToClipboard(EffectType effect, List<FilerItem> items_to_send) {
			//クリップボードに渡すためにstring[]へ変換
			string[] files = new string[items_to_send.Count];
			for (int i = 0; i < items_to_send.Count; i++) {
				files[i] = items_to_send[i].Info.FullName;
			}

			//クリップボードに渡すDataObjectの作成
			IDataObject obj_to_send = new DataObject(DataFormats.FileDrop, files);
			MemoryStream effect_data = new MemoryStream();
			byte[] effect_byte = new byte[] { (byte)effect, 0, 0, 0 };
			effect_data.Write(effect_byte, 0, effect_byte.Length);
			effect_data.SetLength(effect_byte.Length);
			obj_to_send.SetData("Preferred DropEffect", effect_data);
			Clipboard.SetDataObject(obj_to_send);
		}

	}
}
