using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.FileSystem;
using System.Diagnostics;

namespace SCFiler2.Action {
	public class ExecuteFocusedItem : Action {
		public override string DisplayString {
			get { return "s"; }
		}

		public override void execute() {
			MainForm main_form = MainForm.Instance;
			if (main_form.FocusedViewType == MainForm.EFocusedViewType.FileView) {
				FileView view = main_form.getLastFocusedFileView();

				List<FilerItem> list = view.SelectedFilerItems;
				if (list.Count != 1) {
					return;//Ƃ肠Ȃ
				}

				FilerItem item = list[0];
				if (item.Type == FilerItem.ItemType.Folder) {
					//tH_炻̃tH_̒Ɉړ
					view.setPath(item.Info.FullName);
				} else {
					//t@CAs
					Process.Start(item.Info.FullName);
					//r[ɒʒm
					foreach (HistoryManager manager in main_form.AllHistoryManager) {
						manager.notifyItemExecuted(item);
					}
				}
			} else if (main_form.FocusedViewType == MainForm.EFocusedViewType.HistoryView) {
				HistoryView view = main_form.getLastFocusedHistoryView();
				FilerItem item = view.SelectedItem;

				if (item.Type == FilerItem.ItemType.Folder) {
					//tH_AFileViewړ
					FileView target_view = MainForm.Instance.getLastFocusedFileView();
					target_view.setPath(item.Info.FullName);
				} else {
					//t@Cs
					Process.Start(item.Info.FullName);
					//r[ɒʒm
					foreach (HistoryManager manager in main_form.AllHistoryManager) {
						manager.notifyItemExecuted(item);
					}
				}

			}
		}
	}
}
