﻿using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.Util;

namespace SCFiler2.Action {
	public class CreateFolder : Action {
		public override string DisplayString {
			get { return "フォルダの新規作成"; }
		}

		public override void execute() {
			MainForm main_form = MainForm.Instance;
			if (main_form.FocusedViewType == MainForm.EFocusedViewType.FileView) {
				FileView view = main_form.getLastFocusedFileView();
				InputTextForm form = new InputTextForm("新規作成：フォルダ名を入力してください");
				if (form.ShowDialog() == System.Windows.Forms.DialogResult.Cancel) {
					main_form.printToStatusbar("フォルダの新規作成はキャンセルされました");
					return;
				}
				string folder_name = form.getInputtedText();
				Microsoft.VisualBasic.FileIO.FileSystem.CreateDirectory(view.CurrentPath + "\\" + folder_name);
				view.drawView();
				main_form.printToMessageHistoryArea("フォルダ" + folder_name + "を作成しました");
			} else {
				main_form.printToStatusbar("FileViewにフォーカスがありません");
			}
		}
	}
}
