using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.FileSystem;

namespace SCFiler2.Action {
	public class MoveToAnotherFileView : Action {
		public override string DisplayString {
			get { return "ACe𔽑΂̃r[Ɉړ"; }
		}

		public override void execute() {
			MainForm main_form = MainForm.Instance;
			if (main_form.FocusedViewType == MainForm.EFocusedViewType.FileView) {
				FileView active_view = main_form.getLastFocusedFileView();
				FileView inactive_view = main_form.getAnotherFileView(active_view);

				List<FilerItem> list = active_view.SelectedFilerItems;
				string to_folder = inactive_view.CurrentPath;
				foreach (FilerItem item in list) {
					if (item.Type == FilerItem.ItemType.File) {
						Microsoft.VisualBasic.FileIO.FileSystem.MoveFile(item.Info.FullName, to_folder + "\\" + item.Info.Name, Microsoft.VisualBasic.FileIO.UIOption.OnlyErrorDialogs);
					} else {
						Microsoft.VisualBasic.FileIO.FileSystem.MoveFile(item.Info.FullName, to_folder, Microsoft.VisualBasic.FileIO.UIOption.AllDialogs);
					}
				}
				active_view.drawView();
				inactive_view.drawView();
			} else {
				//ق̃r[ɃtH[JXƂ͉Ȃ
			}
		}
	}
}
