using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SCFiler2.Action;
using SCFiler2.Util;

namespace SCFiler2 {
	public partial class MainForm : Form {
		static private MainForm instance = null;

		#region r[ւ̃ANZX֘A
		public enum EFocusedViewType {
			FileView,
			HistoryView,
			Other
		}
		private EFocusedViewType focused_view = EFocusedViewType.Other;
		public EFocusedViewType FocusedViewType {
			get { return focused_view; }
			set { focused_view = value; }
		}
		private FileView last_focused_fileview = null;

		/// <summary>
		/// ݃tH[JXĂFileViewAɃtH[JXȂꍇ͍ŌɂقԂ
		/// Focusedł͂ȂLastFocusedɂĂ̂́A_CAOɃtH[JXƂɂg悤ɁB
		/// </summary>
		public FileView getLastFocusedFileView() {
			return last_focused_fileview;
		}

		/// <summary>
		/// tH[JXړƂMainFormɒʒm
		/// </summary>
		/// <param name="focused_view">VFocusFileView</param>
		public void setLastFocusedFileView(FileView focused_view) {
			last_focused_fileview = focused_view;
		}

		/// <summary>
		/// QFileVieŵŗ^ꂽFileView̔΂FileViewԂ
		/// </summary>
		/// <param name="file_view"></param>
		/// <returns>Ɣ΂FileView</returns>
		public FileView getAnotherFileView(FileView file_view) {
			if (file_view == left_file_listview) {
				return right_file_listview;
			} else {
				return left_file_listview;
			}
		}
		#endregion r[ւ̃ANZX֘A


		public MainForm() {
			instance = this;

			InitializeComponent();

			//TODO łŃL[o^Ă
			KeyCommandManager keycommand_manager = KeyCommandManager.Instance;
			keycommand_manager.registAction(keycommand_manager.getCommandString(false, false, false, Keys.Escape), new ExitApplication());
			keycommand_manager.registAction(keycommand_manager.getCommandString(false, false, false, Keys.Enter), new ExecuteFocusedItem());
			keycommand_manager.registAction(keycommand_manager.getCommandString(false, false, false, Keys.Delete), new moveToRecycle());
			keycommand_manager.registAction(keycommand_manager.getCommandString(false, false, false, Keys.Back), new MoveToParentFolder());
			keycommand_manager.registAction(keycommand_manager.getCommandString(true, false, false, Keys.C), new CopyToAnotherFileVIew());
			keycommand_manager.registAction(keycommand_manager.getCommandString(true, false, false, Keys.M), new moveToAnotherFileView());

			//c[o[̕`
			drawDriveToolbar();
		}

		/// <summary>
		/// MainForm̃CX^Xn
		/// </summary>
		static public MainForm Instance {
			get { return instance; }
		}

		private void MainForm_KeyDown(object sender, KeyEventArgs e) {
			KeyCommandManager.Instance.executeAction(e.Control, e.Alt, e.Shift, e.KeyCode);
		}

		private void MainForm_FormClosing(object sender, FormClosingEventArgs e) {
			SettingFile file = SettingFile.Instance;
			//݂̃tH[̏Ԃۑ
			if (WindowState == FormWindowState.Normal) {
				file.save("Location", "Height", this.Height.ToString());
				file.save("Location", "Width", this.Width.ToString());
			}
		}

		private void MainForm_Load(object sender, EventArgs e) {
			SettingFile file = SettingFile.Instance;
			//tH[̏Ԃǂݍ
			String h_str = file.load("Location", "Height");
			String w_str = file.load("Location", "Width");
			try {
				this.Height = int.Parse(h_str);
				this.Width = int.Parse(w_str);
			} catch {
				this.Height = 600;
				this.Width = 800;
			}
		}

		/// <summary>
		/// c[o[̃hCuꗗ`悷
		/// </summary>
		private void drawDriveToolbar() {
			drive_toolbar.Items.Clear();

			System.IO.DriveInfo[] drives = System.IO.DriveInfo.GetDrives();
			foreach (System.IO.DriveInfo drive in drives) {
				ToolStripButton button = new ToolStripButton(drive.Name, null, changeDrive);
				drive_toolbar.Items.Add(button);
			}
		}

		/// <summary>
		/// ANeBuFileView̃hCuύXBihCuꗗc[o[p̃Cxgnhj
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		public void changeDrive(object sender, EventArgs e) {
			ToolStripButton button = (ToolStripButton)sender;
			FileView view = getLastFocusedFileView();
			view.setPath(button.Text);
			view.drawView();
		}
	}
}