#include "opcode_info.hpp"

namespace opcode {

/** infomation ofinstruction set */
const OpcodeInfo instruction_set[] =
{
	{0x00, BRK, NL, AM_NONE},	
	{0x01, ORA, RD, PRE_IND},	
	{0x02, UND, NL, AM_NONE},	
	{0x03, UND, NL, AM_NONE},	
	{0x04, UND, NL, AM_NONE},	
	{0x05, ORA, RD, ZERO},	
	{0x06, ASL, WT, ZERO},	
	{0x07, UND, NL, AM_NONE},	
	{0x08, PHP, WT, AM_NONE},	
	{0x09, ORA, NL, IMM},	
	{0x0a, ASL, NL, REG_A},	
	{0x0b, UND, NL, AM_NONE},	
	{0x0c, UND, NL, AM_NONE},	
	{0x0d, ORA, RD, ABS},	
	{0x0e, ASL, WT, ABS},	
	{0x0f, UND, NL, AM_NONE},	
	{0x10, BPL, NL, REL},	
	{0x11, ORA, RD, POST_IND},	
	{0x12, UND, NL, AM_NONE},	
	{0x13, UND, NL, AM_NONE},	
	{0x14, UND, NL, AM_NONE},	
	{0x15, ORA, RD, ZERO_X},	
	{0x16, ASL, WT, ZERO_X},	
	{0x17, UND, NL, AM_NONE},	
	{0x18, CLC, NL, AM_NONE},	
	{0x19, ORA, RD, ABS_Y},	
	{0x1a, UND, NL, AM_NONE},	
	{0x1b, UND, NL, AM_NONE},	
	{0x1c, UND, NL, AM_NONE},	
	{0x1d, ORA, RD, ABS_X},	
	{0x1e, ASL, WT, ABS_X},	
	{0x1f, UND, NL, AM_NONE},	

	{0x20, JSR, NL, ABS},	
	{0x21, AND, RD, PRE_IND},	
	{0x22, UND, NL, AM_NONE},	
	{0x23, UND, NL, AM_NONE},	
	{0x24, BIT, RD, ZERO},	
	{0x25, AND, RD, ZERO},	
	{0x26, ROL, WT, ZERO},	
	{0x27, UND, RD, AM_NONE},	
	{0x28, PLP, RD, AM_NONE},	
	{0x29, AND, RD, IMM},	
	{0x2a, ROL, NL, REG_A},	
	{0x2b, UND, NL, AM_NONE},	
	{0x2c, BIT, RD, ABS},	
	{0x2d, AND, RD, ABS},	
	{0x2e, ROL, WT, ABS},	
	{0x2f, UND, NL, AM_NONE},	

	{0x30, BMI, NL, REL},	
	{0x31, AND, RD, POST_IND},	
	{0x32, UND, NL, AM_NONE},	
	{0x33, UND, NL, AM_NONE},	
	{0x34, UND, NL, AM_NONE},	
	{0x35, AND, RD, ZERO_X},	
	{0x36, ROL, WT, ZERO_X},	
	{0x37, UND, NL, AM_NONE},	
	{0x38, SEC, NL, AM_NONE},	
	{0x39, AND, RD, ABS_Y},	
	{0x3a, UND, NL, AM_NONE},	
	{0x3b, UND, NL, AM_NONE},	
	{0x3c, UND, NL, AM_NONE},	
	{0x3d, AND, RD, ABS_X},	
	{0x3e, ROL, WT, ABS_X},	
	{0x3f, UND, NL, AM_NONE},	

	{0x40, RTI, NL, AM_NONE},	
	{0x41, EOR, RD, PRE_IND},	
	{0x42, UND, NL, AM_NONE},	
	{0x43, UND, NL, AM_NONE},	
	{0x44, UND, NL, AM_NONE},	
	{0x45, EOR, RD, ZERO},	
	{0x46, LSR, WT, ZERO},	
	{0x47, UND, NL, AM_NONE},	
	{0x48, PHA, WT, AM_NONE},	
	{0x49, EOR, NL, IMM},	
	{0x4a, LSR, NL, REG_A},	
	{0x4b, UND, NL, AM_NONE},	
	{0x4c, JMP, NL, ABS},	
	{0x4d, EOR, RD, ABS},	
	{0x4e, LSR, WT, ABS},	
	{0x4f, UND, NL, AM_NONE},	

	{0x50, BVC, NL, REL},	
	{0x51, EOR, RD, POST_IND},	
	{0x52, UND, NL, AM_NONE},	
	{0x53, UND, NL, AM_NONE},	
	{0x54, UND, NL, AM_NONE},	
	{0x55, EOR, RD, ZERO_X},	
	{0x56, LSR, WT, ZERO_X},	
	{0x57, UND, NL, AM_NONE},	
	{0x58, CLI, NL, AM_NONE},	
	{0x59, EOR, RD, ABS_Y},	
	{0x5a, UND, NL, AM_NONE},	
	{0x5b, UND, NL, AM_NONE},	
	{0x5c, UND, NL, AM_NONE},	
	{0x5d, EOR, RD, ABS_X},	
	{0x5e, LSR, WT, ABS_X},	
	{0x5f, UND, NL, AM_NONE},	

	{0x60, RTS, NL, AM_NONE},	
	{0x61, ADC, RD, PRE_IND},	
	{0x62, UND, NL, AM_NONE},	
	{0x63, UND, NL, AM_NONE},	
	{0x64, UND, NL, AM_NONE},	
	{0x65, ADC, RD, ZERO},	
	{0x66, ROR, WT, ZERO},	
	{0x67, UND, NL, AM_NONE},	
	{0x68, PLA, RD, AM_NONE},	
	{0x69, ADC, NL, IMM},	
	{0x6a, ROR, NL, REG_A},	
	{0x6b, UND, NL, AM_NONE},	
	{0x6c, JMP, NL, IND},	
	{0x6d, ADC, RD, ABS},	
	{0x6e, ROR, WT, ABS},	
	{0x6f, UND, NL, AM_NONE},	

	{0x70, BVS, NL, REL},	
	{0x71, ADC, RD, POST_IND},	
	{0x72, UND, NL, AM_NONE},	
	{0x73, UND, NL, AM_NONE},	
	{0x74, UND, NL, AM_NONE},	
	{0x75, ADC, RD, ZERO_X},	
	{0x76, ROR, WT, ZERO_X},	
	{0x77, UND, NL, AM_NONE},	
	{0x78, SEI, NL, AM_NONE},	
	{0x79, ADC, RD, ABS_Y},	
	{0x7a, UND, NL, AM_NONE},	
	{0x7b, UND, NL, AM_NONE},	
	{0x7c, UND, NL, AM_NONE},	
	{0x7d, ADC, RD, ABS_X},	
	{0x7e, ROR, WT, ABS_X},	
	{0x7f, UND, NL, AM_NONE},	

	{0x80, UND, NL, AM_NONE},	
	{0x81, STA, WT, PRE_IND},	
	{0x82, UND, NL, AM_NONE},	
	{0x83, UND, NL, AM_NONE},	
	{0x84, STY, WT, ZERO},	
	{0x85, STA, WT, ZERO},	
	{0x86, STX, WT, ZERO},	
	{0x87, UND, NL, AM_NONE},	
	{0x88, DEY, NL, AM_NONE},	
	{0x89, UND, NL, AM_NONE},	
	{0x8a, TXA, NL, AM_NONE},	
	{0x8b, UND, NL, AM_NONE},	
	{0x8c, STY, WT, ABS},	
	{0x8d, STA, WT, ABS},	
	{0x8e, STX, WT, ABS},	
	{0x8f, UND, NL, AM_NONE},	

	{0x90, BCC, NL, REL},	
	{0x91, STA, WT, POST_IND},	
	{0x92, UND, NL, AM_NONE},	
	{0x93, UND, NL, AM_NONE},	
	{0x94, STY, WT, ZERO_X},	
	{0x95, STA, WT, ZERO_X},	
	{0x96, STX, WT, ZERO_Y},	
	{0x97, UND, NL, AM_NONE},	
	{0x98, TYA, NL, AM_NONE},	
	{0x99, STA, WT, ABS_Y},	
	{0x9a, TXS, NL, AM_NONE},	
	{0x9b, UND, NL, AM_NONE},	
	{0x9c, UND, NL, AM_NONE},	
	{0x9d, STA, WT, ABS_X},	
	{0x9e, UND, NL, AM_NONE},	
	{0x9f, UND, NL, AM_NONE},	

	{0xa0, LDY, NL, IMM},	
	{0xa1, LDA, RD, PRE_IND},	
	{0xa2, LDX, NL, IMM},	
	{0xa3, UND, NL, AM_NONE},	
	{0xa4, LDY, RD, ZERO},	
	{0xa5, LDA, RD, ZERO},	
	{0xa6, LDX, RD, ZERO},	
	{0xa7, UND, NL, AM_NONE},	
	{0xa8, TAY, NL, AM_NONE},	
	{0xa9, LDA, NL, IMM},	
	{0xaa, TAX, NL, AM_NONE},	
	{0xab, UND, NL, AM_NONE},	
	{0xac, LDY, RD, ABS},	
	{0xad, LDA, RD, ABS},	
	{0xae, LDX, RD, ABS},	
	{0xaf, UND, NL, AM_NONE},	

	{0xb0, BCS, NL, REL},	
	{0xb1, LDA, RD, POST_IND},	
	{0xb2, UND, NL, AM_NONE},	
	{0xb3, UND, NL, AM_NONE},	
	{0xb4, LDY, RD, ZERO_X},	
	{0xb5, LDA, RD, ZERO_X},	
	{0xb6, LDX, RD, ZERO_Y},	
	{0xb7, UND, NL, AM_NONE},	
	{0xb8, CLV, NL, AM_NONE},	
	{0xb9, LDA, RD, ABS_Y},	
	{0xba, TSX, NL, AM_NONE},	
	{0xbb, UND, NL, AM_NONE},	
	{0xbc, LDY, RD, ABS_X},	
	{0xbd, LDA, RD, ABS_X},	
	{0xbe, LDX, RD, ABS_Y},	
	{0xbf, UND, NL, AM_NONE},	

	{0xc0, CPY, NL, IMM},	
	{0xc1, CMP, RD, PRE_IND},	
	{0xc2, UND, NL, AM_NONE},	
	{0xc3, UND, NL, AM_NONE},	
	{0xc4, CPY, RD, ZERO},	
	{0xc5, CMP, RD, ZERO},	
	{0xc6, DEC, WT, ZERO},	
	{0xc7, UND, NL, AM_NONE},	
	{0xc8, INY, NL, AM_NONE},	
	{0xc9, CMP, NL, IMM},	
	{0xca, DEX, NL, AM_NONE},	
	{0xcb, UND, NL, AM_NONE},	
	{0xcc, CPY, RD, ABS},	
	{0xcd, CMP, RD, ABS},	
	{0xce, DEC, WT, ABS},	
	{0xcf, UND, NL, AM_NONE},	

	{0xd0, BNE, NL, REL},	
	{0xd1, CMP, RD, POST_IND},	
	{0xd2, UND, NL, AM_NONE},	
	{0xd3, UND, NL, AM_NONE},	
	{0xd4, UND, NL, AM_NONE},	
	{0xd5, CMP, RD, ZERO_X},	
	{0xd6, DEC, WT, ZERO_X},	
	{0xd7, UND, NL, AM_NONE},	
	{0xd8, CLD, NL, AM_NONE},	
	{0xd9, CMP, RD, ABS_Y},	
	{0xda, UND, NL, AM_NONE},	
	{0xdb, UND, NL, AM_NONE},	
	{0xdc, UND, NL, AM_NONE},	
	{0xdd, CMP, RD, ABS_X},	
	{0xde, DEC, WT, ABS_X},	
	{0xdf, UND, NL, AM_NONE},	

	{0xe0, CPX, NL, IMM},	
	{0xe1, SBC, RD, PRE_IND},	
	{0xe2, UND, NL, AM_NONE},	
	{0xe3, UND, NL, AM_NONE},	
	{0xe4, CPX, RD, ZERO},	
	{0xe5, SBC, RD, ZERO},	
	{0xe6, INC, WT, ZERO},	
	{0xe7, UND, NL, AM_NONE},	
	{0xe8, INX, NL, AM_NONE},	
	{0xe9, SBC, NL, IMM},	
	{0xea, NOP, NL, AM_NONE},	
	{0xeb, UND, NL, AM_NONE},	
	{0xec, CPX, RD, ABS},	
	{0xed, SBC, RD, ABS},	
	{0xee, INC, WT, ABS},	
	{0xef, UND, NL, AM_NONE},	

	{0xf0, BEQ, NL, REL},	
	{0xf1, SBC, RD, POST_IND},	
	{0xf2, UND, NL, AM_NONE},	
	{0xf3, UND, NL, AM_NONE},	
	{0xf4, UND, NL, AM_NONE},	
	{0xf5, SBC, RD, ZERO_X},	
	{0xf6, INC, WT, ZERO_X},	
	{0xf7, UND, NL, AM_NONE},	
	{0xf8, SED, NL, AM_NONE},	
	{0xf9, SBC, RD, ABS_Y},	
	{0xfa, UND, NL, AM_NONE},	
	{0xfb, UND, NL, AM_NONE},	
	{0xfc, UND, NL, AM_NONE},	
	{0xfd, SBC, RD, ABS_X},	
	{0xfe, INC, WT, ABS_X},
	{0xff, UND, NL, AM_NONE}
};

const OperationInfo optype_infos[]={
	{UND,  "db",  PS_NONE, AM_NONE, AM_NONE, AM_NONE},
	{NOP,  "nop", PS_NONE, AM_NONE, AM_NONE, AM_NONE},
	{BCC,  "bcc", PS_NONE, REG_PC, PS_C, REL},
	{BCS,  "bcs", PS_NONE, REG_PC, PS_C, REL},
	{BEQ,  "beq", PS_NONE, REG_PC, PS_Z, REL},
	{BMI,  "bmi", PS_NONE, REG_PC, PS_N, REL},
	{BNE,  "bne", PS_NONE, REG_PC, PS_Z, REL},
	{BPL,  "bpl", PS_NONE, REG_PC, PS_N, REL},
	{BVC,  "bvc", PS_NONE, REG_PC, PS_V, REL},
	{BVS,  "bvs", PS_NONE, REG_PC, PS_V, REL},
	{JMP,  "jmp", PS_NONE, REG_PC, AM_WILD, AM_NONE},
	{JSR,  "jsr", PS_NONE, REG_PC, ABS, AM_NONE},
	{BRK,  "brk", PS_NONE, REG_PC, AM_NONE, AM_NONE},
	{RTI,  "rti", PS_NONE, REG_PC, AM_NONE, AM_NONE},
	{RTS,  "rts", PS_NONE, REG_PC, AM_NONE, AM_NONE},
	{PHA,  "pha", PS_NONE, REG_SP, REG_A, AM_NONE},
	{PHP,  "php", PS_NONE, REG_SP, REG_PS, AM_NONE},
	{PLA,  "pla", NZ,      REG_A,  REG_SP, AM_NONE},
	{PLP,  "plp", PS_ALL,    REG_PS, REG_SP, AM_NONE},
	{STA,  "sta", PS_NONE, AM_WILD, REG_A, AM_NONE},
	{STX,  "stx", PS_NONE, AM_WILD, REG_X, AM_NONE},
	{STY,  "sty", PS_NONE, AM_WILD, REG_Y, AM_NONE},
	
	{BIT,  "bit", NVZ,     PS_NVZ, REG_A, AM_WILD},
	{CMP,  "cmp", NZC,     PS_NZC, REG_A, AM_WILD},
	{CPX,  "cpx", NZC,     PS_NZC, REG_X, AM_WILD},
	{CPY,  "cpy", NZC,     PS_NZC, REG_Y, AM_WILD},
	{ADC,  "adc", NVZC,    REG_A, REG_A, AM_WILD},
	{SBC,  "sbc", NVZC,    REG_A, REG_A, AM_WILD},
	{AND,  "and", NZ,      REG_A, REG_A, AM_WILD},
	{ORA,  "ora", NZ,      REG_A, REG_A, AM_WILD},
	{EOR,  "eor", NZ,      REG_A, REG_A, AM_WILD},
	
	{ASL,  "asl", NZC,     AM_WILD, AM_WILD, AM_NONE},
	{LSR,  "lsr", NZC,     AM_WILD, AM_WILD, AM_NONE},
	{ROL,  "rol", NZC,     AM_WILD, AM_WILD, AM_NONE},
	{ROR,  "ror", NZC,     AM_WILD, AM_WILD, AM_NONE},
	{INC,  "inc", NZ,      AM_WILD, AM_WILD, AM_NONE},
	{INX,  "inx", NZ,      REG_X, REG_X, AM_NONE},
	{INY,  "iny", NZ,      REG_Y, REG_Y, AM_NONE},
	{DEC,  "dec", NZ,      AM_WILD, AM_WILD, AM_NONE},
	{DEX,  "dex", NZ,      REG_X, REG_X, AM_NONE},
	{DEY,  "dey", NZ,      REG_Y, REG_Y, AM_NONE},
	{LDA,  "lda", NZ,      REG_A, AM_WILD, AM_NONE},
	{LDX,  "ldx", NZ,      REG_X, AM_WILD, AM_NONE},
	{LDY,  "ldy", NZ,      REG_Y, AM_WILD, AM_NONE},
	{TAX,  "tax", NZ,      REG_X, REG_A, AM_NONE},
	{TAY,  "tay", NZ,      REG_Y, REG_A, AM_NONE},
	{TSX,  "tsx", NZ,      REG_X, REG_SP, AM_NONE},
	{TXA,  "txa", NZ,      REG_A, REG_X, AM_NONE},
	{TXS,  "txs", PS_NONE, REG_SP, REG_X, AM_NONE},
	{TYA,  "tya", NZ,      REG_A, REG_Y, AM_NONE},
	{CLC,  "clc", CARRY,   PS_C, AM_NONE, AM_NONE},
	{CLD,  "cld", DECIMAL, PS_D, AM_NONE, AM_NONE},
	{CLI,  "cli", INHIBIT, PS_I, AM_NONE, AM_NONE},
	{CLV,  "clv", OVERFLOW_F,PS_V, AM_NONE, AM_NONE},
	{SEC,  "sec", CARRY,   PS_C, AM_NONE, AM_NONE},
	{SED,  "sed", DECIMAL, PS_D, AM_NONE, AM_NONE},
	{SEI,  "sei", INHIBIT, PS_I, AM_NONE, AM_NONE},
	{RESET,"RESET", PS_NONE, AM_NONE, AM_NONE, AM_NONE},
	{NMI,  "NMI", PS_NONE, AM_NONE, AM_NONE, AM_NONE},
	{IRQ,  "IRQ", PS_NONE, AM_NONE, AM_NONE, AM_NONE}
};
}
