#pragma once

#include <queue>
#include <string>

/* this is a container adaptor for queue of word. */
class WordStream
{
	std::queue<std::string> m_queue;
public:
	/** pop first */
	std::string get()
	{
		std::string popped = m_queue.front();
		m_queue.pop();
		return popped;
	}
	void push(std::string word)
	{
		m_queue.push(word);
	}
	std::string peek()const
	{
		return m_queue.front();
	}
	unsigned size()const
	{
		return m_queue.size();
	}
	bool empty()const
	{
		return m_queue.empty();
	}
};
