/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: win32_console.h,v 1.2 2004/04/21 10:39:53 orrisroot Exp $ */

#ifndef __WIN32_CONSOLE_H__
#define __WIN32_CONSOLE_H__

class win32_console : public tty_console {
private:
  HANDLE hStdinR, hStdoutR;
  HANDLE hStdinW, hStdoutW, hStderrW;

  CConsoleView *ConsoleView;
  HANDLE htTTYout;
  DWORD  dwtStdoutID;

  bool oflag;
  void term_edit_mode();
  void term_normal_mode();

  int  term_keypad_getc();

  void  term_move_down(int y);
  void  term_move_up(int y);
  void  term_move_right(int x);
  void  term_move_left(int x);
  void  term_move_bol();
  void  term_move_newline();
  void  term_bell(){}
  void  term_vbell(){}
  void  term_clear_screen();
  void  term_clear_eol(int x);
  void  term_set_attr_normal();
  void  term_set_attr_bold(){}
  void  term_set_attr_reverse();
  void  term_set_attr_underline(){}
  bool  term_has_color(){ return true; }
  void  term_putc(int c);
  void  term_print(const char *str);
  int   term_getc();
  char* term_gets(char *buf, int size);
public:
  win32_console();
  ~win32_console();

  void SetConsoleView(CConsoleView *pConsole);

  void tty_init();
  void tty_normal();

  void term_flush(sl4_fd_t fd);
  void term_set_fgcolor(SL_TTY::COLOR color);
  void term_set_bgcolor(SL_TTY::COLOR color);
  void term_getmaxyx(int *y, int* x);
};

#endif
