/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: WinShell.cpp,v 1.4 2004/05/07 08:26:11 orrisroot Exp $ */

#include "StdAfx.h"

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include "WinShell.h"

#include "MainFrm.h"
#include "ConsoleDoc.h"
#include "ConsoleView.h"

#include "libsatellite.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#ifdef _DEBUG
  //  Debug
  #include <crtdbg.h>
  #define CHECK_MEM_LEAK()  checkMemLeak();
  #define MEM_BREAK(x)  _CrtSetBreakAlloc(x);

  inline void checkMemLeak() {
    int nFlag = _CrtSetDbgFlag( _CRTDBG_REPORT_FLAG );
    nFlag |= _CRTDBG_LEAK_CHECK_DF;
    nFlag &= ~_CRTDBG_CHECK_CRT_DF;
    _CrtSetDbgFlag( nFlag );
  }
#else
  //  Release
  #define CHECK_MEM_LEAK()
  #define MEM_BREAK(x)
#endif // _DEBUG

CConsoleView* g_pConsole;
int		g_bChdirFlag;

/////////////////////////////////////////////////////////////////////////////
// CWinShellApp

BEGIN_MESSAGE_MAP(CWinShellApp, CWinApp)
	//{{AFX_MSG_MAP(CWinShellApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
		//        ̈ʒuɐR[hҏWȂłB
	//}}AFX_MSG_MAP
	// W̃t@C{hLg R}h
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	// ẄZbgAbv R}h
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWinShellApp NX̍\z

CWinShellApp::CWinShellApp()
{
	// TODO: ̈ʒuɍ\zpR[hǉĂB
	//  InitInstance ̏dvȏׂċLqĂB
}

/////////////////////////////////////////////////////////////////////////////
// B CWinShellApp IuWFNg

CWinShellApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CWinShellApp NX̏

BOOL CWinShellApp::InitInstance()
{
  CHECK_MEM_LEAK();
 
	// OLE Cȕ
	if (!AfxOleInit())
	{
		AfxMessageBox(IDP_OLE_INIT_FAILED);
		return FALSE;
	}

	// WIȏ
	// ̋@\gpAst@C̃TCY
	// Έȉ̓̏[`̒sKvȂ
	// 폜ĂB

#ifdef _AFXDLL
	Enable3dControls();		// L DLL ̒ MFC gpꍇɂ͂ĂяoĂB
#else
	Enable3dControlsStatic();	// MFC ƐÓIɃNĂꍇɂ͂ĂяoĂB
#endif

	// ݒ肪ۑ鉺̃WXg L[ύX܂B
	// TODO: ̕AЖ܂͏ȂǓK؂Ȃ̂
	// ύXĂB
	SetRegistryKey(_T("DSP Technology"));

	LoadStdProfileSettings();  // W INI t@C̃IvV[ނ܂ (MRU ܂)

	// AvP[Vp̃hLg ev[go^܂BhLg ev[g
	//  ̓hLgAt[ EBhEƃr[邽߂ɋ@\܂B

	CSingleDocTemplate* pDocTemplate;
	pDocTemplate = new CSingleDocTemplate(
		IDR_MAINFRAME,
		RUNTIME_CLASS(CConsoleDoc),
		RUNTIME_CLASS(CMainFrame),       // C SDI t[ EBhE
		RUNTIME_CLASS(CConsoleView));
	AddDocTemplate(pDocTemplate);

	// DDEAfile open ȂǕW̃VF R}h̃R}hC͂܂B
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	// R}hCŃfBXpb` R}hw肵܂B
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;

	// Helpt@CpX
	char modulepath[_MAX_PATH];
	size_t len,i;

	if(GetModuleFileName(NULL,modulepath,_MAX_PATH) != 0) {
		len = strlen(modulepath);
		for(i=len-1;i>=0;i--){
		  if(modulepath[i] == '\\'){
			modulepath[i]='\0';
			break;
		  }
		}
		strcat(modulepath, "doc");
		strcat(modulepath, "\\");
		strcat(modulepath, "satellite4.hlp");
		m_pszHelpFilePath=_tcsdup(_T(modulepath));
	}

	// C EBhEꂽ̂ŁA\ƍXVs܂B
	m_pMainWnd->ShowWindow(SW_SHOW);
	m_pMainWnd->UpdateWindow();

	return TRUE;
}


/////////////////////////////////////////////////////////////////////////////
// AvP[Ṽo[WŎg CAboutDlg _CAO

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// _CAO f[^
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	CStatic	m_version;
	//}}AFX_DATA

	// ClassWizard z֐̃I[o[Ch𐶐܂B
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV ̃T|[g
	//}}AFX_VIRTUAL

// Cve[V
protected:
	//{{AFX_MSG(CAboutDlg)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
public:
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	DDX_Control(pDX, IDC_VERSION, m_version);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// _CAOs邽߂̃AvP[V R}h
void CWinShellApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CWinShellApp bZ[W nh

BOOL CAboutDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	m_version.SetWindowText(VERSION);
	
	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}
