/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: MainFrm.cpp,v 1.3 2004/04/21 10:49:30 orrisroot Exp $ */

#include "StdAfx.h"

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include "WinShell.h"

#include "MainFrm.h"
#include "ConsoleDoc.h"
#include "ConsoleView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//global definition
extern CConsoleView* g_pConsole;

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_SYSCOMMAND()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
	// O[o wv R}h
	ON_COMMAND(ID_HELP_FINDER, CFrameWnd::OnHelpFinder)
	ON_COMMAND(ID_HELP, CFrameWnd::OnHelp)
	ON_COMMAND(ID_CONTEXT_HELP, CFrameWnd::OnContextHelp)
	ON_COMMAND(ID_DEFAULT_HELP, CFrameWnd::OnHelpFinder)
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // Xe[^X C CWP[^
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame NX̍\z/

CMainFrame::CMainFrame()
{
	// TODO: ̈ʒuɃȍR[hǉĂB
	
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	if (!m_wndToolBar.CreateEx(this, TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;
	}

    if (!CreateStatusBar ())
        return -1;

	// TODO: c[ o[hbLO\ɂȂꍇ͈ȉ̂Rs폜
	//       ĂB
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar);

	CRect rcWindow;
	rcWindow.left = AfxGetApp()->GetProfileInt(VERSION,"main_left",0);
	rcWindow.top = AfxGetApp()->GetProfileInt(VERSION,"main_top",0);
	rcWindow.right = AfxGetApp()->GetProfileInt(VERSION,"main_right",512);
	rcWindow.bottom = AfxGetApp()->GetProfileInt(VERSION,"main_bottom",320);
        this->MoveWindow(rcWindow);

	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	//ǉ^Cg\Ȃ
	cs.style &= ~FWS_ADDTOTITLE;

	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame NX̐ff

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame bZ[W nh


void CMainFrame::OnSysCommand(UINT nID, LPARAM lParam) 
{
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉ邩܂̓ftHg̏ĂяoĂ
	
	if(nID == SC_CLOSE) {
		TCHAR script_msg[] = TEXT("exit");
		char ch;
		//m_inputMode = SCRIPT_INPUT;
		for(int i=0;i<(int)strlen(script_msg);i++){
			ch = script_msg[i];
			g_pConsole->SendMessage(WM_CHAR,TCHAR(ch),0L);
		}
		g_pConsole->SendMessage(WM_CHAR,TCHAR('\n'),0L);
		//g_pConsole->SendMessage(WM_CHAR,TCHAR('\n'),0L);
	}
	else
		CFrameWnd::OnSysCommand(nID, lParam);
}

void CMainFrame::OnDestroy() 
{
	WINDOWPLACEMENT wndpl;
	GetWindowPlacement(&wndpl);

	AfxGetApp()->WriteProfileInt(VERSION,"main_left",wndpl.rcNormalPosition.left);
	AfxGetApp()->WriteProfileInt(VERSION,"main_top",wndpl.rcNormalPosition.top);
	AfxGetApp()->WriteProfileInt(VERSION,"main_right",wndpl.rcNormalPosition.right);
	AfxGetApp()->WriteProfileInt(VERSION,"main_bottom",wndpl.rcNormalPosition.bottom);

	CFrameWnd::OnDestroy();
	
}

BOOL CMainFrame::CreateStatusBar()
{
    static UINT nIndicators[] = {
        ID_SEPARATOR,
        ID_INDICATOR_LINE,
        ID_INDICATOR_CAPS,
        ID_INDICATOR_NUM
    };

    if (!m_wndStatusBar.Create (this))
        return FALSE;

    m_wndStatusBar.SetIndicators (nIndicators, 4);
    return TRUE;
}
