/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: ConsoleView.h,v 1.2 2004/04/21 10:39:53 orrisroot Exp $ */

#if !defined(AFX_CONSOLEVIEW_H__EBAB000C_945C_49BF_BBF7_14BA82B2A658__INCLUDED_)
#define AFX_CONSOLEVIEW_H__EBAB000C_945C_49BF_BBF7_14BA82B2A658__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/* wparam of SendMessage(ID_TTY_TEXT_MODE) */
#define SENDMESS_TEXTMODE_FGCOLOR    0
#define SENDMESS_TEXTMODE_BGCOLOR    1
#define SENDMESS_TEXTMODE_ATTRIBUTE  2
#define SENDMESS_TEXTMODE_EDIT       3

#define TEXT_ATTRIBUTE_NORMAL    0x00
#define TEXT_ATTRIBUTE_REVERSE   0x01
#define TEXT_ATTRIBUTE_SELECT    0x10

/* foreground and background text color of selected region */
#define SELECTED_FGCOLOR         RGB(255,255,255)
#define SELECTED_BGCOLOR         RGB(0,0,128)
//
/* wparam of SendMessage(ID_TTY_CURSOR) */
#define SENDMESS_CURSOR_GETMAX   0
#define SENDMESS_CURSOR_DOWN     1
#define SENDMESS_CURSOR_UP       2
#define SENDMESS_CURSOR_RIGHT    3
#define SENDMESS_CURSOR_LEFT     4
#define SENDMESS_CURSOR_BOL      5
#define SENDMESS_CURSOR_NEWLINE  6

class CConsoleView : public CScrollView
{
private:
  HANDLE hTTYMutex;

  // SATELLITE shell handling properties
  HANDLE    m_hShellThread;
  HANDLE    m_hStdinW;   /* write side PIPE of standard input handle for Shell interface */

  // font properties
  CFont    *m_font;       /* current font */
  int       m_xCharSize;  /* width  of one char */
  int       m_yCharSize;  /* height of one char */

  // cursor properties
  int       m_xCurPos;    /* current logical cursor x position */
  int       m_yCurPos;    /* current logical cursor y position */
  int       m_xMax;       /* maximum number of column */
  int       m_yMax;       /* maximum number of row    */

 // terminal control properties
  bool      m_HasCaret;    /* caret existing flag */
  bool      m_ShowCaret;   /* logical caret showing */
  bool      m_IsAutoNL;    /* auto newline flag   */

  // scroll bar properties
  int       m_VscrollPos;  /* current scroll bar position of Y axis */
  int       m_yHiden;      /* number of current line buffer */

  // console color properties
  COLORREF  m_textColor;     /* foreground text color */
  COLORREF  m_backColor;     /* background text color */
  COLORREF  m_textColor_sel; /* foreground text color of selected region */
  COLORREF  m_backColor_sel; /* background text color of selected region */
  int       m_attr;          /* current text attribute (normal,reverse,select..)*/

  // copy and paste properties
  bool      m_bHasCopyArea; /* already exist selected area flag */
  bool      m_bSelCopyArea; /* currently selecting copy and paste area flag */
  int       m_xsCopyArea;   /* start position of X axis for copy and paste */ 
  int       m_xeCopyArea;   /* end   position of X axis for copy and paste */
  int       m_ysCopyArea;   /* start position of Y axis for copy and paste */ 
  int       m_yeCopyArea;   /* end   position of Y axis for copy and paste */

  // status bar properties
  size_t    m_nLine;

  void GetWindowProperties();
  void SetConsoleScrollPos(bool do_update);
  void SetCaretVisible(bool flag);

  // lowlevel text printing handler
  void PrintText(const char *prtbuf, size_t len);
  void DrawTextToConsole(int xpos, int ypos, int attr, const char *str, size_t len);

  void FixedSelectedCopyArea();
  void PasteClipBoardToTextBuffer();
#ifdef _VC6
  void CheckScrollBars(BOOL* horz,BOOL* vert);
#endif

protected: // VACY@\݂̂쐬܂B
	CConsoleView();
	DECLARE_DYNCREATE(CConsoleView)

// Agr[g
public:
	CConsoleDoc* GetDocument();

// Iy[V
public:
  void RegistTTYinput(HANDLE hin){ m_hStdinW = hin; }
  void SendTextPrint(const char *buf, size_t len);
  void SendTextColor(int target, unsigned int col);
  void SendTextAttribute(int attr);
  void SendTextEditMode(int flag);
  void SendCursorGetMax(int *x, int *y);
  void SendCursorUp(int n){ SendMessage(ID_TTY_CURSOR, SENDMESS_CURSOR_UP, n); }
  void SendCursorDown(int n){ SendMessage(ID_TTY_CURSOR, SENDMESS_CURSOR_DOWN, n); }
  void SendCursorLeft(int n){ SendMessage(ID_TTY_CURSOR, SENDMESS_CURSOR_LEFT, n); }
  void SendCursorRight(int n){ SendMessage(ID_TTY_CURSOR, SENDMESS_CURSOR_RIGHT, n); }
  void SendCursorBOL(){ SendMessage(ID_TTY_CURSOR, SENDMESS_CURSOR_BOL, 0); }
  void SendCursorNewLine(){ SendMessage(ID_TTY_CURSOR, SENDMESS_CURSOR_NEWLINE, 0); }


// I[o[Ch
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂B
	//{{AFX_VIRTUAL(CConsoleView)
	public:
	virtual void OnDraw(CDC* pDC);  // ̃r[`悷ۂɃI[o[Ch܂B
	protected:
	virtual void OnInitialUpdate(); // \z̍ŏ̂PxĂяo܂B
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL

// Cve[V
public:
	virtual ~CConsoleView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// ꂽbZ[W }bv֐
protected:
	//{{AFX_MSG(CConsoleView)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnEditPaste();
	afx_msg void OnUpdateEditPaste(CCmdUI* pCmdUI);
	afx_msg void OnAppExit();
	//}}AFX_MSG
  	afx_msg LRESULT OnTtyTextPrint(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnTtyCursor(WPARAM wParam, LPARAM lParam);
    afx_msg LRESULT OnTtyExit(WPARAM wParam, LPARAM lParam);
    afx_msg LRESULT OnTtyTextMode(WPARAM wParam, LPARAM lParam);
    afx_msg void OnUpdateLineNumber (CCmdUI* pCmdUI);
	DECLARE_MESSAGE_MAP()
public:
  afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
  afx_msg void OnSetFocus(CWnd* pOldWnd);
  afx_msg void OnKillFocus(CWnd* pNewWnd);
  afx_msg void OnEditCopy();
  afx_msg void OnUpdateEditCopy(CCmdUI *pCmdUI);
  afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
};

#ifndef _DEBUG  // ConsoleView.cpp t@CfobO̎gp܂B
inline CConsoleDoc* CConsoleView::GetDocument()
   { return (CConsoleDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ ͑Os̒Oɒǉ̐錾}܂B

#endif // !defined(AFX_CONSOLEVIEW_H__EBAB000C_945C_49BF_BBF7_14BA82B2A658__INCLUDED_)
