/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: WinThread.cpp,v 1.5 2004/08/02 07:15:22 yoshihiko Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include "stdafx.h"
#include "win_shell.h"
#include "shell/satellite4.h"

#include "ConsoleDoc.h"
#include "ConsoleView.h"
#include "WinThread.h"
#include <stdio.h>
#include <conio.h>
#include <stdarg.h>
#include <string.h>
#include <math.h>
#include <direct.h>
#include "win32_console.h"

//global definition
extern CConsoleView* g_pConsole;
extern HANDLE hThread;
sl_shell* g_pShell;
HANDLE gWinShellEvent;
#define		ID_EXIT_SHELL		99999

/* All copy */
void samples_copy(FILE* demoptr, char *module, char *tmpdir)
{
    HANDLE hFind;
    WIN32_FIND_DATA fd;
    BOOL bResult = FALSE;
	CString strPath, pszName, strSrcPath, strDesPath, strDir;
	char srcdir[_MAX_PATH], desdir[_MAX_PATH];
	int pos;

    strPath = _T(module);
	strPath += _T("/");
    strPath += _T ("*.*");

    if ((hFind = ::FindFirstFile (strPath, &fd)) == INVALID_HANDLE_VALUE)
        return;

    do {

        if (fd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) {
			// if directory
			pszName = (LPCTSTR) &fd.cFileName;
			if ((pszName != _T (".")) && (pszName != _T (".."))) {
				// create directory
				strDir = _T(tmpdir);
				strDir += _T("/");
				strDir += pszName;
				if(_mkdir(strDir) == 0) {
					/* set module name */
					fprintf(demoptr,"<%s>\n", pszName);
					//̃fBNgɃRs[
					sprintf(srcdir, "%s/%s", module, pszName);
					sprintf(desdir, "%s", strDir);
					samples_copy(demoptr, srcdir, desdir);
				}
			}
        }
		else {	// append 2003.5.27
            pszName = (LPCTSTR) &fd.cFileName;
			strSrcPath = _T(module);
			strSrcPath += _T("/");
			strSrcPath += pszName;
			strDesPath = _T(tmpdir);
			strDesPath += _T("/");
			strDesPath += pszName;
			if(!::CopyFile(strSrcPath, strDesPath, TRUE))
				return;
			else {
				/* set sample name */
				pos = pszName.Find(_T(".sl"));
				if(pos != -1)
					fprintf(demoptr,"%s\n",pszName);
			}
		}
    } while (::FindNextFile (hFind, &fd));

    ::FindClose (hFind);
}

/* set samples to temporary */
void samples_set()
{
	const char* tmpdir;
	char examples[_MAX_PATH],modules[_MAX_PATH];
	char demo[_MAX_PATH];
	FILE* demoptr = NULL;

	/* examples */
	if(GetModuleDirectory(modules,_MAX_PATH) == 0)
			return;
	strcat(modules, "/../examples");
	/* temporary */
	tmpdir = get_tmpdir();
	if(!tmpdir)
		return;
	/* create examples */
	sprintf(examples, "%s/examples", tmpdir);
	if(_mkdir(examples) == 0) {
		/* create demo.ini */
		sprintf(demo, "%s/demo.ini", examples);
		if((demoptr = fopen(demo, "w")) == NULL)
			return;
		/* copy examples */
		samples_copy(demoptr, modules, examples); 
	}
	if(demoptr)
		fclose(demoptr);
}

void symbol_callback_func(int event, symbol_t *sym, void *data)
{
  SL_Object  *obj;
  SL_OBJ::TYPE otype;
  HWND hwnd;
  hwnd = (HWND)data;

  switch(event){
  case SYMBOL_EVENT_DELETE:
    break;
  case SYMBOL_EVENT_UPDATE:
    /* check symbol type */
    if(symbol_get_type(sym) != SYMBOL_TYPE_VAR){
      return;
    }

    /* check object */
    obj = symbol_get_object(sym);
    if(obj == NULL){
      DestroyWindow(hwnd);
      return;
    }

    /* check object type */
    otype = obj->TypeofOBJ();
    if(otype != SL_OBJ::SERIES_O && otype != SL_OBJ::SNAPSHOT_O
		&& otype != SL_OBJ::STRING_O && otype != SL_OBJ::SCALAR_O){
      DestroyWindow(hwnd);
      return;
    }
    /* Set var'information */
	if(g_pConsole) {
		g_pConsole->UpdateVar(sym);
	}
    break;
  }
}

/* test code for symbol event callback */
void symbol_var_event_callback(int event, symbol_t *sym){
   switch(event){
   case SYMLIST_EVENT_ADD:
	 /*g_pConsole*/
	 if(g_pConsole) {
		g_pConsole->AddVar(sym);
		/* set callback event */
		symbol_add_callback(sym, symbol_callback_func, g_pConsole->GetSafeHwnd());
	 }
     break;
   case SYMLIST_EVENT_DELETE:
	   if(g_pConsole) {
		 g_pConsole->DeleteVar(sym);
	   }
     break;
   }
}

/* test code for module event callback */
void module_event_callback(int event, module_t *mod){

   switch(event){
   case MODULE_EVENT_NEW:
     break;
   case MODULE_EVENT_LOAD:
	 if(g_pConsole) {
		g_pConsole->ModuleLoad(mod->module_name, mod->ini_file);
	 }
     break;
   case MODULE_EVENT_UNLOAD:
     //printf("module unload -> %s (%d:commands)\n",
     //       mod->module_name,mod->commands->nkeys);
     break;
   case MODULE_EVENT_DELETE:
     //printf("module delete -> %s\n", mod->module_name);
     break;
   }

}


// threads
void __cdecl CreateShellThread(CConsoleView* pConsole)
{
	DWORD threadID;
	int	rtval;

	// define event
	gWinShellEvent = CreateEvent(0, TRUE, FALSE, NULL);

	// create shell thread
	hThread = CreateThread( 0, 0,
		(LPTHREAD_START_ROUTINE)Satellite4Shell, pConsole, 0, &threadID);
	rtval = GetThreadPriority( hThread );
	if(rtval == THREAD_PRIORITY_ERROR_RETURN) {
		AfxMessageBox("GetThreadPriority error.",MB_OK,NULL);
	}
	if(!SetThreadPriority(hThread, THREAD_PRIORITY_BELOW_NORMAL)) {
		AfxMessageBox("SetThreadPriority error.",MB_OK,NULL);
	}

	//waitkernelI܂ő҂
	WaitForSingleObject(gWinShellEvent, INFINITE);
	CloseHandle(gWinShellEvent);
	// Exit windows
	g_pConsole->PostMessage(ID_TTY_EXIT, 0, 0L);
}

// CTtyWndR\[ƂĎgp
DWORD __cdecl Satellite4Shell( CConsoleView* pConsole )
{
	win32_console *console;
	sl_shell *pshell;
	symbol_t   *sym = NULL;

	console = new win32_console;
	console->SetConsoleView(pConsole);
	g_pConsole = pConsole;
	pshell = new sl_shell(console);
	if(pshell->initialize(NULL,NULL)) {
		/***** test code for symbol event callback *****/
		symlist_set_var_callback(symbol_var_event_callback);
		/***** test code for module event callback *****/
		module_set_callback(module_event_callback);
		/**** copy samples ****/
		samples_set();
		/* main loop */
		pshell->shell_main();
	}

	delete pshell;
	delete console;
	/* saved documents */
	AfxGetApp()->SaveAllModified();
	/* Exit windows */
	pConsole->PostMessage(ID_TTY_EXIT, 0, 0L);
	return 0;
}

/* Copy files */
void CopyFiles()
{
}
