/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: MainFrm.cpp,v 1.8 2004/08/02 07:15:22 yoshihiko Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include "stdafx.h"
#include "win_shell.h"
#include "shell/satellite4.h"

#include "MainFrm.h"
#include "ConsoleDoc.h"
#include "ConsoleView.h"
#include "DemoDoc.h"
#include "config.h"
//TODO:helpproj
#include "htmlhelp.h"
#include ".\mainfrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define		CMDBAR_INDEX	10

#define		SHOW_TOOLBAR	9998
extern CMultiDocTemplate* g_pConsoleDocTemplate;
extern CSingleDocTemplate* g_pDemoDocTemplate;
CDemoDoc* g_pDemoDoc = NULL;

//global definition
extern CConsoleView* g_pConsole;
extern HANDLE gWinShellEvent;

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CMDIFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CMDIFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_COMMAND(ID_CONSOLE, OnConsole)
	ON_UPDATE_COMMAND_UI(ID_CONSOLE, OnUpdateConsole)
	ON_COMMAND(ID_FILEVIEWER, OnFileviewer)
	ON_UPDATE_COMMAND_UI(ID_FILEVIEWER, OnUpdateFileviewer)
	ON_COMMAND(ID_WORKSPACE, OnWorkspace)
	ON_UPDATE_COMMAND_UI(ID_WORKSPACE, OnUpdateWorkspace)
	ON_WM_DESTROY()
	ON_COMMAND(ID_CMDVIEW, OnCmdview)
	ON_UPDATE_COMMAND_UI(ID_CMDVIEW, OnUpdateCmdview)
	ON_COMMAND(ID_HELP_DEMO, OnHelpDemo)
	ON_UPDATE_COMMAND_UI(ID_HELP_DEMO, OnUpdateHelpDemo)
	//}}AFX_MSG_MAP
	// O[o wv R}h
	ON_COMMAND(ID_HELP_FINDER, CMDIFrameWnd::OnHelpFinder)
	ON_COMMAND(ID_HELP, CMDIFrameWnd::OnHelp)
	ON_COMMAND(ID_CONTEXT_HELP, CMDIFrameWnd::OnContextHelp)
	ON_COMMAND(ID_DEFAULT_HELP, CMDIFrameWnd::OnHelpFinder)
	ON_MESSAGE(ID_EXIT_SHELL, OnExitShell)
	ON_WM_SYSCOMMAND()
	ON_MESSAGE(SHOW_TOOLBAR, OnShowToolbar)
	ON_MESSAGE(CONSOLE_ACTIVE, OnConsoleActive)
	ON_WM_HELPINFO()
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // Xe[^X C CWP[^
	ID_INDICATOR_KANA,
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame NX̍\z/

CMainFrame::CMainFrame()
{
	// TODO: ̈ʒuɃȍR[hǉĂB
	m_bShowToolbar = TRUE;
	m_nOpenWindow = -1;
}

CMainFrame::~CMainFrame()
{

}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CMDIFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	if (!m_wndToolBar.CreateEx(this, TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // 쐬Ɏs
	}

    if (!CreateStatusBar ())
        return -1;

	// TODO: c[ o[hbLO\ɂȂꍇ͈ȉ̂Rs폜
	//       ĂB
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar);

	CRect rcWindow;
	rcWindow.left = AfxGetApp()->GetProfileInt(VERSION,"main_left",0);
	rcWindow.top = AfxGetApp()->GetProfileInt(VERSION,"main_top",0);
	rcWindow.right = AfxGetApp()->GetProfileInt(VERSION,"main_right",512);
	rcWindow.bottom = AfxGetApp()->GetProfileInt(VERSION,"main_bottom",320);
	this->MoveWindow(rcWindow);

	// Set title
	char title[_MAX_PATH];
	sprintf(title, PACKAGE_STRING);
	this->SendMessage(WM_SETTEXT,0,(LPARAM)title);

	// Create Viewer
	int open;
	// Create FileViewer
	open = AfxGetApp()->GetProfileInt(VERSION,"drive_enable",FALSE);
	CreateFileViewer(open);
	if(open)
		OnFileviewerOpen();
	// Create WorkspaceViewer
	open = AfxGetApp()->GetProfileInt(VERSION,"work_enable",FALSE);
	CreateWorkViewer(open);
	if(open)
		OnWorkspaceOpen();
	// Create CommandViewer
	open = AfxGetApp()->GetProfileInt(VERSION,"cmd_enable",FALSE);
	CreateCmdViewer(open);
	if(open)
		OnCmdviewOpen();

	CDocControlBar::GlobalLoadState(_T("BarState"));
	LoadBarState(_T("BarState"));

	// Initilize HTML Help
	::HtmlHelp(NULL,NULL,HH_INITIALIZE,(DWORD)&m_dwCookie);

	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	//ǉ^Cg\Ȃ
	cs.style &= ~FWS_ADDTOTITLE;

	if( !CMDIFrameWnd::PreCreateWindow(cs) )
		return FALSE;

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame NX̐ff

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CMDIFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CMDIFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame bZ[W nh

LRESULT CMainFrame::OnExitShell(WPARAM wParam, LPARAM lParam)
{
	//AfxMessageBox("Exit:MainFrame",MB_OK,NULL);
	SetEvent(gWinShellEvent);
	return 0L;
}


void CMainFrame::OnConsole() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	
}

void CMainFrame::OnUpdateConsole(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	
}

//
// Open Fileviewer
void CMainFrame::OnFileviewer() 
{
	BOOL bShow = m_wndDriveBar.IsVisible();
	if(!bShow) {
	if(!m_wndDriveBar.GetStatus())
		m_wndDriveBar.SetTree();
	}
	else {
		m_wndDriveBar.m_szHorz = CSize(80,80);
		m_wndDriveBar.m_szVert = CSize(80,80);
		m_wndDriveBar.m_szFloat = CSize(80,80);
	}
	ShowControlBar(&m_wndDriveBar, !bShow, FALSE);
}

void CMainFrame::OnUpdateFileviewer(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable();
	pCmdUI->SetCheck(m_wndDriveBar.IsVisible());
}

//
// Open WorkspaceViewer
void CMainFrame::OnWorkspace() 
{
	BOOL bShow = m_wndWorkBar.IsVisible();
	if(!bShow) {
	if(!m_wndWorkBar.GetStatus())
		m_wndWorkBar.SetTree();
	}
	else {
		m_wndWorkBar.m_szHorz = CSize(80,80);
		m_wndWorkBar.m_szVert = CSize(80,80);
		m_wndWorkBar.m_szFloat = CSize(80,80);
	}
	ShowControlBar(&m_wndWorkBar, !bShow, FALSE);
}

void CMainFrame::OnUpdateWorkspace(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable();
	pCmdUI->SetCheck(m_wndWorkBar.IsVisible());
}

void CMainFrame::OnSysCommand(UINT nID, LPARAM lParam)
{
	if(nID == SC_CLOSE) {
		char cmdline[_MAX_PATH];
		strcpy(cmdline, "exit\n");
		int i,ch,len;
		DWORD size;

		//A command is transmitted. 
		len = (int)strlen(cmdline);
		for(i=0; i<len; i++){
			ch = (unsigned char)cmdline[i];
			WriteFile(g_pConsole->m_hStdinW, &ch, sizeof(int), &size, NULL);
		}
	}
	else
		CMDIFrameWnd::OnSysCommand(nID, lParam);
}

void CMainFrame::OnDestroy() 
{
	WINDOWPLACEMENT wndpl;

	// Main
	GetWindowPlacement(&wndpl);
	AfxGetApp()->WriteProfileInt(VERSION,"main_left",wndpl.rcNormalPosition.left);
	AfxGetApp()->WriteProfileInt(VERSION,"main_top",wndpl.rcNormalPosition.top);
	AfxGetApp()->WriteProfileInt(VERSION,"main_right",wndpl.rcNormalPosition.right);
	AfxGetApp()->WriteProfileInt(VERSION,"main_bottom",wndpl.rcNormalPosition.bottom);

	// HTML Help
	::HtmlHelp(NULL, NULL, HH_UNINITIALIZE, (DWORD)m_dwCookie);

	CMDIFrameWnd::OnDestroy();

	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉĂ
}

void CMainFrame::OnFileviewerOpen()
{
	if(!m_wndDriveBar.GetStatus())
		m_wndDriveBar.SetTree();
	ShowControlBar(&m_wndDriveBar, TRUE, FALSE);
}

void CMainFrame::OnWorkspaceOpen()
{
	if(!m_wndWorkBar.GetStatus())
		m_wndWorkBar.SetTree();
	ShowControlBar(&m_wndWorkBar, TRUE, FALSE);
}

BOOL CMainFrame::CreateStatusBar()
{
    static UINT nIndicators[] = {
        ID_SEPARATOR,
        ID_INDICATOR_LINE,
        ID_INDICATOR_CAPS,
        ID_INDICATOR_NUM
    };

    if (!m_wndStatusBar.Create (this))
        return FALSE;

    m_wndStatusBar.SetIndicators (nIndicators, 4);
    return TRUE;
}

void CMainFrame::OnCmdviewOpen()
{
	if(!m_wndCmdBar.GetStatus())
		m_wndCmdBar.SetTree();
	ShowControlBar(&m_wndCmdBar, TRUE, FALSE);
}

void CMainFrame::OnCmdview() 
{
	BOOL bShow = m_wndCmdBar.IsVisible();
	if(!bShow) {
	if(!m_wndCmdBar.GetStatus())
		m_wndCmdBar.SetTree();
	}
	else {
		m_wndCmdBar.m_szHorz = CSize(80,80);
		m_wndCmdBar.m_szVert = CSize(80,80);
		m_wndCmdBar.m_szFloat = CSize(80,80);
	}
	ShowControlBar(&m_wndCmdBar, !bShow, FALSE);
}

void CMainFrame::OnUpdateCmdview(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable();
	pCmdUI->SetCheck(m_wndCmdBar.IsVisible());
}


void CMainFrame::OnHelpDemo() 
{
	if(g_pDemoDoc) {
		/*It will close, if open. */
		g_pDemoDoc->OnCloseDocument();
		return;
	}
	//It checks whether a command can be executed. 
	if(!CheckHelpDemo())
		return;

	// DemoEBhEJ
	CDocument*	pDocument;
	CFrameWnd*	pWnd;
	pDocument = g_pDemoDocTemplate->CreateNewDocument();
	if(!pDocument) {
		AfxMessageBox("Command:CreateNewDocument error", MB_OK, NULL);
		return;
	}
	pWnd = g_pDemoDocTemplate->CreateNewFrame(pDocument, NULL);
	if(pWnd) {
		//position and size
		CRect rcWindow;
		rcWindow.left = AfxGetApp()->GetProfileInt(VERSION,"demo_left",0);
		rcWindow.top = AfxGetApp()->GetProfileInt(VERSION,"demo_top",0);
		rcWindow.right = AfxGetApp()->GetProfileInt(VERSION,"demo_right",640);
		rcWindow.bottom = AfxGetApp()->GetProfileInt(VERSION,"demo_bottom",480);
		pWnd->MoveWindow(rcWindow);
		g_pDemoDocTemplate->InitialUpdateFrame(pWnd, pDocument, TRUE);
	}
	else {	// error
		AfxMessageBox("Work:CreateNewFrame error.", MB_OK, NULL);
		return;
	}
	g_pDemoDoc = (CDemoDoc *)pDocument;
	
}

BOOL CMainFrame::CheckHelpDemo()
{
	char pathname[_MAX_PATH];
	FILE* fp;
	CString strLine,strLeft;
	int nCount = 0;
	const char* tmpdir;

	/*The path to module is acquired. */
	tmpdir = get_tmpdir();
	if(!tmpdir)
		return FALSE;
	/*The path to demo.ini is acquired. */
	sprintf(pathname, "%s/examples/", tmpdir);
	strcat(pathname, "demo.ini");

	if((fp = fopen(pathname, "r")) == NULL) {
		MessageBox("Demo.ini can't open.", "DemoViewer", MB_OK | MB_ICONERROR | 
             MB_TASKMODAL | MB_SETFOREGROUND | MB_TOPMOST);
		return FALSE;
	}

#if 0
	fg = FALSE;
	while(!feof(fp)) {
		if(fgets(linebuf, _MAX_PATH, fp) == NULL)
			break;
		/*looking for '{'*/
		strLine = _T(linebuf);
		pos = strLine.Find(_T("{"));
		pos1 = strLine.Find(_T("}"));
		if(!fg && pos != -1) {
			/*A root item is set up. */
			fg = TRUE;
			nCount++;
		}
		else if(fg && pos1 != -1) {
			fg = FALSE;
		}
		else if(fg) {
			/*A child item is set up. */
			if(!CheckDemoChild(strLine))
				return FALSE;
		}
	}
	fclose(fp);
#endif
	return TRUE;
}

BOOL CMainFrame::CheckDemoChild(CString str)
{
	int pos;
	CString strLine,strRight,strLeft;
	char msg[_MAX_PATH];
	char modulepath[_MAX_PATH],pathname[_MAX_PATH];

	/*The path to module is acquired. */
	if(GetModuleDirectory(modulepath,_MAX_PATH) == 0)
			return FALSE;
	strcat(modulepath, "/../examples/");
	/*title*/
	strLine = str;
	pos = strLine.Find(_T("\""));
	strRight = strLine.Mid(pos+1);
	pos = strRight.Find(_T("\""));
	strLeft = strRight.Left(pos);
	/*readme*/
	strLine = strRight.Mid(pos+1);
	pos = strLine.Find(_T("\""));
	strRight = strLine.Mid(pos+1);
	pos = strRight.Find(_T("\""));
	strLeft = strRight.Left(pos);
	if(strLeft.GetLength() > 0) {
		sprintf(pathname, "%s%s", modulepath, strLeft);
		if(Access(pathname,SL_FATTR_FOK) != 0) {
			/*Can't open*/
			sprintf(msg, "%s can't open.", strLeft);
		MessageBox(msg, "DemoViewer", MB_OK | MB_ICONERROR | 
             MB_TASKMODAL | MB_SETFOREGROUND | MB_TOPMOST);
			return FALSE;
		}
	}

	/*script*/
	strLine = strRight.Mid(pos+1);
	pos = strLine.Find(_T("\""));
	strRight = strLine.Mid(pos+1);
	pos = strRight.Find(_T("\""));
	strLeft = strRight.Left(pos);
	if(strLeft.GetLength() > 0) {
		sprintf(pathname, "%s%s", modulepath, strLeft);
		if(Access(pathname,SL_FATTR_FOK) != 0) {
			/*Can't open*/
			sprintf(msg, "%s can't open.", strLeft);
		MessageBox(msg, "DemoViewer", MB_OK | MB_ICONERROR | 
             MB_TASKMODAL | MB_SETFOREGROUND | MB_TOPMOST);
			return FALSE;
		}
	}
	/*model*/
	strLine = strRight.Mid(pos+1);
	pos = strLine.Find(_T("\""));
	strRight = strLine.Mid(pos+1);
	pos = strRight.Find(_T("\""));
	strLeft = strRight.Left(pos);
	if(strLeft.GetLength() > 0) {
		sprintf(pathname, "%s%s", modulepath, strLeft);
		if(Access(pathname,SL_FATTR_FOK) != 0) {
			/*Can't open*/
			sprintf(msg, "%s can't open.", strLeft);
		MessageBox(msg, "DemoViewer", MB_OK | MB_ICONERROR | 
             MB_TASKMODAL | MB_SETFOREGROUND | MB_TOPMOST);
			return FALSE;
		}
	}

	return TRUE;
}

void CMainFrame::OnUpdateHelpDemo(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	if(!g_pDemoDoc)
		pCmdUI->SetCheck(0);
	else
		pCmdUI->SetCheck(1);
}

/*toolbar̕\/\pɂƍĂ݂AgpӖȂ*/
void CMainFrame::ShowToolbar(BOOL cmdShow)
{
	if(!cmdShow)
		ShowControlBar(&m_wndToolBar, FALSE, FALSE);
	else
		ShowControlBar(&m_wndToolBar, TRUE, TRUE);
}

LRESULT CMainFrame::OnShowToolbar(WPARAM wParam, LPARAM lParam)
{
	//ShowToolbar(wParam);
	if(!wParam)
		m_bShowToolbar = FALSE;
	else
		m_bShowToolbar = TRUE;
	return 0L;
}

BOOL CMainFrame::CreateCmdViewer(int open)
{
	// Create CommandViewer
	CString sTitle;
	CRect rcWindow;
	CSize size;
	DWORD dwStyle = 0;

	sTitle.Format(_T("CommandViewer"));
    if (!m_wndCmdBar.Create(sTitle, this, CSize(80,80),
            TRUE, ID_CMD_BAR))//AFX_IDW_CONTROLBAR_FIRST + 33 + i))
    {
		TRACE0("Failed to create CommandViewer\n");
		return FALSE;      // fail to create
	}
    // CBRS_SIZE_DYNAMIC allows the bar to be resized when floating
	dwStyle = m_wndCmdBar.GetBarStyle();
	dwStyle &= ~CBRS_TOOLTIPS;
	m_wndCmdBar.SetBarStyle(dwStyle |
		CBRS_FLYBY | CBRS_SIZE_DYNAMIC);
    EnableDocking(CBRS_ALIGN_ANY);
	m_wndCmdBar.EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndCmdBar, AFX_IDW_DOCKBAR_LEFT);

	ShowControlBar(&m_wndCmdBar, FALSE, FALSE);

	return TRUE;
}

// 9997ƃbZ[W
LRESULT CMainFrame::OnConsoleActive(WPARAM wParam, LPARAM lParam)
{
	MDIActivate(g_pConsole->GetParent());
	return 0L;
}

BOOL CMainFrame::CreateWorkViewer(int open)
{
	// Create WorkViewer
	CString sTitle;
	CRect rcWindow;
	CSize size;
	DWORD dwStyle = 0;

	sTitle.Format(_T("WorkspaceViewer"));
    if (!m_wndWorkBar.Create(sTitle, this, CSize(80,80),
            TRUE, ID_WORK_BAR))//AFX_IDW_CONTROLBAR_FIRST + 33 + i))
    {
		TRACE0("Failed to create WorkspaceViewer\n");
		return FALSE;      // fail to create
	}
    // CBRS_SIZE_DYNAMIC allows the bar to be resized when floating
	dwStyle = m_wndWorkBar.GetBarStyle();
	dwStyle &= ~CBRS_TOOLTIPS;
	m_wndWorkBar.SetBarStyle(dwStyle |
		CBRS_FLYBY | CBRS_SIZE_DYNAMIC);
    EnableDocking(CBRS_ALIGN_ANY);
	m_wndWorkBar.EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndWorkBar, AFX_IDW_DOCKBAR_LEFT);

	ShowControlBar(&m_wndWorkBar, FALSE, FALSE);

	return TRUE;
}

BOOL CMainFrame::CreateFileViewer(int open)
{
	// Create CommandViewer
	CString sTitle;
	CRect rcWindow;
	CSize size;
	DWORD dwStyle = 0;

	sTitle.Format(_T("FileViewer"));
    if (!m_wndDriveBar.Create(sTitle, this, CSize(80,80)/*size*/,
            TRUE, ID_DRIVE_BAR))//AFX_IDW_CONTROLBAR_FIRST + 33 + i))
    {
		TRACE0("Failed to create FileViewer\n");
		return FALSE;      // fail to create
	}
    // CBRS_SIZE_DYNAMIC allows the bar to be resized when floating
	dwStyle = m_wndDriveBar.GetBarStyle();
	dwStyle &= ~CBRS_TOOLTIPS;
	m_wndDriveBar.SetBarStyle(dwStyle |
		CBRS_FLYBY | CBRS_SIZE_DYNAMIC);
    EnableDocking(CBRS_ALIGN_ANY);
	m_wndDriveBar.EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndDriveBar, AFX_IDW_DOCKBAR_LEFT);

	ShowControlBar(&m_wndDriveBar, FALSE, FALSE);

	return TRUE;
}

BOOL CMainFrame::DestroyWindow() 
{
	BOOL bShow;

	// CommandViewer
	bShow = m_wndCmdBar.IsVisible();
	if(bShow) {
		AfxGetApp()->WriteProfileInt(VERSION,"cmd_enable",TRUE);
	}
	else {
		AfxGetApp()->WriteProfileInt(VERSION,"cmd_enable",FALSE);
	}

	// FileViewer
	bShow = m_wndDriveBar.IsVisible();
	if(bShow) {
		AfxGetApp()->WriteProfileInt(VERSION,"drive_enable",TRUE);
	}
	else {
		AfxGetApp()->WriteProfileInt(VERSION,"drive_enable",FALSE);	
	}

	// WorkViewer
	bShow = m_wndWorkBar.IsVisible();
	if(bShow) {
		AfxGetApp()->WriteProfileInt(VERSION,"work_enable",TRUE);
	}
	else {
		AfxGetApp()->WriteProfileInt(VERSION,"work_enable",FALSE);	
	}

	CDocControlBar::GlobalSaveState(_T("BarState"));
    SaveBarState(_T("BarState"));

	return CMDIFrameWnd::DestroyWindow();
}

void CMainFrame::WinHelp(DWORD dwData, UINT nCmd)
{
	// TODO : ɓȃR[hǉ邩A͊{NXĂяoĂB

	//CMDIFrameWnd::WinHelp(dwData, nCmd);

	// ŏ CWin::WinHelp ֐̕KvȏRs[܂B

	CWinApp* pApp = AfxGetApp();
	ASSERT_VALID(pApp);
	ASSERT(pApp->m_pszHelpFilePath != NULL);

	CWaitCursor wait;
	if (IsFrameWnd())
	{
		// CFrameWnd windows should be allowed to exit help mode first
		CMDIFrameWnd* pFrameWnd = (CMDIFrameWnd*)this;
		pFrameWnd->ExitHelpMode();
	}

	// cancel any tracking modes
	SendMessage(WM_CANCELMODE);
	SendMessageToDescendants(WM_CANCELMODE, 0, 0, TRUE, TRUE);

	// need to use top level parent (for the case where m_hWnd is in DLL)
	CWnd* pWnd = GetTopLevelParent();
	pWnd->SendMessage(WM_CANCELMODE);
	pWnd->SendMessageToDescendants(WM_CANCELMODE, 0, 0, TRUE, TRUE);

	// attempt to cancel capture
	HWND hWndCapture = ::GetCapture();
	if (hWndCapture != NULL)
		::SendMessage(hWndCapture, WM_CANCELMODE, 0, 0);


	//  HTML wvpɏ̂łB

	// HTML Help t@C݂̑`FbN
	CString hp = pApp->m_pszHelpFilePath;
	CFileStatus st;
	if ( !CFile::GetStatus(hp,st) )
	{
		CString str;
		str.Format( "Not Exist Html Help File\n\n   File Path [ %s ]", hp );
		AfxMessageBox(str);
		return;
	}

	// wv\
	DWORD dwID;
	switch( nCmd )
	{
	case HELP_CONTEXT:// ReLXgwv (F1/Shift+F1/HelpButton/?Button)
		dwID = (dwData & 0xffff) + 0x10000;
		::HtmlHelp(m_hWnd,hp,HH_HELP_CONTEXT,/*dwID*/dwData);
		break;
	case HELP_FINDER:
		::HtmlHelp(m_hWnd,hp,HH_DISPLAY_TOPIC,NULL);
		break;
	}
}

BOOL CMainFrame::OnHelpInfo(HELPINFO* pHelpInfo)
{
	// TODO : ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	//return CMDIFrameWnd::OnHelpInfo(pHelpInfo);
	return TRUE;
}
