/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: DemoWnd.cpp,v 1.4 2004/07/11 03:41:18 yoshihiko Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include "stdafx.h"
#include "win_shell.h"
#include "shell/satellite4.h"

#include "ConsoleDoc.h"
#include "ConsoleView.h"
#include "DemoDoc.h"
#include "DemoView.h"
#include "CodeView.h"
#include "DemoWnd.h"
#include <stdio.h>
#include <direct.h>
#include ".\demownd.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//global definition
extern CConsoleView* g_pConsole;
extern char g_charScriptText[_MAX_PATH];
extern CDemoDoc* g_pDemoDoc;

/////////////////////////////////////////////////////////////////////////////
// CDemoWnd

IMPLEMENT_DYNCREATE(CDemoWnd, CFrameWnd)

CDemoWnd::CDemoWnd()
{
}

CDemoWnd::~CDemoWnd()
{
}


BEGIN_MESSAGE_MAP(CDemoWnd, CFrameWnd)
	//{{AFX_MSG_MAP(CDemoWnd)
	ON_WM_CREATE()
	ON_WM_DESTROY()
	ON_COMMAND(ID_APP_EXIT, OnAppExit)
	//}}AFX_MSG_MAP
	// O[o wv R}h
	ON_COMMAND(ID_HELP_FINDER, CFrameWnd::OnHelpFinder)
	ON_MESSAGE(ID_SCRIPT_EXE, OnScriptExe)
	ON_MESSAGE(ID_SCRIPT_QUIT, OnScriptQuit)
	ON_WM_HELPINFO()
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDemoWnd bZ[W nh

BOOL CDemoWnd::OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext) 
{
	// A split window is created. 

    if (!m_wndSplitter.CreateStatic (this, 1, 2) ||
        !m_wndSplitter.CreateView (0, 1, RUNTIME_CLASS
            (CCodeView), CSize (0, 0), pContext) ||
        !m_wndSplitter.CreateView (0, 0, RUNTIME_CLASS (CDemoView),
            CSize (192, 0), pContext))
        return FALSE;
	
	return TRUE;
}

BOOL CDemoWnd::PreCreateWindow(CREATESTRUCT& cs) 
{
	/*A title is added later.*/ 
	cs.style &= ~FWS_ADDTOTITLE;
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	return TRUE;

}

int CDemoWnd::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	// Create toolbar
	if (!m_wndToolBar.CreateEx(this, TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC) ||
		!m_wndToolBar.LoadToolBar(IDR_DEMOBAR))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // 쐬Ɏs
	}
	// Create statusbar
    if (!CreateStatusBar ())
        return -1;
	// Change icon
	HICON hIcon = AfxGetApp()->LoadIcon(IDI_DEMO);
	ASSERT(hIcon);
	this->SendMessage(WM_SETICON, TRUE, (LPARAM)hIcon);
	// Set title
	char title[_MAX_PATH];
	sprintf(title, "DemoViewer");
	this->SendMessage(WM_SETTEXT,0,(LPARAM)title);
	
	return 0;
}

LRESULT CDemoWnd::OnScriptExe(WPARAM wParam, LPARAM lParam)
{
	char cmdline[_MAX_PATH],drv[_MAX_PATH],dir[_MAX_PATH];
	char fname[_MAX_PATH],ext[_MAX_PATH];
	char curdir[_MAX_PATH];
	char tmpdir[_MAX_PATH];
	int i,ch,len,cnt,*cmdbuf;
	DWORD size;
	CString str;

	//The script for performing is created. 
	_getcwd(curdir, _MAX_PATH);
	_splitpath(g_charScriptText, drv, dir, fname, ext);
	dir[strlen(dir)-1] = '\0';
	sprintf(tmpdir,"%s%s",drv,dir);
	_chdir(tmpdir);
	sprintf(cmdline,"inline(\"%s%s\")\n",fname,ext);
	
	if(wParam == INLINE_MODE) {
		//A command is transmitted. 
		len = (int)strlen(cmdline);
		for(i=0,cnt = 0; i<len; i++){
			ch = (unsigned char)cmdline[i];
			if(ch & 0x80)
				cnt += 1;
			WriteFile(g_pConsole->m_hStdinW, &ch, sizeof(int), &size, NULL);
		}

		// SẴR[h]̂ŁAScripts...
		// ̒lfNgĒ~]
		g_pConsole->m_bScriptRun = TRUE;
		//A button is controlled. 
		g_pConsole->m_charCodeAddr = (int)strlen(cmdline) - cnt -1;
	}
	else {
		//It transmits one character at a time. 
		int	el,ret,lcnt = 0;
		char buf[256],msg[_MAX_PATH];
		FILE *fp;
		CString str;

		fp = fopen(g_charScriptText, "r");
		if(!fp)
			return 0L;

		g_pConsole->m_bInputMode = TRUE;
		while(!feof(fp)) {
			if(fgets(buf,256,fp) == NULL)
				break;
			lcnt++;
			fprintf(stdout,"%s\n",buf);
			if(buf[0] != '#') {
				len = (int)strlen(buf);
				cmdbuf = (int *)malloc((len+1)*sizeof(int));
				for(el = 0; el < len; el++) {
					cmdbuf[el] = (unsigned char)buf[el];
				}
				cmdbuf[len]=0;
				WriteFile(g_pConsole->m_hStdinW,cmdbuf, sizeof(int)*(len+1), &size, NULL);
				free(cmdbuf);
			}
			else {
				/* ## is message */
				if(buf[0] == '#' && buf[1] == '#') {
					//Only one line is transmitted. 
					buf[strlen(buf)-1] = '\0';
					//sprintf(msg,"%s\nPlease click the OK button.",&buf[2]);
					sprintf(msg,"line:%d\n%s",lcnt,&buf[2]);
					ret = ::MessageBox(NULL,msg, PACKAGE_STRING,
						MB_OKCANCEL | MB_ICONINFORMATION);
					if(ret == IDCANCEL)
						break;
				}
			}
		}
		fclose(fp);
		g_pConsole->m_bInputMode = FALSE;
	}

	return 0L;
}

LRESULT CDemoWnd::OnScriptQuit(WPARAM wParam, LPARAM lParam)
{
	setsigint_win32();
	g_pConsole->m_bScriptRun = FALSE;
	return 0L;
}

void CDemoWnd::OnDestroy() 
{
	CDocument* pDocument;
	pDocument = GetActiveDocument();
	if(!pDocument)
		return;

	WINDOWPLACEMENT wndpl;
	GetWindowPlacement(&wndpl);

	if(pDocument->IsKindOf(RUNTIME_CLASS(CDemoDoc))) {
	AfxGetApp()->WriteProfileInt(VERSION,"demo_left",wndpl.rcNormalPosition.left);
	AfxGetApp()->WriteProfileInt(VERSION,"demo_top",wndpl.rcNormalPosition.top);
	AfxGetApp()->WriteProfileInt(VERSION,"demo_right",wndpl.rcNormalPosition.right);
	AfxGetApp()->WriteProfileInt(VERSION,"demo_bottom",wndpl.rcNormalPosition.bottom);
	g_pDemoDoc = NULL;
	}

	CFrameWnd::OnDestroy();
	
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉĂ
	
}

void CDemoWnd::OnAppExit() 
{
	char cmdline[_MAX_PATH];
	strcpy(cmdline, "exit\n");
	int i,ch,len;
	DWORD size;

	//A command is transmitted. 
	len = (int)strlen(cmdline);
	for(i=0; i<len; i++){
		ch = (unsigned char)cmdline[i];
		WriteFile(g_pConsole->m_hStdinW, &ch, sizeof(int), &size, NULL);
	}
	
}

BOOL CDemoWnd::CreateStatusBar()
{
    static UINT nIndicators[] = {
        ID_SEPARATOR,
        ID_INDICATOR_LINE,
        ID_INDICATOR_CAPS,
        ID_INDICATOR_NUM
    };

    if (!m_wndStatusBar.Create (this))
        return FALSE;

    m_wndStatusBar.SetIndicators (nIndicators, 4);
    return TRUE;
}


BOOL CDemoWnd::OnHelpInfo(HELPINFO* pHelpInfo)
{
	// TODO : ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	//return CFrameWnd::OnHelpInfo(pHelpInfo);
	return TRUE;
}
