/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: DemoView.cpp,v 1.8 2004/08/02 07:15:22 yoshihiko Exp $ */

#include "stdafx.h"
#include "win_shell.h"
#include "shell/satellite4.h"

#include "DemoView.h"
#include "ConsoleDoc.h"
#include "ConsoleView.h"
#include <direct.h>
#include ".\demoview.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//global definition
extern CConsoleView* g_pConsole;
extern char g_charScriptText[_MAX_PATH];

#define		ILO_ROOT			0
#define		ILO_MODULE			1
#define		ILO_SCRIPT			2

/////////////////////////////////////////////////////////////////////////////
// CDemoView

IMPLEMENT_DYNCREATE(CDemoView, CTreeView)

CDemoView::CDemoView()
{
	m_backColor = GetSysColor(COLOR_WINDOW);
	m_hParent = NULL;
}

CDemoView::~CDemoView()
{
}

BEGIN_MESSAGE_MAP(CDemoView, CTreeView)
	//{{AFX_MSG_MAP(CDemoView)
	ON_NOTIFY_REFLECT(TVN_SELCHANGED, OnSelchanged)
	ON_COMMAND(ID_SCRIPT_RUN, OnScriptRun)
	ON_UPDATE_COMMAND_UI(ID_SCRIPT_RUN, OnUpdateScriptRun)
	ON_COMMAND(ID_SCRIPT_STOP, OnScriptStop)
	ON_UPDATE_COMMAND_UI(ID_SCRIPT_STOP, OnUpdateScriptStop)
	ON_WM_CREATE()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
	ON_WM_HELPINFO()
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDemoView `

void CDemoView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: ̈ʒuɕ`p̃R[hǉĂ
}

/////////////////////////////////////////////////////////////////////////////
// CDemoView ff

#ifdef _DEBUG
void CDemoView::AssertValid() const
{
	CTreeView::AssertValid();
}

void CDemoView::Dump(CDumpContext& dc) const
{
	CTreeView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CDemoView bZ[W nh

void CDemoView::OnInitialUpdate() 
{
	CTreeView::OnInitialUpdate();
	
	// initialize
	Initialize();
	
}

void CDemoView::Initialize()
{
	// Create the Image List
	if(!m_ImageList.Create(IDB_CMDLIST, 16, 0, RGB(255,0,255))) {
		AfxMessageBox("CImageList.Create()G[", MB_OK, NULL);
		return;
	}
	m_ImageList.SetBkColor(GetSysColor(COLOR_WINDOW));

	// Attach image list to Tree
	GetTreeCtrl ().SetImageList(&m_ImageList, TVSIL_NORMAL);

	// Create demo tree 
	SetInitDemo();
}

void CDemoView::SetInitDemo()
{
	/*The number equivalent to parent is detected. */
	GetDemoParent();
}

void CDemoView::GetDemoParent()
{
	char pathname[_MAX_PATH],linebuf[_MAX_PATH],title[_MAX_PATH];
	FILE* fp;
	CString strLine,strLeft,strRoot,strChild,strTitle;
	int pos,pos1,nCount = 0;
	BOOL fg;
	HTREEITEM hParent;
	const char* tmpdir;

	/*The path to demo.ini is acquired. */
	tmpdir = get_tmpdir();
	if(!tmpdir)
		return;
	sprintf(pathname, "%s/examples/", tmpdir);
	strcat(pathname, "demo.ini");

	if((fp = fopen(pathname, "r")) != NULL) {
		fg = FALSE;
		while(!feof(fp)) {
			if(fgets(linebuf, _MAX_PATH, fp) == NULL)
				break;
			/*looking for '{'*/
			linebuf[strlen(linebuf)-1] = '\0';
			strLine = _T(linebuf);
			pos = strLine.Find(_T("<"));
			pos1 = strLine.Find(_T(">"));
			if(pos != -1 && pos1 != -1) {
				strLeft = strLine.Left(pos1);
				strRoot = strLeft.Mid(pos+1);
				/*A root item is set up. */
				strcpy(title, strRoot);
				hParent = AddItemRoot(title, ILO_MODULE, ILO_MODULE);
				nCount++;
			}
			else {
				/*A child item is set up. */
				/* set path */
				strChild = strRoot + _T("/") + strLine;
				/* get title */
				strTitle = GetDemoTitle(strRoot, strLine);
				if(strTitle.Compare(_T("")) != NULL)
					GetDemoChild(hParent, strTitle, strChild);
			}
		}
		fclose(fp);
	}
}

CString CDemoView::GetDemoTitle(CString parent, CString child)
{
	char pathname[_MAX_PATH],linebuf[_MAX_PATH];
	FILE* fp;
	CString strTitle = _T("");
	CString strTmp;
	const char* tmpdir;
	int pos;
	char *cptr;

	/*The path to demo.ini is acquired. */
	tmpdir = get_tmpdir();
	if(!tmpdir)
		return strTitle;
	sprintf(pathname, "%s/examples/%s/", tmpdir, parent);
	strcat(pathname, "README.eng");
	if((fp = fopen(pathname, "r")) == NULL)
		return strTitle;
	while(!feof(fp)) {
		if(fgets(linebuf, _MAX_PATH, fp) == NULL)
			break;
		linebuf[strlen(linebuf)-1] = '\0';
		strTmp = _T(linebuf);
		pos = strTmp.Find(_T("=========="));
		if(pos != -1)
			break;
		pos = strTmp.Find(child);
		if(pos != -1) {
			// ̍s^CgƂ
			if(fgets(linebuf, _MAX_PATH, fp) == NULL)
				return strTitle;
			linebuf[strlen(linebuf)-1] = '\0';
			// ŏ̃Xy[X^u폜
			cptr = linebuf;
			while(*cptr != '\0') {
				if(*cptr != ' ' && *cptr != '\t')
					break;
				cptr++;
			}
			strTitle = _T(cptr/*linebuf*/);
			return strTitle;
		}
	}
	fclose(fp);
	return strTitle;
}

void CDemoView::GetDemoChild(HTREEITEM hParent, CString strTitle, CString strPath)
{
	int pos;
	char title[_MAX_PATH];

	/* create data */
	CDemoInfo* pDemoInfo;
	pDemoInfo = new CDemoInfo;

	// ^Cg쐬
	// ́At@C
	pDemoInfo->title = strTitle;
	// readme
	pDemoInfo->readme = _T("");
	// XNvg
	pDemoInfo->script = strPath;
	// f
	pDemoInfo->model = _T("");
	// y[Wԍ
	pDemoInfo->page = 0;

	/*A readme is displayed by the default.  */
	pDemoInfo->exemode = /*CONSOLE_MODE*/INLINE_MODE;
	pos = strPath.Find(_T(".sl"));
	if(pos == -1) {
		pDemoInfo->exefg = FILE_TXT;
	}
	else {
		pDemoInfo->exefg = FILE_SL;
	}
	strcpy(title, pDemoInfo->title);
	AddItem(hParent, title, 0, ILO_SCRIPT, pDemoInfo);
}

HTREEITEM CDemoView::AddItemRoot(char *item, BOOL child, int image)
{
	HTREEITEM hItem;
    hItem = GetTreeCtrl ().InsertItem (item, image,
            image, TVI_ROOT);
	return hItem;

}

HTREEITEM CDemoView::AddItem(HTREEITEM hParent, char *item, BOOL children, int image, CDemoInfo *pDemoInfo)
{
	HTREEITEM hChild;
	hChild = GetTreeCtrl ().InsertItem (item, image, image, hParent);
	GetTreeCtrl ().SetItemData(hChild, (DWORD)pDemoInfo);
	return hChild;

}

BOOL CDemoView::PreCreateWindow(CREATESTRUCT& cs) 
{
	if (!CTreeView::PreCreateWindow (cs))
		return FALSE;

    cs.style |= TVS_HASLINES | TVS_LINESATROOT | TVS_HASBUTTONS |
        TVS_SHOWSELALWAYS/* | TVS_EDITLABELS*/;
	return TRUE;
}

void CDemoView::OnSelchanged(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;
	CDemoInfo* pItem;

	if(pNMTreeView->itemNew.hItem != NULL) {
		pItem = (CDemoInfo *)GetTreeCtrl ().GetItemData(pNMTreeView->itemNew.hItem);
		GetDocument ()->UpdateAllViews (this, 0x5C, (CObject*) pItem);
	}
	
	*pResult = 0;
}

void CDemoView::OnScriptRun() 
{	
	HTREEITEM hItem = GetTreeCtrl ().GetSelectedItem ();
	CDemoInfo* pDemoInfo;
	char pathname[_MAX_PATH];
	const char* tmpdir;
	pDemoInfo = (CDemoInfo*)GetTreeCtrl ().GetItemData(hItem);

	/*The module path is acquired.*/
	//if(GetModuleDirectory(modulepath,_MAX_PATH) == 0)
	tmpdir = get_tmpdir();
	if(!tmpdir)
		return;
	/*The script of a path is set up absolutely. */ 
	sprintf(pathname, "%s/examples/", tmpdir);
	strcat(pathname, pDemoInfo->script);
	strcpy(g_charScriptText, pathname);
	this->GetParentFrame()->PostMessage(ID_SCRIPT_EXE, pDemoInfo->exemode, 0L);
	/* Activate console */
	g_pConsole->SetFocus();
}

void CDemoView::OnUpdateScriptRun(CCmdUI* pCmdUI) 
{
	CDemoInfo* pDemoInfo;
	HTREEITEM hItem = GetTreeCtrl ().GetSelectedItem ();
	if(hItem) {
		pDemoInfo = (CDemoInfo*)(GetTreeCtrl ().GetItemData(hItem));
		if(pDemoInfo) {
			if(pDemoInfo->exefg != FILE_SL)
				pCmdUI->Enable(FALSE);
			else {
				if(g_pConsole->m_bScriptRun)
					pCmdUI->Enable(FALSE);
				else
					pCmdUI->Enable(TRUE);
			}
		}
		else
			pCmdUI->Enable(FALSE);
	}
	else
		pCmdUI->Enable(FALSE);
	
}

void CDemoView::OnScriptStop() 
{
	this->GetParentFrame()->PostMessage(ID_SCRIPT_QUIT, 0, 0L);
	
}

void CDemoView::OnUpdateScriptStop(CCmdUI* pCmdUI) 
{
	if(g_pConsole->m_bScriptRun)
		pCmdUI->Enable(TRUE);
	else
		pCmdUI->Enable(FALSE);
	
}

int CDemoView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CTreeView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	/*background color is set*/
	GetTreeCtrl().SetBkColor(m_backColor);
	return 0;
}

void CDemoView::OnDestroy() 
{
	HTREEITEM hParent,hChild;
	CDemoInfo* pItem;

	hParent = GetTreeCtrl().GetRootItem();
	while(1) {
		if(!hParent)
			break;
		hChild = GetTreeCtrl().GetChildItem(hParent);
		while (hChild != NULL) {
			pItem = (CDemoInfo *)GetTreeCtrl().GetItemData(hChild);
			if(pItem)
				delete pItem;
			hChild = GetTreeCtrl().GetNextSiblingItem (hChild);
		}
		pItem = (CDemoInfo *)GetTreeCtrl().GetItemData(hParent);
		if(pItem)
			delete pItem;
		hParent = GetTreeCtrl().GetNextSiblingItem (hParent);
	}


	CTreeView::OnDestroy();
	
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉĂ
	
}


BOOL CDemoView::OnHelpInfo(HELPINFO* pHelpInfo)
{
	// TODO : ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	return CTreeView::OnHelpInfo(pHelpInfo);
}
