/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: Dde.cpp,v 1.3 2004/05/18 08:05:22 yoshihiko Exp $ */
#include <windows.h>
#include <stdio.h>
#include <ddeml.h>
#include "libsatellite.h"

#define		PDF_PAGE			0
#define		PDF_TEXT			1

const char *REG_INSTALL_KEY_ACROBAT = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\App Paths\\Acrobat.exe";
const char *REG_INSTALL_KEY_READER = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\App Paths\\AcroRd32.exe";
const char *ACRO_DDESERVER = "acroview";
const char *ACRO_DDETOPIC = "control";
void ContextHelp(const char *text, int mode);

HDDEDATA CALLBACK DDE_ProcessMessage (UINT uType, UINT uFmt, HCONV hconv, HSZ hsz1, HSZ hsz2,
									  HDDEDATA hdata, DWORD dwData1, DWORD dwData2)
{
	return NULL;
}

static int GetPage(char *path, char *key)
{
	FILE *fp;
	char strkey[64],strpage[64],line[_MAX_PATH];
	int page;

	if((fp = fopen(path, "r")) == NULL)
		return -1;
	page = -1;
	while(!feof(fp)) {
		fgets(line, _MAX_PATH, fp);
		line[strlen(line)-1] = '\0';
		sscanf(line,"%s %s",strkey,strpage);
		if(_stricmp(strkey, _strupr(key)) == NULL) {
			page = atoi(strpage);
			break;
		}
	}
	fclose(fp);
	return page+1;
}

void ContextHelp(const char *text, int mode) 
{
	char	keyword[_MAX_PATH];
	char	module_path[_MAX_PATH];
	char	doc_path[_MAX_PATH];
	char	*tmp;
	int page;

	if(strlen(text)==0)
		return;
	tmp = GetModuleDirectory(module_path, _MAX_PATH);
	sprintf(doc_path,"%s\\..\\doc\\page.txt",module_path);
	if(mode == PDF_PAGE) {
		strcpy(keyword, text);
		page = GetPage(doc_path, keyword);
		if(page == -1)
			return;
	}

	//Acrobat
	DWORD pathBuf[MAX_PATH + 1];
	DWORD size = MAX_PATH + 1;
	long lRetCode;
	HKEY hkey;

	// Determine if a PDF viewer is installed.
	lRetCode = RegOpenKeyEx(HKEY_LOCAL_MACHINE, REG_INSTALL_KEY_ACROBAT, 0, KEY_READ, &hkey);
	if (lRetCode == ERROR_SUCCESS) {
retry:
		// Get the path to the viewer executable and launch it.
		lRetCode = RegQueryValueEx (hkey, "", 0, 0, (unsigned char *)pathBuf, &size);
		RegCloseKey (hkey);

		STARTUPINFO startupInfo;
		memset (&startupInfo, 0, sizeof(STARTUPINFO));
		startupInfo.cb = sizeof(STARTUPINFO);

		PROCESS_INFORMATION processInfo;
		memset (&processInfo, 0, sizeof(PROCESS_INFORMATION));

		// Launch the viewer.
		CreateProcess ((const char *)pathBuf, NULL, NULL, NULL, false, NORMAL_PRIORITY_CLASS,
						NULL, NULL, &startupInfo, &processInfo);

		// Give application some launch time. A better approach is used in
		// BuildIndexDde.cpp.
		//Sleep (8000);

	} else {
		lRetCode = RegOpenKeyEx(HKEY_LOCAL_MACHINE, REG_INSTALL_KEY_READER, 0, KEY_READ, &hkey);
		if (lRetCode == ERROR_SUCCESS)
			goto retry;

		// Advertise the problem and bail.
		::MessageBox (NULL,"No PDF Viewer installed. Aborting...", "DdeOpen - Error",MB_OK);
		return;
	}

	char ddeCmdBuf[_MAX_PATH];
	char ddePageBuf[_MAX_PATH];
	UINT retVal;

	DWORD id = 0;

	// Start the DDE work now that the viewer is launched.
	memset (ddeCmdBuf, 0, sizeof(ddeCmdBuf));
	memset (ddePageBuf, 0, sizeof(ddePageBuf));
	if(mode == PDF_PAGE) {
		sprintf(doc_path,"%s\\..\\doc\\SATELLITE_reference-j.pdf",module_path);
		sprintf(ddeCmdBuf,"[DocOpen(\"%s\")]",doc_path);
		sprintf(ddePageBuf,"[DocGoTo(\"%s\",%d)]",doc_path,page);
	}
	else {
		sprintf(doc_path,"%s\\..\\doc\\SATELLITE_users-j.pdf",module_path);
		sprintf(ddeCmdBuf,"[DocOpen(\"%s\")]",doc_path);
		//sprintf(ddePageBuf,"[DocFind(\"%s\",\"%s\",false,true,true)]",doc_path,text);
		sprintf(ddePageBuf,"[DocGoTo(\"%s\",%d)]",doc_path,atoi(text));
	}
	retVal = DdeInitialize (&id, &DDE_ProcessMessage, APPCMD_CLIENTONLY, 0);
	if (DMLERR_NO_ERROR == retVal) {

		DWORD dwResult;
		HCONV hConversation = NULL;
		HSZ hszServerName, hszTopicName;

		// Initialize DDE conversation with server.
		hszServerName = DdeCreateStringHandle (id, ACRO_DDESERVER, 0);
		hszTopicName = DdeCreateStringHandle (id, ACRO_DDETOPIC, 0);
dde_loop:
		hConversation = DdeConnect (id, hszServerName, hszTopicName, NULL);

		retVal = DdeGetLastError (id);
		if (DMLERR_NO_ERROR != retVal) {
			//MessageBox (NULL, "Could not connect to server.", "DdeOpen - Error", MB_OK);
			Sleep(1000);
			goto dde_loop;
		}
		else {
			// Execute the DDE Command.
			DdeClientTransaction ((unsigned char *)ddeCmdBuf, (DWORD)strlen(ddeCmdBuf), (HCONV)hConversation,
									NULL, (UINT)CF_TEXT, (UINT)XTYP_EXECUTE, (DWORD)1000, &dwResult);
			retVal = DdeGetLastError (id);
			//if (DMLERR_NO_ERROR != retVal)
			//	::MessageBox (NULL, "Could not execute.", "Dde - Error", MB_OK);
			// Execute the DDE Command.
			DdeClientTransaction ((unsigned char *)ddePageBuf, (DWORD)strlen(ddePageBuf), (HCONV)hConversation,
									NULL, (UINT)CF_TEXT, (UINT)XTYP_EXECUTE, (DWORD)1000, &dwResult);
			retVal = DdeGetLastError (id);
			if (DMLERR_NO_ERROR != retVal) {
				//Rgł悢
				//::MessageBox (NULL, "Could not execute.", "Dde - Error", MB_OK);
			}
			DdeDisconnect (hConversation);
		}

		// Release resources.
		DdeFreeStringHandle (id, hszServerName);
		DdeFreeStringHandle (id, hszTopicName);
		DdeUninitialize (id);

	} else
		::MessageBox (NULL, "Failed to initialize DDE.", "DdeOpen - Error", MB_OK);
}
