/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: ConsoleDoc.h,v 1.2 2004/05/18 08:05:22 yoshihiko Exp $ */

#if !defined(AFX_CONSOLEDOC_H__149A141F_A0B7_4885_8E64_FF48A1DBBF48__INCLUDED_)
#define AFX_CONSOLEDOC_H__149A141F_A0B7_4885_8E64_FF48A1DBBF48__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/////////////////////////////////////////////////////////////////////////////
// CConsoleDoc hLg

class CConsoleDoc : public CDocument
{
protected:
	CConsoleDoc();           // IɎgpveNg RXgN^B
	DECLARE_DYNCREATE(CConsoleDoc)

// Agr[g
private:
	CSize  m_RealSize;
	CSize  m_LogicalSize;
	CPoint m_sCopyArea;
	CPoint m_eCopyArea;
	char **m_TextBuffer;
	int  **m_TextAttrib;
	int  *m_TextInfo;
	// OnSizeɎgp
	CSize  m_SaveRealSize;
	CSize  m_SaveLogicalSize;
	char **m_SaveTextBuffer;
	int  **m_SaveTextAttrib;

public:
	CString	m_textBuffer[MAX_CONSOLE_SIZE];
	short	m_textAttr[MAX_CONSOLE_SIZE][256];
	short	m_textCrPos[MAX_CONSOLE_SIZE];
	int		m_textAddr;
	CPtrArray	m_varArray;			//@SATELLITEŒ`ꂽϐ

// Iy[V
private:
  void ScrollCopyTextBuffer();
  BOOL ChkSpaceLine(char *linebuf, int len);
  void FreeTextBuffer();
  BOOL AllocateTextBuffer(int x, int y);
  // OnSizeɎgp
  void FreeSaveTextBuffer();
  BOOL AllocateSaveTextBuffer(int x, int y);
public:
  BOOL InitializeTextBuffer(int xinit, int maxline);
  BOOL ResizeTextBuffer(int x, int y);
  BOOL ScrollTextBuffer(bool dir);
  BOOL SaveTextBuffer(int xpos, int ypos, int attr, const char *str, size_t len);
  void ClearSelectedBuffer();
  BOOL SelectTextBuffer(int xs, int ys, int xe, int ye);
  const char *GetTextBuffer(int xp, int yp);
  int  GetTextAttribute(int xp, int yp);
  BOOL SetTextBufferToClipboard();
  BOOL InitializeSaveTextBuffer(int xlen, int ylen);
  int CopyTextBuffer(int linenum);
  BOOL SaveTextBuffer(char *name);

public:
	int		AddVar(char *buf);

// I[o[Ch
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂B
	//{{AFX_VIRTUAL(CConsoleDoc)
	public:
	virtual void Serialize(CArchive& ar);   // hLg I/O ɑ΂ăI[o[Ch܂B
	protected:
	virtual BOOL SaveModified();
	//}}AFX_VIRTUAL

// Cve[V
public:
	virtual ~CConsoleDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// bZ[W }bv֐̐
protected:
	//{{AFX_MSG(CConsoleDoc)
		//  - ClassWizard ͂̈ʒuɃo֐ǉ܂͍폜܂B
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ ͑Os̒Oɒǉ̐錾}܂B

#endif // !defined(AFX_CONSOLEDOC_H__149A141F_A0B7_4885_8E64_FF48A1DBBF48__INCLUDED_)
