/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: ComDoc.cpp,v 1.1.1.1 2004/03/31 08:15:06 orrisroot Exp $ */

#include "stdafx.h"
#include "win_shell.h"

#include "ComDoc.h"
#include "fileutil.h"
#include <direct.h>
#include <io.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CComDoc

IMPLEMENT_DYNCREATE(CComDoc, CDocument)

BEGIN_MESSAGE_MAP(CComDoc, CDocument)
	//{{AFX_MSG_MAP(CComDoc)
	ON_COMMAND(ID_FILE_SAVE, OnFileSave)
	ON_COMMAND(ID_FILE_SAVE_AS, OnFileSaveAs)
	ON_UPDATE_COMMAND_UI(ID_FILE_SAVE_AS, OnUpdateFileSaveAs)
	ON_UPDATE_COMMAND_UI(ID_FILE_SAVE, OnUpdateFileSave)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BEGIN_DISPATCH_MAP(CComDoc, CDocument)
	//{{AFX_DISPATCH_MAP(CComDoc)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
		//        ̈ʒuɐR[hҏWȂłB
	//}}AFX_DISPATCH_MAP
END_DISPATCH_MAP()

// : VBA oChĂ^Cv Z[tT|[g邽߂ IID_IWin_shell  ̃T|[gǉ܂B
//        IID ́A.ODL t@C̒̃fBXvC^[tFCXɃA^b`Ă GUID Ƀ}b`Ă 
//       ΂Ȃ܂B 

// {25C1DB2F-3982-484C-9BC6-C9D3465FD345}
static const IID IID_IWin_shell =
{ 0x25c1db2f, 0x3982, 0x484c, { 0x9b, 0xc6, 0xc9, 0xd3, 0x46, 0x5f, 0xd3, 0x45 } };

BEGIN_INTERFACE_MAP(CComDoc, CDocument)
	INTERFACE_PART(CComDoc, IID_IWin_shell, Dispatch)
END_INTERFACE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CComDoc NX̍\z/

CComDoc::CComDoc()
{
	// TODO: ̈ʒuɂPxĂ΂\zp̃R[hǉĂB

	//EnableAutomation();

	//AfxOleLockApp();
}

CComDoc::~CComDoc()
{
	//AfxOleUnlockApp();
}

BOOL CComDoc::OnNewDocument()
{

	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: ̈ʒuɍďǉĂB
	// (SDI hLg͂̃hLgėp܂B)

	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
// CComDoc VAC[[V

void CComDoc::Serialize(CArchive& ar)
{
	// CEditView ׂ͂ẴVAC[[V nĥǂꂩ̃GfBbgRg[܂ł܂B
	((CEditView*)m_viewList.GetHead())->SerializeRaw(ar);
}

/////////////////////////////////////////////////////////////////////////////
// CComDoc NX̐ff

#ifdef _DEBUG
void CComDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CComDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CComDoc R}h

BOOL CComDoc::CanCloseFrame(CFrameWnd* pFrame) 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	
	//return CDocument::CanCloseFrame(pFrame);
	return TRUE;
}

void CComDoc::DeleteContents() 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	
	CDocument::DeleteContents();
}

BOOL CComDoc::SaveModified() 
{
	// ۑ
	if(IsModified()) {
		//ύX
		if(SaveFile())
			SetModifiedFlag(FALSE);	//no change
	}
	return TRUE;
}


BOOL CComDoc::OnOpenDocument(LPCTSTR lpszPathName) 
{
	if (!CDocument::OnOpenDocument(lpszPathName))
		return FALSE;
	
	// TODO: ̈ʒuɌŗL̍쐬pR[hǉĂ
	
	return TRUE;
}



void CComDoc::OnFileSave() 
{
	CString pszPath;
	if(IsModified()) {
		pszPath = GetPathName();
		if(_access(pszPath,0) != 0) {
			//ύX
			if(SaveFile())
				SetModifiedFlag(FALSE);	//no change
		}
		else {
			UpdateAllViews(NULL, 0x70, (CObject*)((LPCTSTR)pszPath));
			SetModifiedFlag(FALSE);	//no change
		}
	}	
}

void CComDoc::OnFileSaveAs() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	if(IsModified()) {
		//ύX
		if(SaveFile())
			SetModifiedFlag(FALSE);	//no change
	}
	
}

void CComDoc::OnUpdateFileSave(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	if(!IsModified())
		pCmdUI->Enable(FALSE);
	
}

void CComDoc::OnUpdateFileSaveAs(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	if(!IsModified())
		pCmdUI->Enable(FALSE);
	
}

BOOL CComDoc::SaveFile()
{
	LPCSTR	lpszFilter;
	CString pszPath;
	char	curdir[_MAX_PATH];

	pszPath = GetTitle();
	lpszFilter = "̧ (*.sl) | *.sl||";
	//CFileDialog	dlgFile(FALSE, ".sl",pszPath,OFN_HIDEREADONLY,lpszFilter);
	CFileUtil	dlgFile(FALSE, ".sl",pszPath,OFN_HIDEREADONLY,lpszFilter);
	dlgFile.m_ofn.lpstrTitle = "Save";
	dlgFile.m_ofn.lpstrInitialDir = _getcwd(curdir, _MAX_PATH);
	if(dlgFile.DoModal() == IDOK) {
		pszPath = dlgFile.GetPathName();
		//ۑ
		UpdateAllViews(NULL, 0x70, (CObject*)((LPCTSTR)pszPath));
		return TRUE;
	}
	return FALSE;	//no change
}

#if 0
void CComDoc::OnFileOpen() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	LPCSTR	lpszFilter;
	CString pszPath;
	char	curdir[_MAX_PATH];

	lpszFilter = "Script (*.sl) | *.sl|Model (*.mdl) | *.mdl|Text (*.txt) | *.txt||";
	CFileUtil	dlgFile(TRUE, _T(".sl"),_T(""),
		OFN_ALLOWMULTISELECT|OFN_FILEMUSTEXIST|OFN_SHOWHELP,
		lpszFilter, NULL);
	dlgFile.m_ofn.lpstrTitle = "Open";
	dlgFile.m_ofn.lpstrInitialDir = _getcwd(curdir, _MAX_PATH);
	if(dlgFile.DoModal() == IDOK) {
		pszPath = dlgFile.GetPathName();
		OnOpenDocument(pszPath);
		return;
	}
	return;	//no change
	
}

void CComDoc::OnUpdateFileOpen(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	
}

#endif


void CComDoc::OnCloseDocument() 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	if(IsModified()) {
		//ύX
		if(SaveFile())
			SetModifiedFlag(FALSE);	//no change
	}

	CDocument::OnCloseDocument();
}
