/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: CodeChgSub.cpp,v 1.1.1.1 2004/03/31 08:15:06 orrisroot Exp $ */
/////////////////////////////////////////////////////////////////////////////
//	Ӽޭ
//	  CodeChgSub.cpp
//	A Unix file is changed into a Windows file. 
/////////////////////////////////////////////////////////////////////////////

#include "StdAfx.h"

#include <stdlib.h>
#include <malloc.h>
#include <exception>
#include <New>

#include "CodeChgSub.h"

/////////////////////////////////////////////////////////////////////////////
//	StMemBlock::StMemBlock
/////////////////////////////////////////////////////////////////////////////
StMemBlock::StMemBlock(size_t nBytes)
{
	if(nBytes)
		NewBlock(nBytes);
	else
		m_pBlock = 0;
	m_Size = nBytes;
}

/////////////////////////////////////////////////////////////////////////////
//	StMemBlock::~StMemBlock
/////////////////////////////////////////////////////////////////////////////
 StMemBlock::~StMemBlock()
{
	Clear();
}

/////////////////////////////////////////////////////////////////////////////
//	StMemBlock::NewBlock
/////////////////////////////////////////////////////////////////////////////
void StMemBlock::NewBlock(size_t nBytes)
{
	m_pBlock = (char*)::malloc(nBytes);
	if(m_pBlock == NULL)
		throw std::bad_alloc();
	m_Size = nBytes;
}

/////////////////////////////////////////////////////////////////////////////
//	StMemBlock::Clear
/////////////////////////////////////////////////////////////////////////////
 void StMemBlock::Clear()
{
	if(m_pBlock)
	{
		::free(m_pBlock);
		m_pBlock = NULL;
	}
}

/////////////////////////////////////////////////////////////////////////////
//	StMemBlock::Resize
/////////////////////////////////////////////////////////////////////////////
 void StMemBlock::Resize(size_t nBytes)
{
	if(m_pBlock == NULL)
	{
		NewBlock(nBytes);
	}
	else
	{
		char* newBlock = (char*)::realloc(m_pBlock,nBytes);
		if(newBlock == NULL)
		{
			Clear();
			throw std::bad_alloc();
		}
		m_pBlock = newBlock;	
	}
	m_Size = nBytes;
}

/////////////////////////////////////////////////////////////////////////////
//	StMemBlock::[]
/////////////////////////////////////////////////////////////////////////////
char& StMemBlock::operator [](long pos)
{
	return m_pBlock[pos];
}
