/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: CmdCtrl.h,v 1.1 2004/05/18 07:53:46 yoshihiko Exp $ */

#if !defined(AFX_CMDCTRL_H__87088671_8749_4C19_9BE2_138320B30F3E__INCLUDED_)
#define AFX_CMDCTRL_H__87088671_8749_4C19_9BE2_138320B30F3E__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// CmdCtrl.h : wb_[ t@C
//

/////////////////////////////////////////////////////////////////////////////
// CCmdCtrl EBhE

class CCmdCtrl : public CTreeCtrl
{
// RXgNV
public:
	CCmdCtrl();

// Agr[g
public:
	CFont *m_font;
	HTREEITEM	m_hRoot;
	BOOL	m_contextFlag;
	CString m_strHelpText;
	CToolTipCtrl* m_pToolTip;
	CPoint m_curpos;
	HTREEITEM m_hCurItem;
protected:
	CImageList m_ilObjects;

// Iy[V
public:
	void Initialize();
	void Module(char *module_name, CPtrArray *pCmdArray);
	BOOL ToolTipNotify(NMHDR *pNMHDR);

protected:
	/*void ModuleList();*/
	HTREEITEM SetModuleName(HTREEITEM hParent, char *name);
	BOOL SetCommandList(HTREEITEM hParent, char *module_name, CPtrArray *pCmdArray);
	HTREEITEM SetCommandName(HTREEITEM hParent, CMDINFO* pItem);
	CImageList m_imageHelp;
	CString GetTooltipMsg(CMDINFO* pItem, CPoint point, CRect rect);
	CString GetArgMsg(int arg, CString msg, char *sdlm);

// I[o[Ch
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂B
	//{{AFX_VIRTUAL(CCmdCtrl)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

// Cve[V
public:
	virtual ~CCmdCtrl();

	// ꂽbZ[W }bv֐
protected:
	//{{AFX_MSG(CCmdCtrl)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSelchanging(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnCmdviewHelp();
	afx_msg void OnUpdateCmdviewHelp(CCmdUI* pCmdUI);
	//}}AFX_MSG
	//afx_msg BOOL OnToolTipNotify( UINT id, NMHDR *pNMHDR, LRESULT *pResult);
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ ͑Os̒Oɒǉ̐錾}܂B

#endif // !defined(AFX_CMDCTRL_H__87088671_8749_4C19_9BE2_138320B30F3E__INCLUDED_)
