/* 
 * Copyright (c) 2003-2004 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: win32_console.h,v 1.4 2005/02/23 07:46:50 orrisroot Exp $ */
#ifndef __WIN32_CONSOLE_H__
#define __WIN32_CONSOLE_H__

class win32_console : public tty_console {
private:
  HANDLE hStdin, hStdout, hStderr;
  HANDLE hCurProcess;
  SECURITY_ATTRIBUTES sa;
  WORD TextAttrib;
  CONSOLE_SCREEN_BUFFER_INFO cInfo;
  DWORD dwNormalModeIn, dwRawModeIn;
  DWORD dwNormalModeOut, dwRawModeOut;
  DWORD dwNormalModeErr, dwRawModeErr;

  bool          is_buffered;
  unsigned char cbuffer[2];
  bool oflag;
  bool isReverse;

  void tty_rawmode();
  void tty_normalmode();
  void term_getyx(int *y, int *x);
  void term_move(int y, int x);
  int  term_keypad_getc();

  virtual void  term_move_down(int y);
  virtual void  term_move_up(int y);
  virtual void  term_move_right(int x);
  virtual void  term_move_left(int x);
  virtual void  term_move_bol();
  virtual void  term_move_newline();
  virtual void  term_bell(){}
  virtual void  term_vbell(){}
  virtual void  term_clear_screen();
  virtual void  term_clear_eol(int x);
  virtual void  term_set_attr_normal();
  virtual void  term_set_attr_bold(){}
  virtual void  term_set_attr_reverse();
  virtual void  term_set_attr_underline(){}
  virtual bool  term_has_color(){ return true; }
  virtual void  term_putc(int c);
  virtual void  term_print(const char *str);
  virtual int   term_getc();
  virtual char* term_gets(char *buf, int size);
  virtual void  term_edit_mode(){ tty_rawmode(); }
  virtual void  term_normal_mode(){ tty_normalmode();}

public:
  win32_console();
  ~win32_console();
  void tty_init();
  void tty_normal();
  virtual void term_flush(sl4_fd_t fd);
  virtual void term_set_fgcolor(SL_TTY::COLOR color);
  virtual void term_set_bgcolor(SL_TTY::COLOR color);
  virtual void term_getmaxyx(int *y, int* x);
};

#endif

