/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: do2726c.cpp,v 1.1.1.1 2004/03/31 08:15:06 orrisroot Exp $ */
//
//	SLIO module
//	di2726c.cpp
//
//
//	The calling syntax is:
//
//	do2726c(board_num,data)
//

#include <windows.h>
#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#define  __IMPORTSYMBOL__
#include "libsatellite.h"
#undef   __IMPORTSYMBOL__
#include    "FbiDio.h"

#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int do2726c()
{
    int board_num;
	int data;
	char strDeviceName[_MAX_PATH];
	HINSTANCE   hinstDll;
	char path[_MAX_PATH],dll[_MAX_PATH];
	HANDLE     hDeviceHandle;    // handle
    DWORD      dwValue;    // _u[hf[^

	//system directory
	::GetSystemDirectory(path, _MAX_PATH);
	//whether Fbiad.dll is
	//Load the DLL.
	sprintf(dll,"%s\\fbidio.dll",path);
	hinstDll = ::LoadLibrary(dll);
	if(!hinstDll) {
		printf("Fbidio.dll not exist. (SLIO module)\n");
		return 5;
	}
	else {
		::FreeLibrary(hinstDll);
	}

	// board number
	board_num = (int)GetScalar(0);
	if(board_num < 1 || board_num > 16) {
		//board number error
		return(1);
	}
	/*Device name*/
	sprintf(strDeviceName, "FBIDIO%d", board_num);
	/*Device open*/
	hDeviceHandle = DioOpen(strDeviceName, 0);
	if(hDeviceHandle == INVALID_HANDLE_VALUE) {
		// error
		return 1;
	}

	// get data
	data = (int)GetScalar(1);
	dwValue = data;
	// output the data of 32bit width
    DioInputDword(hDeviceHandle, FBIDIO_IN1_32, &dwValue);

    // Device close
    DioClose(hDeviceHandle);

	return 0;
}

#ifdef __cplusplus
}
#endif
