/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: da3305stop.cpp,v 1.1.1.1 2004/03/31 08:15:06 orrisroot Exp $ */
//
//	I/O{[hW[
//	da3305stop.cpp
//
//	The calling syntax is:
//
//	void DAOutput(interval,data_buf,data_num,channel,board_num)
//

#include <windows.h>
#include <stdio.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#define  __IMPORTSYMBOL__
#include "libsatellite.h"
#undef   __IMPORTSYMBOL__
#include "FbiDa.h"

#ifdef __cplusplus
extern "C" {
#endif

static void dastop(int *board_num)
{
        HANDLE hDeviceHandle;
        char strDeviceName[256];

        /*Device name*/
        sprintf(strDeviceName, "FBIDA%d", *board_num);

        /*Device open*/
        hDeviceHandle = DaOpen(strDeviceName);
        if(hDeviceHandle == INVALID_HANDLE_VALUE)
                return;
                
        /* Device close */
        DaClose(hDeviceHandle);
}

DLLEXPORT int da3305stop()
{
	int board_num;
   
	//Check arguments
	if(GetArgNum() != 1)
		exit(1);

   /*Parmeters*/
	board_num = (int)GetScalar(0);

	/* DA stop */
	dastop(&board_num);
   
   return 0;
}

#ifdef __cplusplus
}
#endif
