/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: ncsdef.cpp,v 1.2 2004/05/19 04:15:11 yoshihiko Exp $ */

#include "stdafx.h"
#include "ncsdef.h"

#include "NcsdefDoc.h"
#include "NcsdefWnd.h"
#include "NcsdefInputPage.h"
#include "NcsdefOutputPage.h"
#include "NcsdefParamPage.h"
#include "NcsdefObsPage.h"
#include "NcsdefFuncPage.h"
#include "NcsdefSheet.h"
#include "NcsdefView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CSingleDocTemplate* g_pNcsdefTemplate;

#include "afxdllx.h"    // standard MFC Extension DLL routines

static AFX_EXTENSION_MODULE NEAR extensionDLL = { NULL, NULL };

extern "C" int APIENTRY
DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID lpReserved)
{
	if (dwReason == DLL_PROCESS_ATTACH)
	{
		// Extension DLL one-time initialization.
		if (!AfxInitExtensionModule(extensionDLL, hInstance))
		   return 0;

		// Other initialization could be done here, as long as
		// it doesn't result in direct or indirect calls to AfxGetApp.
		// This extension DLL needs to add doc templates to the
		// app object, so it waits for the application to boot
		// and call an initialization function (see below).
	}

   else if (dwReason == DLL_PROCESS_DETACH)
   {
		//if(g_pExtncsMain) {
		//	g_pExtncsMain->SetBlockClear();
		//	delete g_pExtncsMain;
		//}
   }
	return 1;   // ok
}

#ifdef __cplusplus
extern "C" {
#endif

// Exported DLL initialization is run in context of running application
//extern "C" void WINAPI NcsdefInit()
__declspec(dllexport) BOOL NcsdefExec(HANDLE hStdinW, CDocument* pDocument,
					CView* pConsoleView, CView* pModelView, CString strGroup)
{
	// create a new CDynLinkLibrary for this app
	new CDynLinkLibrary(extensionDLL);

	// Register the doc templates we provide to the app
	CWinApp* pApp = AfxGetApp();
	ASSERT(pApp != NULL);

	//ncsdefAL[LeN`
	CSingleDocTemplate* pDocTemplate;
	CNcsdefDoc*	pDoc;
	CNcsdefWnd*	pWnd;
	int pos;

	pDocTemplate = new CSingleDocTemplate(
		IDR_NCSDEF,
		RUNTIME_CLASS(CNcsdefDoc),
		RUNTIME_CLASS(CNcsdefWnd),       // C SDI t[ EBhE
		RUNTIME_CLASS(CNcsdefView));
	pApp->AddDocTemplate(pDocTemplate);

	pDoc = (CNcsdefDoc *)pDocTemplate->CreateNewDocument();
	if(pDoc) {
		//lȂ
	}
	else {	// error
		AfxMessageBox("Failed ncsdef.dll (CreateNewDocument)", MB_OK, NULL);
		return FALSE;
	}
	pWnd = (CNcsdefWnd *)pDocTemplate->CreateNewFrame(pDoc, NULL);
	if(pWnd) {
		//strGroupɃfݒ肳Ăꍇ́APɕҏWƂɂȂ
		pos = strGroup.Find(".mdl");
		if(pos != -1)
			pWnd->m_bModelEdit = TRUE;
		else
			pWnd->m_bModelEdit = FALSE;
		pDocTemplate->InitialUpdateFrame(pWnd, pDoc, TRUE);
		pWnd->m_hStdinW = hStdinW;
		pWnd->m_pModelView = pModelView;
		pWnd->m_pConsoleView = pConsoleView;
		pWnd->m_pModelDoc = pDocument;
		pWnd->m_strGroup = strGroup;
		//
		CNcsdefView* pView;
		char model[_MAX_PATH];

		if(pWnd->m_bModelEdit == TRUE) {
			pView = (CNcsdefView *)pWnd->GetActiveView();
			strcpy(model, strGroup);
			pView->LoadNcsModel(model);
		}
	}
	else {	// error
		AfxMessageBox("Failed ncsdef.dll (CreateNewFrame)", MB_OK, NULL);
		return FALSE;
	}

	// add other initialization here

	return TRUE;
}

#if 0
//extern "C" BOOL WINAPI NcsdefExec()
__declspec(dllexport) BOOL NcsdefExec()
{
	CNcsdefDoc*	pDoc;
	CNcsdefWnd*	pWnd;
	pDoc = (CModelDoc *)g_pModelTemplate->CreateNewDocument();
	if(pModelDoc) {
		//lȂ
	}
	else {	// error
		AfxMessageBox("Failed ncsdef.dll (CreateNewDocument)", MB_OK, NULL);
		return FALSE;
	}
	pModelWnd = (CModelWnd *)g_pModelTemplate->CreateNewFrame(pModelDoc, NULL);
	if(pModelWnd) {
		g_pModelTemplate->InitialUpdateFrame(pModelWnd, pModelDoc, TRUE);
		//if(!m_pModelWnd) {
		//	m_pModelWnd = pWnd;
		//}
	}
	else {	// error
		AfxMessageBox("create model error 2.", MB_OK, NULL);
		return FALSE;
	}
	return TRUE;
}
#endif

#ifdef __cplusplus
}
#endif

