/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: NcsdefWnd.cpp,v 1.4 2004/07/11 03:26:33 yoshihiko Exp $ */

#include "stdafx.h"
#include "ncsdef.h"

#include "NcsdefWnd.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

static UINT BASED_CODE buttons[] =
{
	ID_SEPARATOR,
	ID_SEPARATOR,
	ID_SEPARATOR,
	ID_SEPARATOR,
	ID_SEPARATOR,
	ID_SEPARATOR,
	ID_SEPARATOR,
	ID_SEPARATOR,
	ID_SEPARATOR,
	ID_SEPARATOR,
	ID_SEPARATOR,
	ID_SEPARATOR,
	ID_SEPARATOR,
	ID_SEPARATOR,
	ID_FILE_OPEN,
	ID_FILE_SAVE,
	ID_MODULE_CHECK,
	ID_MODULE_APPEND,
	ID_CONTEXT_HELP,
};

/////////////////////////////////////////////////////////////////////////////
// CNcsdefWnd

IMPLEMENT_DYNCREATE(CNcsdefWnd, CFrameWnd)

CNcsdefWnd::CNcsdefWnd()
{
}

CNcsdefWnd::~CNcsdefWnd()
{
}


BEGIN_MESSAGE_MAP(CNcsdefWnd, CFrameWnd)
	//{{AFX_MSG_MAP(CNcsdefWnd)
	ON_WM_CREATE()
	ON_WM_SHOWWINDOW()
	ON_COMMAND(ID_HELP, OnHelp)
	//}}AFX_MSG_MAP
	// O[o wv R}h
	ON_COMMAND(ID_HELP_FINDER, CFrameWnd::OnHelpFinder)
	ON_COMMAND(ID_HELP, CFrameWnd::OnHelp)
	ON_COMMAND(ID_CONTEXT_HELP, CFrameWnd::OnContextHelp)
	ON_COMMAND(ID_DEFAULT_HELP, CFrameWnd::OnHelpFinder)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNcsdefWnd bZ[W nh

int CNcsdefWnd::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	//ACR
	HICON hIcon;
	CButton* pButton;
	//tHg
	CFont*	pOldFont;
	m_font.CreateFont(16,
		0,0,0,FW_NORMAL,0,0,0,SHIFTJIS_CHARSET,
		OUT_STROKE_PRECIS,CLIP_DEFAULT_PRECIS,DRAFT_QUALITY,
		DEFAULT_PITCH,_T("MS PSVbN"));
	CDC*	dc = GetDC();
	pOldFont = dc->SelectObject(&m_font);
	//
	// Create the style bar.
	//
	if (!m_wndDlgBar.Create(this, IDD_NCSDEFBAR, WS_VISIBLE | CBRS_TOP,
			AFX_IDW_TOOLBAR))
	{
		TRACE0("Failed to create toolbar\n");
		return FALSE;       // 쐬Ɏs
	}
	m_wndDlgBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndDlgBar);
	m_wndDlgBar.SetWindowText("?????????");

	//Open
	hIcon = AfxGetApp()->LoadIcon(IDI_DEF_OPEN);
	pButton = (CButton *)m_wndDlgBar.GetDlgItem(ID_FILE_OPEN);
	pButton->SetIcon(hIcon);
	//Save
	hIcon = AfxGetApp()->LoadIcon(IDI_DEF_SAVE);
	pButton = (CButton *)m_wndDlgBar.GetDlgItem(ID_FILE_SAVE);
	pButton->SetIcon(hIcon);
	//Check
	hIcon = AfxGetApp()->LoadIcon(IDI_DEF_CHECK);
	pButton = (CButton *)m_wndDlgBar.GetDlgItem(ID_MODULE_CHECK);
	pButton->SetIcon(hIcon);
	//Append
	hIcon = AfxGetApp()->LoadIcon(IDI_DEF_APPEND);
	pButton = (CButton *)m_wndDlgBar.GetDlgItem(ID_MODULE_APPEND);
	pButton->SetIcon(hIcon);
	//Context help
	hIcon = AfxGetApp()->LoadIcon(IDI_DEF_HELP);
	pButton = (CButton *)m_wndDlgBar.GetDlgItem(ID_CONTEXT_HELP);
	pButton->SetIcon(hIcon);

	// ACR\[X[h
	hIcon = AfxGetApp()->LoadIcon(IDI_NCSDEF);
	ASSERT(hIcon);
	// EBhEɐVACRw肷
	this->SendMessage(WM_SETICON, TRUE, (LPARAM)hIcon);
	
	// ^Cg
	char title[_MAX_PATH];
	strcpy(title, "Module definition");
	this->SendMessage(WM_SETTEXT,0,(LPARAM)title);

	//
	m_wndDlgBar.EnableToolTips(TRUE);
	
	return 0;
}

void CNcsdefWnd::ChangeTitle(char* name)
{
	char title[_MAX_PATH];
	sprintf(title, "Module definition -[%s]",name);
	this->SendMessage(WM_SETTEXT,0,(LPARAM)title);
}

BOOL CNcsdefWnd::PreCreateWindow(CREATESTRUCT& cs) 
{
	cs.style &= ~FWS_ADDTOTITLE;
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	return TRUE;
}


void CNcsdefWnd::OnShowWindow(BOOL bShow, UINT nStatus) 
{
	CFrameWnd::OnShowWindow(bShow, nStatus);

	//TODO
	//IDC_DEF_NAMEɋNɃtH[JXڂ
	CEdit* pEdit;
	pEdit = (CEdit *)m_wndDlgBar.GetDlgItem(IDC_DEF_NAME);
	pEdit->SetFocus();
	
}


void CNcsdefWnd::OnHelp() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	AfxGetApp()->WinHelp(0x20000+IDR_NCSDEF, HELP_CONTEXT);
	
}

