/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: NcsdefView.cpp,v 1.4 2004/08/24 00:02:08 yoshihiko Exp $ */

#include "stdafx.h"
#include "ncsdef.h"

#include "NcsdefDoc.h"
#include "NcsdefInputPage.h"
#include "NcsdefOutputPage.h"
#include "NcsdefParamPage.h"
#include "NcsdefObsPage.h"
#include "NcsdefFuncPage.h"
#include "NcsdefSheet.h"
#include "NcsdefView.h"
#include "NcsdefWnd.h"
#include <direct.h>
#include "libsatellite.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CNcsdefView

IMPLEMENT_DYNCREATE(CNcsdefView, CFormView)

CNcsdefView::CNcsdefView()
	: CFormView(CNcsdefView::IDD)
{
	//{{AFX_DATA_INIT(CNcsdefView)
		// : ClassWizard ͂̈ʒuɃȍǉ܂
	//}}AFX_DATA_INIT
	m_strModelPath = _T("");
}

CNcsdefView::~CNcsdefView()
{
}

void CNcsdefView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CNcsdefView)
		// : ClassWizard ͂̈ʒu DDX  DDV ̌Ăяoǉ܂
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CNcsdefView, CFormView)
	//{{AFX_MSG_MAP(CNcsdefView)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	ON_UPDATE_COMMAND_UI(ID_FILE_OPEN, OnUpdateFileOpen)
	ON_COMMAND(ID_FILE_SAVE, OnFileSave)
	ON_UPDATE_COMMAND_UI(ID_FILE_SAVE, OnUpdateFileSave)
	ON_COMMAND(ID_MODULE_CHECK, OnModuleCheck)
	ON_UPDATE_COMMAND_UI(ID_MODULE_CHECK, OnUpdateModuleCheck)
	ON_COMMAND(ID_MODULE_APPEND, OnModuleAppend)
	ON_UPDATE_COMMAND_UI(ID_MODULE_APPEND, OnUpdateModuleAppend)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNcsdefView ff

#ifdef _DEBUG
void CNcsdefView::AssertValid() const
{
	CFormView::AssertValid();
}

void CNcsdefView::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}
#endif //_DEBUG

CNcsdefDoc* CNcsdefView::GetDocument()
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CNcsdefDoc)));
	return (CNcsdefDoc*)m_pDocument;
}

/////////////////////////////////////////////////////////////////////////////
// CNcsdefView bZ[W nh

void CNcsdefView::OnInitialUpdate() 
{
	CFormView::OnInitialUpdate();
	
	GetParentFrame()->RecalcLayout();
	ResizeParentToFit();

	if(m_ncsdefSheet.GetPageCount() == 0) {
		m_ncsdefSheet.AddPage(&m_defInputPage);
		m_ncsdefSheet.AddPage(&m_defOutputPage);
		m_ncsdefSheet.AddPage(&m_defParamPage);
		m_ncsdefSheet.AddPage(&m_defObsPage);
		m_ncsdefSheet.AddPage(&m_defFuncPage);
		m_ncsdefSheet.Create(this,WS_CHILD | WS_VISIBLE, NULL);
		CRect rect;
		m_ncsdefSheet.GetClientRect(&rect);
		m_ncsdefSheet.SetWindowPos(&wndTop, 0, 0, rect.right-rect.left,
			rect.bottom-rect.top, SWP_SHOWWINDOW);

	}
}

// ̓`FbN
BOOL CNcsdefView::CheckAllItem() 
{
	CListCtrl* pList;
	int nCount,item,lCount;
	char buf[256];
	INPUTITEM* iItem;
	PARAMITEM* pItem;
	OBSITEM* oItem;
	CEdit* pEdit;
	CNcsdefWnd* pWnd = (CNcsdefWnd *)GetParent();
	CDialogBar *pBar = &(pWnd->m_wndDlgBar);

	pEdit = (CEdit *)(pBar->GetDlgItem(IDC_DEF_NAME/*IDC_MODULE_NAME*/));
	pEdit->GetWindowText(buf, 256);

	pList = (CListCtrl *)m_defInputPage.GetDlgItem(IDC_INPUT_LIST);	
	nCount = pList->GetItemCount();
	for(item=0;item<nCount;item++) {
		iItem = (INPUTITEM*)pList->GetItemData(item);
	}

	pEdit = (CEdit *)m_defOutputPage.GetDlgItem(IDC_OUTPUT_NAME);
	pEdit->GetWindowText(buf, 256);

	pList = (CListCtrl *)m_defParamPage.GetDlgItem(IDC_PARAM_LIST);	
	nCount = pList->GetItemCount();
	for(item=0;item<nCount;item++) {
		pItem = (PARAMITEM*)pList->GetItemData(item);
	}

	pList = (CListCtrl *)m_defObsPage.GetDlgItem(IDC_OBS_LIST);	
	nCount = pList->GetItemCount();
	for(item=0;item<nCount;item++) {
		oItem = (OBSITEM*)pList->GetItemData(item);
	}

	pEdit = (CEdit *)m_defFuncPage.GetDlgItem(IDC_FUNC);
	nCount = pEdit->GetLineCount();
	for(item=0;item<nCount;item++) {
		lCount = pEdit->GetLine(item, buf);
		if(lCount > 0)
			buf[lCount] = '\0';
	}

	return TRUE;
}

// create
// ̓`FbN
BOOL CNcsdefView::CreateModel(const char *pathname) 
{
	CListCtrl* pList;
	int nCount,item,lCount;
	char buf[256];
	INPUTITEM* iItem;
	PARAMITEM* pItem;
	OBSITEM* oItem;
	CEdit* pEdit;
	FILE *fp;
	CNcsdefWnd* pWnd = (CNcsdefWnd *)GetParent();
	CDialogBar *pBar = &(pWnd->m_wndDlgBar);

	//Open
	if((fp = fopen(pathname, "w")) == NULL)
		return FALSE;

	//type
//KvȂ
	//fprintf(fp,"type:\t\tCELL;\n");
	//module
	pEdit = (CEdit *)(pBar->GetDlgItem(IDC_DEF_NAME/*IDC_MODULE_NAME*/));
	pEdit->GetWindowText(buf, 256);
	fprintf(fp,"module:\t\t%s;\n", buf);
	//input
	pList = (CListCtrl *)m_defInputPage.GetDlgItem(IDC_INPUT_LIST);
	nCount = pList->GetItemCount();
#if 0
	fprintf(fp,"exinput:\t\t");
	for(item=0;item<nCount;item++) {
		iItem = (INPUTITEM*)pList->GetItemData(item);
		if(item == nCount-1)
			fprintf(fp,"%s;\n",iItem->strName);
		else
			fprintf(fp,"%s,",iItem->strName);
	}
#else
	fprintf(fp,"exinput:\n");
	for(item=0;item<nCount;item++) {
		iItem = (INPUTITEM*)pList->GetItemData(item);
		if(item == nCount-1)
			fprintf(fp,"\t%s;\n",iItem->strName);
		else
			fprintf(fp,"\t%s,\n",iItem->strName);
	}
#endif
	//output
	pEdit = (CEdit *)m_defOutputPage.GetDlgItem(IDC_OUTPUT_NAME);
	pEdit->GetWindowText(buf, 256);
	fprintf(fp,"output:\t\t%s;\n", buf);

	// parameter
	pList = (CListCtrl *)m_defParamPage.GetDlgItem(IDC_PARAM_LIST);	
	nCount = pList->GetItemCount();
	if(nCount) {
#if 0
		fprintf(fp,"parameter:\t");
		for(item=0;item<nCount;item++) {
			pItem = (PARAMITEM*)pList->GetItemData(item);
			if(item == nCount-1)
				fprintf(fp,"%s=%f;\n",pItem->strName, atof(pItem->strValue));
			else
				fprintf(fp,"%s=%f,",pItem->strName,atof(pItem->strValue));
		}
#else
		fprintf(fp,"parameter:\n");
		for(item=0;item<nCount;item++) {
			pItem = (PARAMITEM*)pList->GetItemData(item);
			if(item == nCount-1)
				fprintf(fp,"\t%s=%f;\n",pItem->strName, atof(pItem->strValue));
			else
				fprintf(fp,"\t%s=%f,\n",pItem->strName,atof(pItem->strValue));
		}
#endif
	}

	// observable
	pList = (CListCtrl *)m_defObsPage.GetDlgItem(IDC_OBS_LIST);	
	nCount = pList->GetItemCount();
	if(nCount) {
#if 0
		fprintf(fp,"observable:\t");
		for(item=0;item<nCount;item++) {
			oItem = (OBSITEM*)pList->GetItemData(item);
			if(item == nCount-1)
				fprintf(fp,"%s;\n",oItem->strName);
			else
				fprintf(fp,"%s,",oItem->strName);
		}
#else
		fprintf(fp,"observable:\n");
		for(item=0;item<nCount;item++) {
			oItem = (OBSITEM*)pList->GetItemData(item);
			if(item == nCount-1)
				fprintf(fp,"\t%s;\n",oItem->strName);
			else
				fprintf(fp,"\t%s,\n",oItem->strName);
		}
#endif
	}

	pEdit = (CEdit *)m_defFuncPage.GetDlgItem(IDC_FUNC);
	nCount = pEdit->GetLineCount();
	fprintf(fp,"function:\n");
	for(item=0;item<nCount;item++) {
		lCount = pEdit->GetLine(item, buf);
		if(lCount > 0) {
			buf[lCount] = '\0';
#if 0
			fprintf(fp,"\t\t%s\n",buf);
#else
			if(buf[0] != ' ' && buf[0] != '\t')
				fprintf(fp,"\t%s\n",buf);
			else
				fprintf(fp,"%s\n",buf);
#endif
		}
		else
			fprintf(fp,"\n");
	}
	fprintf(fp,"end;\n");
	fclose(fp);

	return TRUE;
}

//ҏWmdlt@C`FbN

//ҏWmdlt@Cextncsɒǉ


//`ςmdlt@CJ
void CNcsdefView::OnFileOpen() 
{
	char	pathname[_MAX_PATH],model[_MAX_PATH];
	LPCSTR	lpszFilter;
	CString strPath,strName;
	CNcsdefDoc* pDoc = GetDocument();
	CNcsdefWnd* pWnd = (CNcsdefWnd *)GetParent();

	strcpy(pathname, "");
	lpszFilter = "Model (*.mdl) | *.mdl||";
	CFileDialog	dlgFile(TRUE, ".mdl",pathname,OFN_HIDEREADONLY,lpszFilter);
	dlgFile.m_ofn.lpstrTitle = "Model";
	dlgFile.m_ofn.lpstrInitialDir = _getcwd(pathname, _MAX_PATH);
	if(dlgFile.DoModal() == IDOK) {
		strPath = dlgFile.GetPathName();
		strName = dlgFile.GetFileName();
		strcpy(model, strPath);
		if(LoadNcsModel(model)) {
			//Load
			strcpy(model, strName);
			pWnd->ChangeTitle(model);
			//modulepX
			m_strModelPath = strPath;
		}
	}	
	
}

// ID_FILE_OPENR}h
BOOL CNcsdefView::LoadNcsModel(char *modelfile)
{
	FILE *fp;
	char line[MAX_PATH];
	BOOL modulefg,hitfg;
	int pos;
	CString strLine,strTmp,strType,strName;

	if((fp = fopen(modelfile, "r")) == NULL)
		return FALSE;
	//ݒ̈̍폜
	m_defInputPage.Clear(TRUE);
	m_defObsPage.Clear(TRUE);
	m_defParamPage.Clear(TRUE);
	m_defFuncPage.Clear();

	modulefg = TRUE;
	for(;;) {
		if(fgets(line, MAX_PATH, fp) == NULL)
			break;
		strLine = _T(line);
		pos = strLine.Find(_T("type:"));
		if(pos != -1) {
			//W[^Cv
			strTmp = strLine.Mid(pos+5);
			strType = GetModuleType(strTmp);
			//if(strType.GetLength() >0)
			//	modulefg = TRUE;
		}
		pos = strLine.Find(_T("module:"));
		if(modulefg && pos != -1) {
			//W[
			strTmp = strLine.Mid(pos+7);
			strName = GetModuleName(strTmp);
		}
		pos = strLine.Find(_T("exinput:"));
		if(modulefg && pos != -1) {
			//O
			strTmp = strLine.Mid(pos+8);
			GetModuleExinput(fp, strTmp);
		}
		pos = strLine.Find(_T("input:"));
		if(modulefg && pos != -1) {
			//mF
			if(pos == 0)
				hitfg = TRUE;
			else {
				if(strLine.GetAt(pos-1) == ' ')
					hitfg = TRUE;
				else
					hitfg = FALSE;
			}
			if(hitfg) {
				//
				strTmp = strLine.Mid(pos+6);
				GetModuleInput(fp, strTmp);
			}
		}
		pos = strLine.Find(_T("output:"));
		if(modulefg && pos != -1) {
			//o
			strTmp = strLine.Mid(pos+7);
			GetModuleOutput(fp, strTmp);
		}
		pos = strLine.Find(_T("observable:"));
		if(modulefg && pos != -1) {
			//j^[
			strTmp = strLine.Mid(pos+11);
			GetModuleObs(fp, strTmp);
		}
		pos = strLine.Find(_T("parameter:"));
		if(modulefg && pos != -1) {
			//p[^
			strTmp = strLine.Mid(pos+10);
			GetModuleParam(fp, strTmp);
		}
		pos = strLine.Find(_T("function:"));
		if(modulefg && pos != -1) {
			//֐{
			strTmp = strLine.Mid(pos+9);
			GetModuleFunc(fp, strTmp);
		}
	}
	fclose(fp);
	return TRUE;
}

void CNcsdefView::Print(const char *str)
{
	CString strout;
	CEdit* pEdit = &(m_defFuncPage.m_func);

	strout = _T(str);
	strout += _T("\r\n");
	pEdit->SetSel(-1, -1);
	pEdit->ReplaceSel(strout);
}

// C
CString CNcsdefView::ModifiedLine(char *line)
{
	CString str,strLeft,strRight;
	int pos,pos1;
	char ch;

	str = _T(line);
	//ŏ̋󔒂폜
	for(pos=0;;pos++) {
		ch = str.GetAt(pos);
		if(ch == ' ' || ch == '\t')
			continue;
		if(ch == '\n')
			return CString("");
		break;
	}
	//Ō
	for(pos1=str.GetLength()-1;;pos1--) {
		ch = str.GetAt(pos1);
		if(ch == ' ' || ch == '\t' || ch == '\n')
			continue;
		break;
	}
	//
	strLeft = str.Left(pos1+1);
	strRight = strLeft.Mid(pos);
	return strRight;	
}

// ֐{̂̎擾ƕ\
void CNcsdefView::GetModuleFunc(FILE* fp, CString str)
{
	char line[_MAX_PATH];
	int pos;
	CString strLine;

	//str
	strcpy(line, str);
	strLine = ModifiedLine(line);
	Print((LPCTSTR)strLine);
	for(;;) {
		if(fgets(line, MAX_PATH, fp) == NULL)
			break;
		strLine = _T(line);
		pos = strLine.Find(_T("end;"));
		if(pos != -1)
			break;	//end;܂
		strLine = ModifiedLine(line);
		Print((LPCTSTR)strLine);
	}
}

// ey[WɃACe\
// tag = 1:	Input
// tag = 2:	Output
// tag = 3:	Param
// tag = 4:	Obs

void CNcsdefView::SetItem(char *pItem, int tag)
{
	CString str,strLeft,strRight;
	int pos;
	char name[MAX_NAMELEN],value[MAX_NAMELEN];

	switch(tag) {
	case	1:
		m_defInputPage.CreateInput(pItem);
		break;
	case	2:
		m_defOutputPage.SetName(pItem);
		break;
	case	3:
		//evfݒ
		str = _T(pItem);
		pos = str.Find(_T("="));
		if(pos != -1) {
			strLeft = str.Left(pos);
			strcpy(name, strLeft);
			strRight = str.Mid(pos+1);
			strcpy(value, strRight);
			m_defParamPage.CreateParam(name, value, NULL);
		}
		break;
	case	4:
		m_defObsPage.CreateObs(pItem, NULL, NULL);
		break;
	}
}

// ^[~l[^';'ɑTRUEԂ
BOOL CNcsdefView::GetSomeItems(CString str, int *nCount, int tag)
{
	int i,addr,num = 0;
	char ch;
	char item[_MAX_PATH];
	BOOL endfg = FALSE;

	i = 0; addr = 0;
	while((ch = str.GetAt(i)) != '\n') {
		if(ch != ' ' && ch != '\t') {
			if(ch == ',') {
				//1ACe
				item[addr] = '\0';
				SetItem(item, tag);
				addr = 0;
				num++;
			}
			else if(ch == ';') {
				//1ACeAI
				item[addr] = '\0';
				SetItem(item, tag);
				addr = 0;
				num++;
				endfg = TRUE;
				break;
			}
			else {
				item[addr++] = ch;
			}
		}
		i++;
	}
	*nCount = num;
	return endfg;
}

int CNcsdefView::GetModuleParam(FILE* fp, CString str)
{
	BOOL endfg;
	char line[_MAX_PATH];
	CString strLine;
	int nCount,pos,sum = 0;

	//n߂str
	endfg = GetSomeItems(str, &nCount, 3);
	sum += nCount;
	for(;!endfg;) {
		if(fgets(line, MAX_PATH, fp) == NULL)
			break;
		strLine = _T(line);
		pos = strLine.Find(_T("/*"));
		if(pos == -1) {
			endfg = GetSomeItems(strLine, &nCount, 3);
			sum += nCount;
		}
	}
	return sum;
}

int CNcsdefView::GetModuleObs(FILE* fp, CString str)
{
	BOOL endfg;
	char line[_MAX_PATH];
	CString strLine;
	int nCount,pos,sum = 0;

	//n߂str
	endfg = GetSomeItems(str, &nCount, 4);
	sum += nCount;
	for(;!endfg;) {
		if(fgets(line, MAX_PATH, fp) == NULL)
			break;
		strLine = _T(line);
		pos = strLine.Find(_T("/*"));
		if(pos == -1) {
			endfg = GetSomeItems(strLine, &nCount, 4);
			sum += nCount;
		}
	}
	return sum;
}

int CNcsdefView::GetModuleOutput(FILE* fp, CString str)
{
	BOOL endfg;
	char line[_MAX_PATH];
	CString strLine;
	int nCount,pos,sum = 0;

	//n߂str
	endfg = GetSomeItems(str, &nCount, 2);
	sum += nCount;
	for(;!endfg;) {
		if(fgets(line, MAX_PATH, fp) == NULL)
			break;
		strLine = _T(line);
		pos = strLine.Find(_T("/*"));
		if(pos == -1) {
			endfg = GetSomeItems(strLine, &nCount, 2);
			sum += nCount;
		}
	}
	return sum;
}

int CNcsdefView::GetModuleInput(FILE* fp, CString str)
{
	BOOL endfg;
	char line[_MAX_PATH];
	CString strLine;
	int nCount,pos,sum = 0;

	//n߂str
	endfg = GetSomeItems(str, &nCount, 1);
	sum += nCount;
	for(;!endfg;) {
		if(fgets(line, MAX_PATH, fp) == NULL)
			break;
		strLine = _T(line);
		pos = strLine.Find(_T("/*"));
		if(pos == -1) {
			endfg = GetSomeItems(strLine, &nCount, 1);
			sum += nCount;
		}
	}
	return sum;
}

int CNcsdefView::GetModuleExinput(FILE* fp, CString str)
{
	BOOL endfg;
	char line[_MAX_PATH];
	CString strLine;
	int nCount,pos,sum = 0;

	//n߂str
	endfg = GetSomeItems(str, &nCount, 1);
	sum += nCount;
	for(;!endfg;) {
		if(fgets(line, MAX_PATH, fp) == NULL)
			break;
		strLine = _T(line);
		pos = strLine.Find(_T("/*"));
		if(pos == -1) {
			endfg = GetSomeItems(strLine, &nCount, 1);
			sum += nCount;
		}
	}
	return sum;
}


CString CNcsdefView::GetModuleType(CString str)
{
	int i,idx=0;
	CString type;
	char ch;

	//擪
	for(i = 0; i < str.GetLength(); i++) {
		ch = str.GetAt(i);
		if(ch==' ' || ch== '\t')
			continue;
		if(ch==';') {
			type.Insert(idx, '\0');
			break;
		}
		type.Insert(idx++, ch);
	}
	if(type.Compare(_T("CELL")) == NULL || type.Compare(_T("GAP")) == NULL
		|| type.Compare(_T("SYNAPSE")) == NULL)
		return type;
	else
		return CString(_T(""));
}

CString CNcsdefView::GetModuleName(CString str)
{
	int i,idx=0;
	CString strName;
	char ch;
	BOOL namefg=FALSE;
	char mdlname[_MAX_PATH];

	//擪
	for(i = 0; i < str.GetLength(); i++) {
		ch = str.GetAt(i);
		if(ch==' ' || ch== '\t')
			continue;
		if(ch==';') {
			strName.Insert(idx, '\0');
			namefg = TRUE;
			break;
		}
		strName.Insert(idx++, ch);
	}
	if(namefg) {
		//pageɐݒ
		CEdit* pEdit;
		CNcsdefWnd* pWnd = (CNcsdefWnd *)GetParent();
		CDialogBar *pBar = &(pWnd->m_wndDlgBar);
		pEdit = (CEdit *)(pBar->GetDlgItem(IDC_DEF_NAME/*IDC_MODULE_NAME*/));
		strcpy(mdlname, strName);
		pEdit->SetWindowText(mdlname);
		return strName;
	}
	else
		return CString("");
}

void CNcsdefView::OnUpdateFileOpen(CCmdUI* pCmdUI) 
{
	CNcsdefWnd* pWnd = (CNcsdefWnd *)GetParent();
	if(pWnd->m_bModelEdit)
		pCmdUI->Enable(FALSE);
	
}

//ҏWmdlt@CZ[u
void CNcsdefView::OnFileSave() 
{
	/*Test*/
	if(!CheckAllItem())
		return;
	/*Save*/
	if(m_strModelPath.GetLength() == 0)
		FileAsSave();
	else
		CreateModel(m_strModelPath);
}

void CNcsdefView::FileAsSave() 
{
	LPCSTR	lpszFilter;
	CString pszPath;
	char	curdir[_MAX_PATH];
	CNcsdefDoc* pDoc = GetDocument();

	pszPath = pDoc->GetTitle();
	lpszFilter = "Model (*.mdl) | *.mdl||";
	CFileDialog	dlgFile(FALSE, ".mdl",pszPath,OFN_HIDEREADONLY,lpszFilter);
	dlgFile.m_ofn.lpstrTitle = "Save";
	dlgFile.m_ofn.lpstrInitialDir = _getcwd(curdir, _MAX_PATH);
	if(dlgFile.DoModal() == IDOK) {
		pszPath = dlgFile.GetPathName();
		if(CreateModel( (LPCTSTR)pszPath ))
			m_strModelPath = pszPath;	//modulepX
		return;
	}
	return;	//no change
	
}

void CNcsdefView::OnUpdateFileSave(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	
}

// ݒ肳ꂽfmF
void CNcsdefView::OnModuleCheck() 
{
	char *mdlname = "def";
	char filename[_MAX_PATH],curdir[_MAX_PATH];
	const char* tmpdir;
	CNcsdefWnd* pWnd = (CNcsdefWnd *)GetParent();
	int	i,len,ch;
	DWORD size;

	//m_strModelPathݒ肳Ă邩
	//if(m_strModelPath.GetLength() == 0) {
	//	FileAsSave();
	//}
	//else {
	//	strcpy(filename, m_strModelPath);
	//	CreateModel(filename);
	//}
		

	_getcwd(curdir, _MAX_PATH);
	tmpdir = get_tmpdir();
	_chdir(tmpdir);
	//if(GetShortPathName(tmpdir, path, _MAX_PATH) == NULL)
	//	strcpy(path, tmpdir);
	//sprintf(filename, "%s/%s.mdl", path,mdlname);
	sprintf(filename, "%s.mdl", mdlname);
	CreateModel(filename);
	
	//NCSvv
#if 0
	//Script쐬
	sprintf(filename, "%s/%s.sl",path,mdlname);
	fp = fopen(filename, "w");
	fprintf(fp,"nassign(\"%s\")\n",mdlname);
	fprintf(fp,"npp()\n");
	//fprintf(fp,"nlink()\n");
	fclose(fp);

	//inline߂ɂĔM

	sprintf(filename, "inline(\"%s/%s.sl\")\n",path,mdlname);

	//RpC󋵂OutViewɕ\
	//A command is transmitted. 
	len = (int)strlen(filename);
	for(i=0; i<len; i++){
		ch = (unsigned char)filename[i];
		WriteFile(pWnd->m_hStdinW, &ch, sizeof(int), &size, NULL);
		if(filename[i] == '\\') {
			WriteFile(pWnd->m_hStdinW, &ch, sizeof(int), &size, NULL);
		}
	}
#endif
	// nasgnR}h
	sprintf(filename,"nassign(\"%s\")\n",mdlname);
	len = (int)strlen(filename);
	for(i=0; i<len; i++){
		ch = (unsigned char)filename[i];
		WriteFile(pWnd->m_hStdinW, &ch, sizeof(int), &size, NULL);
		if(filename[i] == '\\') {
			WriteFile(pWnd->m_hStdinW, &ch, sizeof(int), &size, NULL);
		}
	}
	// nppR}h
	sprintf(filename,"npp()\n");
	len = (int)strlen(filename);
	for(i=0; i<len; i++){
		ch = (unsigned char)filename[i];
		WriteFile(pWnd->m_hStdinW, &ch, sizeof(int), &size, NULL);
		if(filename[i] == '\\') {
			WriteFile(pWnd->m_hStdinW, &ch, sizeof(int), &size, NULL);
		}
	}
	//Jg
	//_chdir(curdir);

	//ConsoleViewerANeBu
	CWnd *pMainWnd = AfxGetMainWnd();
	//pMainWnd->PostMessage(CONSOLE_ACTIVE, 0, 0L);
	pMainWnd->SetActiveWindow();
#if 0
	HWND hWnd = (pWnd->m_pConsoleView)->GetSafeHwnd();
	if(hWnd) {
		bRet = ::SetForegroundWindow(hWnd);
		if(!bRet) {
			FormatMessage( 
			    FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | 
					FORMAT_MESSAGE_IGNORE_INSERTS,
				NULL,
				GetLastError(),
				MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // ftHg
				(LPTSTR)&lpMsgBuf,
				0,
				 NULL 
			);
			::MessageBox( NULL, (LPTSTR) lpMsgBuf, "Error", MB_OK | MB_ICONINFORMATION );
			LocalFree( lpMsgBuf );

		}
	}
#endif
}

void CNcsdefView::OnUpdateModuleCheck(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	
}

void CNcsdefView::OnModuleAppend() 
{
	CNcsdefWnd* pWnd = (CNcsdefWnd *)GetParent();
	char name[256];
	MODULEINFO info;
	CDialogBar *pBar = &(pWnd->m_wndDlgBar);

	//m_strModelPathݒ肳Ă邩
	if(m_strModelPath.GetLength() == 0) {
		FileAsSave();
	}

	//module
	CEdit* pEdit = (CEdit *)(pBar->GetDlgItem(IDC_DEF_NAME/*IDC_MODULE_NAME*/));
	pEdit->GetWindowText(name, 256);

	info.strName = _T(name);
	info.strPath = m_strModelPath;
	info.strGroup = pWnd->m_strGroup;
	(pWnd->m_pModelDoc)->UpdateAllViews (pWnd->m_pModelView,
		0x5B, (CObject*) (&info));
	
}

void CNcsdefView::OnUpdateModuleAppend(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	CNcsdefWnd* pWnd = (CNcsdefWnd *)GetParent();
	if(pWnd->m_bModelEdit)
		pCmdUI->Enable(FALSE);

}
