/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: NcsdefSheet.cpp,v 1.2 2004/05/19 04:15:11 yoshihiko Exp $ */

#include "stdafx.h"
#include "ncsdef.h"

#include "NcsdefInputPage.h"
#include "NcsdefOutputPage.h"
#include "NcsdefSheet.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CNcsdefSheet

IMPLEMENT_DYNAMIC(CNcsdefSheet, CPropertySheet)

CNcsdefSheet::CNcsdefSheet()
{
}

CNcsdefSheet::CNcsdefSheet(UINT nIDCaption, CWnd* pParentWnd, UINT iSelectPage)
	:CPropertySheet(nIDCaption, pParentWnd, iSelectPage)
{
}

CNcsdefSheet::CNcsdefSheet(LPCTSTR pszCaption, CWnd* pParentWnd, UINT iSelectPage)
	:CPropertySheet(pszCaption, pParentWnd, iSelectPage)
{
}

CNcsdefSheet::~CNcsdefSheet()
{
}


BEGIN_MESSAGE_MAP(CNcsdefSheet, CPropertySheet)
	//{{AFX_MSG_MAP(CNcsdefSheet)
	ON_WM_DRAWITEM()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNcsdefSheet bZ[W nh

BOOL CNcsdefSheet::OnInitDialog() 
{
	BOOL bResult = CPropertySheet::OnInitDialog();
	
	// TODO: ̈ʒuɌŗL̃R[hǉĂ

	// ^uRg[̎擾
	CTabCtrl* pTab = GetTabControl();
#if 0
	// _uRg[݂̌̃EBhEX^C擾
	LONG lStyle = GetWindowLong(pTab->m_hWnd, GWL_STYLE);
	// VX^Cݒ
	lStyle |= TCS_OWNERDRAWFIXED;
	// VEBhEX^Cݒ
	SetWindowLong(pTab->m_hWnd, GWL_STYLE, lStyle);
#endif
	// m_bTabLeftBOOL^̃o[ϐ
	m_bTabLeft = FALSE;
	// ^uRg[̗L\̈擾
	CRect rcTabClient;
	pTab->AdjustRect(FALSE, &rcTabClient);

	for(int nIndex=0; nIndex<GetPageCount(); nIndex++) {
		// y[WɃANZX邽߂ɃANeBu
		SetActivePage( nIndex );
		// y[WIuWFNg̎擾
		CPropertyPage* pPage = GetActivePage();
		// y[Ẅʒu␳
		pPage->SetWindowPos( NULL, rcTabClient.left,
			rcTabClient.top, 0, 0, SWP_NOSIZE);
	}
	// ŏ̃y[WANeBu
	SetActivePage(0);

	return bResult;
}

void CNcsdefSheet::OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉ邩܂̓ftHg̏ĂяoĂ
	CRect	rectTab;
	CRect	rectBorder;
	CRect	rectText;
	CBrush	brBtnFace;
	brBtnFace.CreateSolidBrush(GetSysColor(COLOR_BTNFACE));

	CTabCtrl*	pTab = GetTabControl();
	// y[W擾
	int nMaxPage = GetPageCount();
	// ANeBuȃy[W擾
	int nActivePageIndex = pTab->GetCurSel();

	for(int nIndex=0; nIndex<nMaxPage; nIndex++) {
		CPropertyPage* pPage = GetPage(nIndex);
		CDC tabDC;
		tabDC.Attach(lpDrawItemStruct->hDC);
		// ^u̍W擾
		pTab->GetItemRect(nIndex, &rectTab);
		// ^uŎgĂtHg擾
		CFont* pfontNow = pPage->GetFont();
#if 0
		// cptHg쐬
		LOGFONT logFont;
		pfontNow->GetLogFont(&logFont);
		logFont.lfEscapement = (m_bTabLeft ? 900 : 2700);
		CFont fontNow;
		fontNow.CreateFontIndirect(&logFont);
		// tHgI
		CFont *oldFont = tabDC.SelectObject(&fontNow);
#endif
		// ^ũLvV擾
		CString strCaption;
		pPage->GetWindowText(strCaption);
		// LvV̔wiFw
		tabDC.SetBkColor(GetSysColor(COLOR_BTNFACE));
		// LvV\
		if(m_bTabLeft)
			tabDC.TextOut(rectTab.left+2, rectTab.bottom-5,
				strCaption);
		else
			tabDC.TextOut(rectTab.left+4, rectTab.top+5,
				strCaption);
		// ANeBuȃy[WȂ^ủhԂ
		if(nIndex == nActivePageIndex) {
			if(m_bTabLeft)
				rectBorder.SetRect(rectTab.right,rectTab.top,
					rectTab.right+3,rectTab.bottom);
			else
				rectBorder.SetRect(rectTab.left-3,rectTab.top,
					rectTab.left,rectTab.bottom);
			tabDC.FillRect(rectBorder, &brBtnFace);
		}
#if 0
		tabDC.SelectObject(oldFont);
#endif
		tabDC.Detach();
	}

	CPropertySheet::OnDrawItem(nIDCtl, lpDrawItemStruct);
}
