/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: NcsdefObsPage.cpp,v 1.4 2004/08/24 00:02:08 yoshihiko Exp $ */

#include "stdafx.h"
#include "ncsdef.h"
#include "NcsdefObsPage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CNcsdefObsPage vpeB y[W

IMPLEMENT_DYNCREATE(CNcsdefObsPage, CPropertyPage)

CNcsdefObsPage::CNcsdefObsPage() : CPropertyPage(CNcsdefObsPage::IDD)
{
	//{{AFX_DATA_INIT(CNcsdefObsPage)
	//}}AFX_DATA_INIT
	m_nObs = 0;
	m_editMode = MANUAL_EDIT;
}

CNcsdefObsPage::~CNcsdefObsPage()
{
	//폜
	Clear(FALSE);
}

void CNcsdefObsPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CNcsdefObsPage)
	DDX_Control(pDX, IDC_OBS_LIST, m_list);
	DDX_Control(pDX, IDC_OBS_REMOVE, m_remove);
	DDX_Control(pDX, IDC_OBS_ADD, m_add);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CNcsdefObsPage, CPropertyPage)
	//{{AFX_MSG_MAP(CNcsdefObsPage)
	ON_NOTIFY(LVN_BEGINLABELEDIT, IDC_OBS_LIST, OnBeginlabeleditObsList)
	ON_NOTIFY(LVN_ENDLABELEDIT, IDC_OBS_LIST, OnEndlabeleditObsList)
	ON_BN_CLICKED(IDC_OBS_ADD, OnObsAdd)
	ON_BN_CLICKED(IDC_OBS_REMOVE, OnObsRemove)
	ON_NOTIFY(LVN_GETDISPINFO, IDC_OBS_LIST, OnGetdispinfoObsList)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNcsdefObsPage bZ[W nh

BOOL CNcsdefObsPage::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	// TODO: ̈ʒuɏ̕⑫ǉĂ
	CRect rect;
	m_list.GetClientRect(&rect);
	DWORD dwExStyle = m_list.GetExtendedStyle();
	dwExStyle |= LVS_EX_GRIDLINES;
	dwExStyle |= LVS_EX_FULLROWSELECT;
	//dwExStyle |= LVS_EDITLABELS;
	m_list.SetExtendedStyle(dwExStyle);
	m_list.DeleteAllItems();

	
	m_list.InsertColumn (0, _T ("Name"), LVCFMT_LEFT, 80);
	m_list.InsertColumn (1, _T ("Label"), LVCFMT_LEFT, 80);
	m_list.InsertColumn (2, _T ("Unit"), LVCFMT_LEFT, rect.Width()-160);
	
	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CNcsdefObsPage::OnBeginlabeleditObsList(NMHDR* pNMHDR, LRESULT* pResult) 
{
    LV_DISPINFO* pDispInfo = (LV_DISPINFO*)pNMHDR;
    *pResult = 1;

	if(m_editMode == MANUAL_EDIT) {
		if (! m_list.PrepareLabelEdit(pDispInfo)) {
			return;
		}
	}
	else
		m_editMode = MANUAL_EDIT;

    // To Do
    // pDispInfo->item.iItem  pDispInfo->item.iSubItem ɂ`FbNs
    // ҏWȂȂ΁A*pResult  1 ɂāÅ֐𔲂

    // ҏWsꍇɂ́ABeginLabelEdit ĂсA֐甲
    //
    m_list.BeginLabelEdit(pDispInfo, pResult);

}

void CNcsdefObsPage::OnEndlabeleditObsList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LV_DISPINFO* pDispInfo = (LV_DISPINFO*)pNMHDR;

	CString str,disp[3],strRight;
	int iItem,iSubItem,idx,pos;
	OBSITEM* pItem;

	str = _T(pDispInfo->item.pszText);
	if(str.GetLength() == 0) {
		*pResult = FALSE;
		return;
	}
	else {
		iItem = pDispInfo->item.iItem;
		pItem = (OBSITEM*)m_list.GetItemData(iItem);
		iSubItem = pDispInfo->item.iSubItem;
		//':'Zp[^Ƃ
		if(iSubItem == 0) {
			disp[0] = str;
			disp[1] = _T("");
			disp[2] = _T("");
			idx = 0;
			pos = str.Find(_T(":"));
			while(pos != -1) {
				disp[idx++] = str.Left(pos);
				strRight = str.Mid(pos+1);
				str = strRight;
				disp[idx] = str;
				pos = str.Find(_T(":"));
			}
		}

		switch(iSubItem) {
		case 0:
			pItem->strName = str;
			pItem->strName = disp[0];
			if(disp[1].GetLength()>0)
				pItem->strLabel = disp[1];
			if(disp[2].GetLength()>0)
				pItem->strUnit = disp[2];
			break;
		case 1:
			pItem->strLabel = str;
			break;
		case 2:
			pItem->strUnit = str;
			break;
		}
	}
	
	*pResult = 1;
}

void CNcsdefObsPage::AddObs(int item, OBSITEM* pItem) 
{
	LV_ITEM lvi;
	// registration
	lvi.mask = LVIF_TEXT | LVIF_PARAM; 
	lvi.iItem = item; 
	lvi.iSubItem = 0; 
	lvi.pszText = LPSTR_TEXTCALLBACK;
	lvi.lParam = (LPARAM) pItem;

	if (m_list.InsertItem (&lvi) == -1) {
		return;
	}
}

void CNcsdefObsPage::CreateObsArray(char *name, char *label, char *unit)
{
	OBSITEM* pItem;

	/*create*/
	try {
		pItem = new OBSITEM;
	}
	catch (CMemoryException* e) {
		e->Delete ();
		return;
	}
	if(!name)
		pItem->strName = _T("");
	else
		pItem->strName = _T(name);
	if(!label)
		pItem->strLabel = _T("");
	else
		pItem->strLabel = _T(label);
	if(!unit)
		pItem->strUnit = _T("");
	else
		pItem->strUnit = _T(unit);
	m_obsArray.InsertAt( m_nObs, pItem );
}

void CNcsdefObsPage::OnObsAdd() 
{
	CreateObs(NULL, NULL, NULL);
}

void CNcsdefObsPage::CreateObs(char *name, char *label, char *unit)
{
	//CPtrArray
	CreateObsArray(name, label, unit);

	// Xgɓo^
	OBSITEM* pItem;
	pItem = (OBSITEM *)m_obsArray.GetAt(m_nObs);
	AddObs(m_nObs, pItem);
	m_list.SetItemState(m_nObs, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED);
	m_list.SetFocus();
	m_nObs++;

	//ҏW[hɓ
	m_editMode = AUTO_EDIT;
	ListView_EditLabel(m_list, m_nObs-1);
}

void CNcsdefObsPage::OnObsRemove() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	OBSITEM* pItem;
	int nItem;
	POSITION pos;
	pos = m_list.GetFirstSelectedItemPosition();
	if (pos == NULL)
		return;
	else
	{
	   while (pos)
	   {
		  nItem = m_list.GetNextSelectedItem(pos);
		  //TRACE1("Item %d was selected!\n", nItem);
		  // you could do your own processing on nItem here
		pItem = (OBSITEM *)m_obsArray.GetAt(nItem);
		if(pItem)
			delete pItem;
		m_obsArray.RemoveAt(nItem);
		m_list.DeleteItem(nItem);
		m_nObs--;
			
	   }
	}
	
}

void CNcsdefObsPage::OnGetdispinfoObsList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LV_DISPINFO* pDispInfo = (LV_DISPINFO*)pNMHDR;
	if (pDispInfo->item.mask & LVIF_TEXT) {
		OBSITEM* pItem = (OBSITEM*) pDispInfo->item.lParam;

		switch (pDispInfo->item.iSubItem) {
			case 0: // Name
				::lstrcpy (pDispInfo->item.pszText, pItem->strName);
				break;

			case 1: //Label
				::lstrcpy (pDispInfo->item.pszText, pItem->strLabel);
				break;

			case 2: // Unit
				::lstrcpy (pDispInfo->item.pszText, pItem->strUnit);
				break;
		}
	}
	
	*pResult = 0;
}

void CNcsdefObsPage::Clear(BOOL fg)
{
	int nCount,i;
	OBSITEM* pInfo;

	// ArraỹNA
	nCount = (int)m_obsArray.GetSize();
	if(nCount > 0) {
		for (i=0; i<nCount; i++) {
			pInfo =  (OBSITEM*) m_obsArray.GetAt (i);
			delete pInfo;
		}
		m_obsArray.RemoveAll();
	}
	m_nObs = 0;
	// list̃NA
	if(fg) {
		nCount = m_list.GetItemCount();
		m_list.DeleteAllItems();
	}
}

BOOL CNcsdefObsPage::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	AfxGetApp()->WinHelp(0x20000+IDD_NCSDEF_OBS, HELP_CONTEXT);
	return TRUE;
	
	//return CPropertyPage::OnHelpInfo(pHelpInfo);
}
