/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: ListCtrlEdit.h,v 1.2 2004/05/19 04:15:11 yoshihiko Exp $ */

#if !defined(AFX_LISTCTRLEDIT_H__54C530B4_5A5B_4865_9EBB_D9CA3BD5731B__INCLUDED_)
#define AFX_LISTCTRLEDIT_H__54C530B4_5A5B_4865_9EBB_D9CA3BD5731B__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


/////////////////////////////////////////////////////////////////////////////
// CEditInplace EBhE

class CEditInplace : public CEdit
{
public:
	CEditInplace();
	virtual ~CEditInplace();

// I[o[Ch
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂B
	//{{AFX_VIRTUAL(CEditInplace)
	//}}AFX_VIRTUAL


	// ꂽbZ[W }bv֐
protected:
	//{{AFX_MSG(CEditInplace)
	afx_msg UINT OnGetDlgCode();
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};


/////////////////////////////////////////////////////////////////////////////
// CListCtrlEdit EBhE

class CListCtrlEdit : public CListCtrl
{
public:
	enum {
		IDC_LIST_CTRL_EDIT = 51432,
	};
	
	CListCtrlEdit();
	virtual ~CListCtrlEdit();
	BOOL PrepareLabelEdit(LV_DISPINFO* pDispInfo);
	void BeginLabelEdit(LV_DISPINFO* pDispInfo, LRESULT* pResult);

// I[o[Ch
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂B
	//{{AFX_VIRTUAL(CListCtrlEdit)
	//}}AFX_VIRTUAL

protected:
	void GetEditRect(int iItem, int iSubItem, CRect& rct);
	void CancelEdit(void);

protected:
	BOOL m_bEdit;
	ULONG m_orgStyle;
	CEditInplace m_editInline;
	int m_iItem;
	int m_iSubItem;

	static const int TopOffset;
	static const int BottomOffset;

	// ꂽbZ[W }bv֐
protected:
	//{{AFX_MSG(CListCtrlEdit)
	afx_msg void OnKillFocusEdit();
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ ͑Os̒Oɒǉ̐錾}܂B

#endif // !defined(AFX_LISTCTRLEDIT_H__54C530B4_5A5B_4865_9EBB_D9CA3BD5731B__INCLUDED_)
