/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: ListCtrlEdit.cpp,v 1.2 2004/05/19 04:15:11 yoshihiko Exp $ */

#include "stdafx.h"
#include "ListCtrlEdit.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CEditInplace
//

CEditInplace::CEditInplace()
{
}

CEditInplace::~CEditInplace()
{
}


BEGIN_MESSAGE_MAP(CEditInplace, CEdit)
	//{{AFX_MSG_MAP(CEditInplace)
	ON_WM_GETDLGCODE()
	ON_WM_KEYDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEditInplace bZ[W nh
//

UINT CEditInplace::OnGetDlgCode() 
{
	return DLGC_WANTALLKEYS | CEdit::OnGetDlgCode();
}


void CEditInplace::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	if (nChar == VK_RETURN || nChar == VK_ESCAPE) {
		GetParent()->SendMessage(WM_KEYDOWN, nChar, MAKELPARAM(nRepCnt, nFlags));
	}
	else {
		CEdit::OnKeyDown(nChar, nRepCnt, nFlags);
	}
}


/////////////////////////////////////////////////////////////////////////////
// CListCtrlEdit
//

const int CListCtrlEdit::TopOffset = -1;
const int CListCtrlEdit::BottomOffset = 3;


CListCtrlEdit::CListCtrlEdit()
{
	m_bEdit = FALSE;
}

CListCtrlEdit::~CListCtrlEdit()
{
}


void CListCtrlEdit::GetEditRect(int iItem, int iSubItem, CRect& rct)
{
	GetSubItemRect(iItem, iSubItem, LVIR_LABEL, rct);
	rct.top += TopOffset;
	rct.bottom += BottomOffset;
}


void CListCtrlEdit::CancelEdit(void)
{
	if (! m_bEdit) {
		return;
	}

	m_bEdit = FALSE;	// DestoryWindow  EN_KILLFOCUS 𔭐̂Őɍs
	m_editInline.DestroyWindow();

	if (m_orgStyle & LVS_SINGLESEL) {
		ModifyStyle(0, LVS_SINGLESEL);
	}
	else if (! GetItemState(m_iItem, LVIS_SELECTED)) {
		SetItemState(m_iItem, LVIS_SELECTED, LVIS_SELECTED);
	}
}


BEGIN_MESSAGE_MAP(CListCtrlEdit, CListCtrl)
	//{{AFX_MSG_MAP(CListCtrlEdit)
	ON_EN_KILLFOCUS(IDC_LIST_CTRL_EDIT, OnKillFocusEdit)
	ON_WM_KEYDOWN()
	ON_WM_VSCROLL()
	ON_WM_HSCROLL()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CListCtrlEdit bZ[W nh
//

BOOL CListCtrlEdit::PrepareLabelEdit(LV_DISPINFO* pDispInfo)
{
	LVHITTESTINFO hitTest;
	::GetCursorPos(&hitTest.pt);
	ScreenToClient(&hitTest.pt);
	
	hitTest.flags = LVHT_ONITEMLABEL;
	if (SubItemHitTest(&hitTest) < 0 || hitTest.iItem != pDispInfo->item.iItem) {
		return FALSE;
	}

	pDispInfo->item.iSubItem = hitTest.iSubItem;
	return TRUE;
}


void CListCtrlEdit::BeginLabelEdit(LV_DISPINFO* pDispInfo, LRESULT* pResult)
{
	if (pDispInfo->item.iSubItem == 0) {
		*pResult = 0;
		return;
	}
		
	m_bEdit = TRUE;
	m_iItem = pDispInfo->item.iItem;
	m_iSubItem = pDispInfo->item.iSubItem;

	m_orgStyle = GetStyle();
	if (m_orgStyle & LVS_SINGLESEL) {
		ModifyStyle(LVS_SINGLESEL, 0);
	}
	SetItemState(m_iItem, LVIS_SELECTED, LVIS_SELECTED | LVIS_FOCUSED);

	CRect rct;
	GetEditRect(m_iItem, m_iSubItem, rct);
	m_editInline.Create(WS_CHILD|WS_BORDER|WS_VISIBLE|ES_AUTOHSCROLL, rct, this, IDC_LIST_CTRL_EDIT);
	m_editInline.SetFont(GetFont(), FALSE);

	m_editInline.SetWindowText(GetItemText(m_iItem, m_iSubItem));
	m_editInline.SetSel(0, -1);
	m_editInline.SetFocus();
	
	*pResult = 1;
}


void CListCtrlEdit::OnKillFocusEdit() 
{
	if (! m_bEdit) {
		return;
	}

	CString str;
	m_editInline.GetWindowText(str);
	CancelEdit();

	NMLVDISPINFO info;
	::ZeroMemory(&info, sizeof(NMLVDISPINFO));

	info.hdr.hwndFrom = m_hWnd;
	info.hdr.idFrom = GetDlgCtrlID();
	info.hdr.code = LVN_ENDLABELEDIT;

	info.item.mask = LVIF_TEXT;
	info.item.iItem = m_iItem;
	info.item.iSubItem = m_iSubItem;
	info.item.cchTextMax = str.GetLength() + 64;
	info.item.pszText = str.GetBuffer(info.item.cchTextMax);
	
	if (GetParent()->SendMessage(WM_NOTIFY, GetDlgCtrlID(), (LPARAM) &info) && info.item.pszText != NULL) {
		SetItemText(m_iItem, m_iSubItem, info.item.pszText);
	}

	str.ReleaseBuffer();
}


void CListCtrlEdit::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	if (nChar == VK_RETURN) {
		OnKillFocusEdit();
		SetItemState(m_iItem, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED);
	}
	else if (nChar == VK_ESCAPE) {
		CancelEdit();
		SetItemState(m_iItem, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED);
	}
}


void CListCtrlEdit::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	CListCtrl::OnVScroll(nSBCode, nPos, pScrollBar);

	if (m_bEdit) {
		CRect rct;
		GetEditRect(m_iItem, m_iSubItem, rct);

		m_editInline.MoveWindow(&rct, FALSE);
		m_editInline.InvalidateRect(NULL);
	}
}


void CListCtrlEdit::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	CListCtrl::OnHScroll(nSBCode, nPos, pScrollBar);

	if (m_bEdit) {
		CRect rct;
		GetEditRect(m_iItem, m_iSubItem, rct);

		m_editInline.MoveWindow(&rct, FALSE);
		m_editInline.InvalidateRect(NULL);
	}
}

