/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: XyView.h,v 1.2 2004/09/03 10:11:05 yoshihiko Exp $ */

#pragma once
#include "afxwin.h"



// CXyView r[

class CXyView : public CScrollView
{
	DECLARE_DYNCREATE(CXyView)

protected:
	CXyView();           // IŎgp protected RXgN^
	virtual ~CXyView();

public:
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	virtual void OnDraw(CDC* pDC);      // ̃r[`悷邽߂ɃI[o[Ch܂B
	virtual void OnInitialUpdate();     // \z 1 

	DECLARE_MESSAGE_MAP()
public:
	void UpdateInit(int scope, double simtime, double simstep, int cycle, int width);
	void UpdateData(int cycle, int scope, int size, float* data);
	int m_index;
	double m_simtime;
	double m_simstep;
	int m_nCycle;
	int m_nSize;
	double* m_data;
	int m_nWidth;			//͐i2or3j
	int m_nLength;
	int m_nStart;
	void DrawXy(CDC* pDC);
	void DrawInit(CDC* pDC);
	void InvertLine(CDC* pDC, POINT from, POINT to);
	int m_xs;
	int m_ys;
	int m_zs;
	int m_xInit;
	int m_yInit;
	int m_zInit;
	int m_width;
	int m_height;
	void DrawData(CDC* pDC);
	void SetScale(void);
	double m_xmax;
	double m_xmin;
	double m_ymax;
	double m_ymin;
	double m_zmax;
	double m_zmin;
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	CFont m_font;
	afx_msg void OnDestroy();
	void SetTitle(CDC* pDC);
	void SetUnits(CDC* pDC);
	CWnd* m_pParentWnd;
};


