/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: WidgetObj.h,v 1.4 2004/09/14 07:22:21 yoshihiko Exp $ */

#if !defined(AFX_WIDGETOBJ_H__58126F40_FEB0_11D5_B32E_004026971EF3__INCLUDED_)
#define AFX_WIDGETOBJ_H__58126F40_FEB0_11D5_B32E_004026971EF3__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/////////////////////////////////////////////////////////////////////////////
// CWidget NX

class CWidget : public CObject
{
	DECLARE_SERIAL(CWidget)

// Agr[g
public:

// Iy[V
public:
	void ChangeScopeInfo(CWidget* pWidget, CWnd* pWnd, CPtrArray* p);
	void XyUpdate(int cycle, int index, int size, float* data);
	void XySet(double simtime, double simstep, int cycle);
	void ScopeUpdate(int cycle, int index, int size, float* data);
	void ScopeSet(double simtime, double simstep, int cycle);
	CWidget();
	CWidget (int id, int x, int y, int cx, int cy, COLORREF color, char *name);
	CWidget (CPoint point, int id, int cx, int cy);
	virtual ~CWidget();
	void		DrawSelected (CDC* pDC);
	BOOL		PtInWidget (POINT point);
	virtual void DrawDragImage (CDC* pDC, POINT point);
	virtual void Draw (CDC* pDC);
	COLORREF	GetColor ();
	CRect		GetRect ();
	void		SetRect(CRect rect);
	int			GetId();
	void		DrawName(CDC *pDC);
	void		DrawTitle(CDC *pDC);
	void		GetName(int id, char name[]);
	void*		LoadBitmapFile(LPCTSTR lpszPathName, DWORD *bfOffBits) ;
	BYTE*		GetBitmapBits( void *bitmap );
	void		SetSel (BOOL sel);
	BOOL		GetSel ();
	BOOL		PtOnRLine(POINT point);
	BOOL		PtOnLLine(POINT point, CPoint *newpos);
	void		DrawInport(CDC *pDC);
	void		DrawOutport(CDC *pDC);
	void		InvertLine(CDC *pDC, POINT from, POINT to);
	CPoint		GetPoint();
	BOOL		GetModelParam(int type, CString name);
	void		GetModelParamRead(char *line);
	CPtrArray*	GetParamPointer();
	void		GetParamMessage(char *line, PARAMINFO* pItem);
	CString		GetName();
	void		SetName(CString str);
	void		SetOutportName(CPtrArray *outpname);
	CPtrArray*	GetOutportName();
	void		ChangeOutportName();
	void		SetInportName(CPtrArray *inpname);
	CPtrArray*	GetInportName();
	void		ChangeInportName();
	BLOCKINFO*	GetPitem();
	int			GetOrder();
	void		SetOrder(int index);
	CString		GetModel();
	BOOL		GetModelScope(int type, CString name);
	CPtrArray*	GetScopePointer();
	void		GetModelScopeItem(char *line, int type);
	void		GetScopeMessage(char *line, SCOPEINFO* pItem);
	int			GetDirection();
	void		SetDirection(int direction);
	int			GetOutport();
	void		SetOutport(int outport);
	int			GetInport();
	void		SetInport(int inport);
	CString		GetMatrix();
	void		SetMatrix(CString matrix);
	int			GetMatrixRow(CString matrix);
	int			GetMatrixColumn(CString matrix);
	int			GetCellRow();
	int			GetCellColumn();
	CPtrArray*	GetSubsysPointer();
	void		RemoveSubsys();
	void		RemoveSubsysLines();
	void		RemoveSubsysWidgets();
	BOOL		GetParamInfo(CString str, double *mx, double *mi, int *st);
	BOOL		GetInportLine();
	void		SetInportLine(int value);
	BOOL		GetOutportLine();
	void		SetOutportLine(int value);
	CPtrArray*	GetSubsysWidgets();
	CPtrArray*	GetSubsysLines();
	int			PtOnResize(POINT point);
	BOOL		CheckInport(int index);
	BOOL		CheckOutport(int index);
	void		ResetInportLine(int value);
	void		ResetOutportLine(int value);
	int			GetSearch();
	void		SetSearch(int index);
	CPoint		GetWidgetCenter(CPoint point);
	int			GetJunction();
	void		SetJunction(int id);
	int			GetLevel();
	void		SetLevel(int lv);
	int			AreaInWidget(CRect rect);
	CPoint		GetInportPos(int port);
	CPoint		GetOutportPos(int port);
	void		SetBitmap(CString bmpName);
	CString		GetBitmap();
	void		SetType(int type);
	int			GetType();
	void		SetConnect(int con);
	int			GetConnect();
	//SubsystemCWidget*CLine*ێ|C^[
	CPtrArray*	GetWidgetsPointer();
	CPtrArray*	GetLinesPointer();
	void		IncLineIndex(int num);
	void		DecLineIndex(int num);
	int			GetLineIndex();
	void		SetLineIndex(int num);
	void		SetHitem(HTREEITEM hItem);
	HTREEITEM	GetHitem();
	//SubsytemEBhE
	void		SetWindow(CWnd *pWnd);
	CWnd*		GetWindow();
	void		SetDocument(CDocument *pDoc);
	CDocument*	GetDocument();
	//ScopeFrameEBhE
	void		SetScope(CWnd *pWnd);
	CWnd*		GetScope();
	//ScopeύX
	void		ChangeXyScope();

// I[o[Ch
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂B
	//{{AFX_VIRTUAL(CWidget)
	//}}AFX_VIRTUAL
	virtual void Serialize (CArchive& ar);

// Cve[V
protected:
	int		m_search;				//R[hɌ鏇
	COLORREF m_color;
	CRect m_rect;
	int		m_id;
	CString	m_name;
	BLOCKINFO *m_pItem;
	void *m_bitmap;
	DWORD m_bfOffBits;
	BOOL	m_selected;
	int		m_inport;
	int		m_outport;
	CPoint	m_ptFrom, m_ptTo;
	CPoint	m_point;
	CPtrArray	m_paramArray;		//p[^[Ǘ
	int		m_order;				//Widgetɐڑ錋qݒ
	CString m_model;
	CPtrArray	m_scopeArray;		//XR[vǗ
	int		m_direction;			//
	CString m_matrix;
	int		m_row, m_column;
	CPtrArray	m_subsysArray;		//TuVXeǗ
	int		m_bInportLine;
	int		m_bOutportLine;
	CPtrArray	m_subsysWidgets;	//TuVXeWidget
	CPtrArray	m_subsysLines;
	int		m_junction;				//gZŎgp
	int		m_level;				//KwCfbNX
	CString	m_bmpName;				//Bitmap
	int		m_type;					//Module^Cv
	int		m_connect;				//gZŎgp
	CPtrArray m_inpname;
	CPtrArray m_outpname;

	//SubsystemCWidget*CLine*ێ|C^[
	CPtrArray m_arrWidgets;
	CPtrArray m_arrLines;
	int	m_nLineIndex;	//CCfbNX
	HTREEITEM m_hItem;

	//SubsystemEBhE
	CDocument*	m_pDoc;
	CWnd*		m_pWnd;
	//ScopeFrameEBhE
	CWnd*		m_pScopeFrame;

};

/////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////////////////////
// CLine R}h ^[Qbg

class CLine : public CObject
{
	DECLARE_SERIAL(CLine)

// Agr[g
public:

// Iy[V
public:
	CLine();
	CLine(CPoint spt, CPoint ept, int sidx, int eidx, COLORREF color, int arrow, int idx,
		int inport, int outport, int type, int junc);
	virtual ~CLine();
	int			GetThickness();
	void		SetThickness(int val);
	int			GetType();
	virtual void DrawDragImage (CDC* pDC, POINT point);
	virtual void Draw (CDC* pDC);
	CPoint		GetSpos();
	CPoint		GetEpos();
	void		SetSpos(CPoint spos);
	void		SetEpos(CPoint epos);
	void		SetSblk(int val);
	int			GetSblk();
	void		SetEblk(int val);
	int			GetEblk();
	COLORREF	GetColor();
	int			GetArrow();
	void		SetArrow(int style);
	BOOL		PtInLine(POINT point);
	void		SetSel (BOOL sel);
	BOOL		GetSel ();
	int			GetIndex();
	void		SetInport(int port);	//ڑ|[g
	int			GetInport();
	void		SetOutport(int port);	//ڑ|[g
	int			GetOutport();
	void		SetJunction(int junc);
	int			GetJunction();

// I[o[Ch
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂B
	//{{AFX_VIRTUAL(CLine)
	//}}AFX_VIRTUAL
	virtual void Serialize (CArchive& ar);

// Cve[V
protected:
	int	m_xs;
	int	m_ys;
	int	m_xe;
	int	m_ye;
	COLORREF m_color;
	int m_arrow;
	int m_sblk;
	int m_eblk;
	CPoint m_spt,m_ept;
	BOOL m_selected;
	int	m_index;
	int m_inport;
	int m_outport;
	int m_type;
	int	m_thickness;		//
	int m_junction;			//LineCM_GAPAM_SYNAPSE
};

/////////////////////////////////////////////////////////////////////////////
//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ ͑Os̒Oɒǉ̐錾}܂B

#endif // !defined(AFX_WIDGETOBJ_H__58126F40_FEB0_11D5_B32E_004026971EF3__INCLUDED_)
