/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: WidgetObj.cpp,v 1.8 2004/09/14 07:22:21 yoshihiko Exp $ */

#include "stdafx.h"
#include "Extncs.h"
#include <vfw.h>

#include "WidgetObj.h"
#include "ScopeWnd.h"
#include "SubsysDoc.h"
#include "SubsysWnd.h"
#include "SubsysView.h"
#include "ModelDoc.h"
#include "ExtncsDoc.h"
#include "ExtncsWnd.h"
#include "ExtncsMain.h"
#include "ScopeFrame.h"
#include "XyWnd.h"
#include "shell/satellite4.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//̒`́Aړ̕\Ɋ֌W
//#define	BITMAP_MOVE
//̒`́AI̕\Ɋ֌W
#define	BITMAP_SELECT
//gCELL̗̈i荞ނ߂̃ItZbg
//ɏkĂꍇlKv
#define	WAKU_OFFSET	8
//̒`ŁAo̓|[g\Op`Ԃڑ
#define	TRIANGLE_MODE
//̈攻̂߂̃ItZbg
#define	CONNECT_OFFSET	4

// CExtncsMaiñf[^KvƂĂ
extern CExtncsMain* g_pExtncsMain;

/////////////////////////////////////////////////////////////////////////////
// CWidget

IMPLEMENT_SERIAL(CWidget, CObject, 1)

CWidget::CWidget()
{
	m_bitmap = NULL;
	m_selected = FALSE;
	m_pItem = (BLOCKINFO *)g_pExtncsMain->m_blockArray.GetAt(m_id);
	m_name = _T(m_pItem->name);
	m_inport = m_pItem->inport;
	m_outport = m_pItem->outport;
	//2003.1.27
	m_bInportLine = FALSE;
	m_bOutportLine = FALSE;
	//Bitmap
	m_bmpName = _T("");
	//Type
	m_type = -1;
}

CWidget::CWidget (int id, int x, int y, int cx, int cy, COLORREF color, char *name)
{
	m_rect = CRect (x, y, x + cx, y + cy);
	m_color = color;
	m_id = id;
	m_name = _T(name);
	//2003.1.27
	m_bInportLine = FALSE;
	m_bOutportLine = FALSE;
	//Bitmap
	m_bmpName = _T("");
	//Type
	m_type = -1;
}

CWidget::CWidget (CPoint point, int id, int cx, int cy)
{
	// WW[
	m_bitmap = NULL;
	m_point = point;
	m_rect = CRect (point.x, point.y, point.x+cx, point.y+cy);
	m_selected = FALSE;
	//m_color = color;
	m_id = id;
	m_pItem = (BLOCKINFO *)g_pExtncsMain->m_blockArray.GetAt(id);
	//Őݒ肵Ȃ
	//m_name = _T(m_pItem->name);
	m_inport = m_pItem->inport;
	m_outport = m_pItem->outport;

	m_ptFrom.x = m_rect.left;	//ʒuo
	m_ptFrom.y = m_rect.top;
	m_ptTo.x = m_rect.right;
	m_ptTo.y = m_rect.bottom;
	m_order = -1;				//
	m_direction = m_pItem->direction;	//ݒ
	m_matrix = m_pItem->matrix;		//Matrix
	m_row = GetMatrixRow(m_matrix);
	m_column = GetMatrixColumn(m_matrix);
	m_model = m_pItem->model;		//f
	m_bInportLine = FALSE;		//񏉊l
	m_bOutportLine = FALSE;
	m_junction = -1;
	m_connect = CONNECT_OUT; 

	//m_paramArray
	int nCount,i;
	nCount = (int)m_paramArray.GetSize();
	if(nCount > 0) {
		for (i=0; i<nCount; i++)
			delete (PARAMINFO*) m_paramArray.GetAt (i);
		m_paramArray.RemoveAll();
	}
	//fp[^[Qbg
	GetModelParam(m_pItem->type, m_pItem->model);
	//m_scopeArray
	nCount = (int)m_scopeArray.GetSize();
	if(nCount > 0) {
		for (i=0; i<nCount; i++)
			delete (SCOPEINFO*) m_scopeArray.GetAt (i);
		m_scopeArray.RemoveAll();
	}
	//fScopeQbg
	GetModelScope(m_pItem->type, m_pItem->model);
	//Bitmap
	m_bmpName = _T("");
	//Type
	m_type = -1;
	//SubsytemEBhE
	m_pWnd = NULL;
	m_pDoc = NULL;
	//ScopeFrameEBhE
	m_pScopeFrame = NULL;
}

CWidget::~CWidget()
{
	int nCount,i;
	NAMEINFO* pItem;
	PARAMINFO* pInfo;

	if(m_bitmap)
		delete m_bitmap;
	nCount = (int)m_paramArray.GetSize();
	if(nCount > 0) {
		for (i=0; i<nCount; i++) {
			pInfo = (PARAMINFO*) m_paramArray.GetAt (i);
			delete pInfo;
		}
		m_paramArray.RemoveAll();
	}
	nCount = (int)m_scopeArray.GetSize();
	if(nCount > 0) {
		for (i=0; i<nCount; i++)
			delete (SCOPEINFO*) m_scopeArray.GetAt (i);
		m_scopeArray.RemoveAll();
	}
	nCount = (int)m_subsysArray.GetSize();
	if(nCount > 0) {
		for (i=0; i<nCount; i++)
			delete (SUBSYSINFO*) m_subsysArray.GetAt (i);
		m_subsysArray.RemoveAll();
	}
	nCount = (int)m_inpname.GetSize();
	if(nCount > 0) {
		for (i=0; i<nCount; i++) {
			pItem = (NAMEINFO*) m_inpname.GetAt (i);
			delete pItem/*(NAMEINFO*) m_inpname.GetAt (i)*/;
		}
		m_inpname.RemoveAll();
	}
	nCount = (int)m_outpname.GetSize();
	if(nCount > 0) {
		for (i=0; i<nCount; i++) {
			pItem = (NAMEINFO*) m_outpname.GetAt (i);
			delete pItem;
		}
		m_outpname.RemoveAll();
	}
}

/////////////////////////////////////////////////////////////////////////////
// CWidget bZ[W nh
//
// ScopeEBhE
//
void CWidget::SetScope(CWnd *pWnd)
{
	m_pScopeFrame = pWnd;
}
CWnd* CWidget::GetScope()
{
	return m_pScopeFrame;
}
//
// SubsystemEBhE
//
void CWidget::SetWindow(CWnd *pWnd)
{
	m_pWnd = pWnd;
}
CWnd* CWidget::GetWindow()
{
	return m_pWnd;
}
void CWidget::SetDocument(CDocument *pDoc)
{
	m_pDoc = pDoc;
}
CDocument* CWidget::GetDocument()
{
	return m_pDoc;
}

void CWidget::SetHitem(HTREEITEM hItem)
{
	m_hItem = hItem;
}
HTREEITEM CWidget::GetHitem()
{
	return m_hItem;
}
void CWidget::IncLineIndex(int num)
{
	m_nLineIndex += num;
}
void CWidget::DecLineIndex(int num)
{
	m_nLineIndex -= num;
}
int CWidget::GetLineIndex()
{
	return m_nLineIndex;
}
void CWidget::SetLineIndex(int num)
{
	m_nLineIndex = num;
}

CPtrArray* CWidget::GetWidgetsPointer()
{
	return (&m_arrWidgets);
}

CPtrArray* CWidget::GetLinesPointer()
{
	return (&m_arrLines);
}

int CWidget::GetConnect()
{
	return m_connect;
}
void CWidget::SetConnect(int con)
{
	m_connect = con;
}
int CWidget::GetType()
{
	return m_type;
}
void CWidget::SetType(int type)
{
	m_type = type;
}

//Bitmapǂ
CString CWidget::GetBitmap()
{
	return m_bmpName;
}
//BitmapύX
void CWidget::SetBitmap(CString bmpName)
{
	m_bmpName = bmpName;
}

//̓|[g̈ʒu
CPoint CWidget::GetInportPos(int port)
{
	int step,x,y,cx,cy,xad,yad;
	CPoint pos;

	switch (m_direction) {
	case	DIR_RIGHT:
		if(m_row*m_column > 1 && port > 1) {
			if(m_row == 1) {
				cx = m_rect.Width()/m_column;
				cy = m_rect.Height();
				x = m_rect.left+cx*(port-2)+cx/2;
				y = m_rect.top + cy/2;
				pos = CPoint(x,y);
			}
			else if(m_column == 1) {
				cx = m_rect.Width();
				cy = m_rect.Height()/m_row;
				x = m_rect.left+cx/2;
				y = m_rect.top + cy*(port-2)+cy/2;
				pos = CPoint(x,y);
			}
			else {
				cx = m_rect.Width()/m_column;
				cy = m_rect.Height()/m_row;
				xad = (port-2)%m_column;
				yad = (port-2)/m_column;
				x = m_rect.left+cx*xad+cx/2;
				y = m_rect.top+cy*yad+cy/2;
				pos = CPoint(x,y);
			}
		}
		else {
			step = m_rect.Height() / (m_inport+1);
			pos = CPoint(m_rect.left, m_rect.top+step*port);
		}
		break;
	case	DIR_UP:
		if(m_row*m_column > 1 && port > 1) {
			//`FbN
			if(m_row == 1) {
				cx = m_rect.Width()/m_column;
				cy = m_rect.Height();
				x = m_rect.left+cx*(port-2)+cx/2;
				y = m_rect.top + cy/2;
				pos = CPoint(x,y);
			}
			else if(m_column == 1) {
				cx = m_rect.Width();
				cy = m_rect.Height()/m_row;
				x = m_rect.left+cx/2;
				y = m_rect.top + cy*(port-2)+cy/2;
				pos = CPoint(x,y);
			}
			else {
				cx = m_rect.Width()/m_column;
				cy = m_rect.Height()/m_row;
				xad = (port-2)%m_column;
				yad = (port-2)/m_column;
				x = m_rect.left+cx*xad+cx/2;
				y = m_rect.top+cy*yad+cy/2;
				pos = CPoint(x,y);
			}
		}
		else {
			step = m_rect.Width() / (m_inport+1);
			pos = CPoint(m_rect.left+step*port, m_rect.bottom);
		}
		break;
	case	DIR_LEFT:
		if(m_row*m_column > 1 && port > 1) {
			if(m_row == 1) {
				cx = m_rect.Width()/m_column;
				cy = m_rect.Height();
				x = m_rect.right+cx*(port-2)+cx/2;
				y = m_rect.top + cy/2;
				pos = CPoint(x,y);
			}
			else if(m_column == 1) {
				cx = m_rect.Width();
				cy = m_rect.Height()/m_row;
				x = m_rect.right+cx/2;
				y = m_rect.top + cy*(port-2)+cy/2;
				pos = CPoint(x,y);
			}
			else {
				cx = m_rect.Width()/m_column;
				cy = m_rect.Height()/m_row;
				xad = (port-2)%m_column;
				yad = (port-2)/m_column;
				x = m_rect.right+cx*xad+cx/2;
				y = m_rect.top+cy*yad+cy/2;
				pos = CPoint(x,y);
			}
		}
		else {
			step = m_rect.Height() / (m_inport+1);
			pos = CPoint(m_rect.right, m_rect.top+step*port);
		}
		break;
	case	DIR_DOWN:
		if(m_row*m_column > 1 && port > 1) {
			//`FbN
			if(m_row == 1) {
				cx = m_rect.Width()/m_column;
				cy = m_rect.Height();
				x = m_rect.left+cx*(port-2)+cx/2;
				y = m_rect.top + cy/2;
				pos = CPoint(x,y);
			}
			else if(m_column == 1) {
				cx = m_rect.Width();
				cy = m_rect.Height()/m_row;
				x = m_rect.left+cx/2;
				y = m_rect.top + cy*(port-2)+cy/2;
				pos = CPoint(x,y);
			}
			else {
				cx = m_rect.Width()/m_column;
				cy = m_rect.Height()/m_row;
				xad = (port-2)%m_column;
				yad = (port-2)/m_column;
				x = m_rect.left+cx*xad+cx/2;
				y = m_rect.top+cy*yad+cy/2;
				pos = CPoint(x,y);
			}
		}
		else {
			step = m_rect.Width() / (m_inport+1);
			pos = CPoint(m_rect.left+step*port, m_rect.top);
		}
		break;
	}
	return pos;
}

//o̓|[g̈ʒu
CPoint CWidget::GetOutportPos(int port)
{
	int step,x,y,cx,cy,xad,yad;
	CPoint pos;

	switch (m_direction) {
	case	DIR_RIGHT:
		if(m_row*m_column > 1 && port > 1) {
			if(m_row == 1) {
				cx = m_rect.Width()/m_column;
				cy = m_rect.Height();
				x = m_rect.left+cx*(port-2)+cx/2;
				y = m_rect.top + cy/2;
				pos = CPoint(x,y);
			}
			else if(m_column == 1) {
				cx = m_rect.Width();
				cy = m_rect.Height()/m_row;
				x = m_rect.left+cx/2;
				y = m_rect.top + cy*(port-2)+cy/2;
				pos = CPoint(x,y);
			}
			else {
				cx = m_rect.Width()/m_column;
				cy = m_rect.Height()/m_row;
				xad = (port-2)%m_column;
				yad = (port-2)/m_column;
				x = m_rect.left+cx*xad+cx/2;
				y = m_rect.top+cy*yad+cy/2;
				pos = CPoint(x,y);
			}
		}
		else {
			step = m_rect.Height() / (m_outport+1);
			pos = CPoint(m_rect.right, m_rect.top+step*port);
		}
		break;
	case	DIR_UP:
		if(m_row*m_column > 1 && port > 1) {
			//`FbN
			if(m_row == 1) {
				cx = m_rect.Width()/m_column;
				cy = m_rect.Height();
				x = m_rect.left+cx*(port-2)+cx/2;
				y = m_rect.top + cy/2;
				pos = CPoint(x,y);
			}
			else if(m_column == 1) {
				cx = m_rect.Width();
				cy = m_rect.Height()/m_row;
				x = m_rect.left+cx/2;
				y = m_rect.top + cy*(port-2)+cy/2;
				pos = CPoint(x,y);
			}
			else {
				cx = m_rect.Width()/m_column;
				cy = m_rect.Height()/m_row;
				xad = (port-2)%m_column;
				yad = (port-2)/m_column;
				x = m_rect.left+cx*xad+cx/2;
				y = m_rect.top+cy*yad+cy/2;
				pos = CPoint(x,y);
			}
		}
		else {
			step = m_rect.Width() / (m_outport+1);
			pos = CPoint(m_rect.left+step*port, m_rect.top);
		}
		break;
	case	DIR_LEFT:
		if(m_row*m_column > 1 && port > 1) {
			if(m_row == 1) {
				cx = m_rect.Width()/m_column;
				cy = m_rect.Height();
				x = m_rect.right+cx*(port-2)+cx/2;
				y = m_rect.top + cy/2;
				pos = CPoint(x,y);
			}
			else if(m_column == 1) {
				cx = m_rect.Width();
				cy = m_rect.Height()/m_row;
				x = m_rect.right+cx/2;
				y = m_rect.top + cy*(port-2)+cy/2;
				pos = CPoint(x,y);
			}
			else {
				cx = m_rect.Width()/m_column;
				cy = m_rect.Height()/m_row;
				xad = (port-2)%m_column;
				yad = (port-2)/m_column;
				x = m_rect.right+cx*xad+cx/2;
				y = m_rect.top+cy*yad+cy/2;
				pos = CPoint(x,y);
			}
		}
		else {
			step = m_rect.Height() / (m_outport+1);
			pos = CPoint(m_rect.left, m_rect.top+step*port);
		}
		break;
	case	DIR_DOWN:
		if(m_row*m_column > 1 && port > 1) {
			//`FbN
			if(m_row == 1) {
				cx = m_rect.Width()/m_column;
				cy = m_rect.Height();
				x = m_rect.left+cx*(port-2)+cx/2;
				y = m_rect.top + cy/2;
				pos = CPoint(x,y);
			}
			else if(m_column == 1) {
				cx = m_rect.Width();
				cy = m_rect.Height()/m_row;
				x = m_rect.left+cx/2;
				y = m_rect.top + cy*(port-2)+cy/2;
				pos = CPoint(x,y);
			}
			else {
				cx = m_rect.Width()/m_column;
				cy = m_rect.Height()/m_row;
				xad = (port-2)%m_column;
				yad = (port-2)/m_column;
				x = m_rect.left+cx*xad+cx/2;
				y = m_rect.top+cy*yad+cy/2;
				pos = CPoint(x,y);
			}
		}
		else {
			step = m_rect.Width() / (m_outport+1);
			pos = CPoint(m_rect.left+step*port, m_rect.bottom);
		}
		break;
	}
	return pos;
}

int CWidget::AreaInWidget(CRect rect)
{
	int hitFrom,hitTo;

	hitFrom = rect.PtInRect(m_ptFrom);
	hitTo = rect.PtInRect(m_ptTo);
	if(hitFrom && hitTo)
		return WIDGET_IN;
	else if(!hitFrom && hitTo)
		return WIDGET_CROSS;
	else if(hitFrom && !hitTo)
		return WIDGET_CROSS;
	else
		return WIDGET_OUT;
}

int CWidget::GetLevel()
{
	return m_level;
}
void CWidget::SetLevel(int lv)
{
	m_level = lv;
}
int CWidget::GetJunction()
{
	return m_junction;
}
void CWidget::SetJunction(int id)
{
	m_junction = id;
}

CPtrArray* CWidget::GetSubsysWidgets()
{
	return (&m_subsysWidgets);
}

CPtrArray* CWidget::GetSubsysLines()
{
	return (&m_subsysLines);
}

int CWidget::GetInportLine()
{
	return m_bInportLine;
}
void CWidget::SetInportLine(int value)
{
	int chk;
	chk = 0x1;
	chk = chk << (value-1);
	m_bInportLine |= chk;
}

void CWidget::ResetInportLine(int value)
{
	int chk;
	chk = 0x1;
	chk = chk << (value-1);
	chk = ~chk;
	m_bInportLine &= chk;
}

int CWidget::GetOutportLine()
{
	return m_bOutportLine;
}
void CWidget::SetOutportLine(int value)
{
	int chk;
	chk = 0x1;
	chk = chk << (value-1);
	m_bOutportLine |= chk;
}

void CWidget::ResetOutportLine(int value)
{
	int chk;
	chk = 0x1;
	chk = chk << (value-1);
	chk = ~chk;
	m_bOutportLine &= chk;
}

// rowcolumnԂ
int CWidget::GetCellRow()
{
	return m_row;
}
int CWidget::GetCellColumn()
{
	return m_column;
}

// matrix𕪉
int CWidget::GetMatrixRow(CString matrix)
{
	int index;
	CString strRow;

	index = matrix.Find(':');
	strRow = matrix.Left(index);
	return atoi(strRow);
}
int CWidget::GetMatrixColumn(CString matrix)
{
	int index;
	CString strColumn;

	index = matrix.Find(':');
	strColumn = matrix.Mid(index+1);
	return atoi(strColumn);
}

// Format
CString CWidget::GetMatrix()
{
	return m_matrix;
}

void CWidget::SetMatrix(CString matrix)
{
	int row,column;
	int width,height;

	//gĂꍇ́AP̑傫ɂ
	row = GetMatrixRow(m_matrix);
	column = GetMatrixColumn(m_matrix);
	if(row*column != 1) {
		//1CELL̑傫
		width = m_rect.Width();
		height = m_rect.Height();
		m_rect.right = m_rect.left + (int)((double)width/column+0.5);
		m_rect.bottom = m_rect.top + (int)((double)height/row+0.5);
	}

	//VTCYɕύX
	m_matrix = matrix;
	m_row = GetMatrixRow(m_matrix);
	m_column = GetMatrixColumn(m_matrix);
	if(m_row*m_column == 1)
		return;

	//Crect̑傫ύX
	width = m_rect.Width();
	height = m_rect.Height();
	m_rect.right = m_rect.left + width * m_column;
	m_rect.bottom = m_rect.top + height * m_row;
}

// Outport
int CWidget::GetOutport()
{
	return m_outport;
}
void CWidget::SetOutport(int outport)
{
	m_outport = outport;
}
// Inport
int CWidget::GetInport()
{
	return m_inport;
}
void CWidget::SetInport(int inport)
{
	m_inport = inport;
}
// Widgeť
int CWidget::GetDirection()
{
	return m_direction;
}
void CWidget::SetDirection(int direction)
{
	// m_bitmapΉ
	if(m_direction != direction) {
		//قȂ
		delete m_bitmap;
		m_bitmap = NULL;
	}

	m_direction = direction;
	// m_pItemݒ肵Ă
	m_pItem->direction = direction;
}
CString CWidget::GetModel()
{
	return m_model;
}
int CWidget::GetSearch()
{
	return m_search;
}
void CWidget::SetSearch(int order)
{
	m_search = order;
}

int CWidget::GetOrder()
{
	return m_order;
}
void CWidget::SetOrder(int order)
{
	m_order = order;
}

BLOCKINFO* CWidget::GetPitem()
{
	return m_pItem;
}

CString CWidget::GetName()
{
	return m_name;
}

void CWidget::SetName(CString str)
{
	m_name = str;
}

CPtrArray* CWidget::GetParamPointer()
{
	return (&m_paramArray);
}

CPtrArray* CWidget::GetSubsysPointer()
{
	return (&m_subsysArray);
}

CPtrArray* CWidget::GetScopePointer()
{
	return (&m_scopeArray);
}

CPoint CWidget::GetPoint()
{
	return m_point;
}

CRect CWidget::GetRect()
{
	return m_rect;
}

void CWidget::SetRect(CRect rect)
{
	m_rect = rect;
}

COLORREF CWidget::GetColor()
{
	return m_color;
}

int CWidget::GetId()
{
	return m_id;
}

/*Inport*/
void CWidget::SetInportName(CPtrArray *inpname)
{
	int nCount,i;
	NAMEINFO *tmpItem,*pItem;
	CString xy;

	nCount = (int)inpname->GetSize();
	for(i = 0; i < nCount; i++) {
		pItem = (NAMEINFO *)inpname->GetAt(i);
		try {
			tmpItem = new NAMEINFO;
		}
		catch (CMemoryException* e) {
			e->Delete ();
			return;
		}
		if(m_id == M_XY) {
			// 3͈ȏ݂͑Ȃ
			switch(i) {
			case 0:
				xy = _T("x");	break;
			case 1:
				xy = _T("y");	break;
			case 2:
				xy = _T("z");	break;
			}
			tmpItem->strName = _T(xy);
			m_inpname.InsertAt( i, tmpItem );

		}
		else {
		tmpItem->strName = _T(pItem->strName);
		m_inpname.InsertAt( i, tmpItem );
		}
	}

}

CPtrArray* CWidget::GetInportName()
{
	return &m_inpname;
}

void CWidget::ChangeInportName()
{
	int i,nCount;
	NAMEINFO* tmpItem;
	char name[32];
	nCount = (int)m_inpname.GetSize();
	if(m_inport != nCount) {
		if(nCount < m_inport) {
			//ǉ
			for(i = nCount; i < m_inport; i++) {
				try {
					tmpItem = new NAMEINFO;
				}
				catch (CMemoryException* e) {
					e->Delete ();
					return;
				}
				if(m_id == M_XY) {
					// 3͈ȏ݂͑Ȃ
					switch(i) {
					case 0:
						strcpy(name,"x");	break;
					case 1:
						strcpy(name,"y");	break;
					case 2:
						strcpy(name,"z");	break;
					}
					tmpItem->strName = _T(name);
					m_inpname.InsertAt( i, tmpItem );

				}
				else {
					sprintf(name,"%d", i);
					tmpItem->strName = _T(name);
					m_inpname.InsertAt( i, tmpItem );
				}
			}
		}
		else {
			//]ȏ폜
			for(i = nCount-1; i >= m_inport; i--) {
				m_inpname.RemoveAt(i);
			}
		}
	}
}

/*Inport*/
void CWidget::SetOutportName(CPtrArray *outpname)
{
	int nCount,i;
	NAMEINFO *tmpItem,*pItem;

	nCount = (int)outpname->GetSize();
	for(i = 0; i < nCount; i++) {
		pItem = (NAMEINFO *)outpname->GetAt(i);
		try {
			tmpItem = new NAMEINFO;
		}
		catch (CMemoryException* e) {
			e->Delete ();
			return;
		}
		tmpItem->strName = _T(pItem->strName);
		m_outpname.InsertAt( i, tmpItem );
	}
	
}

CPtrArray* CWidget::GetOutportName()
{
	return &m_outpname;
}

void CWidget::ChangeOutportName()
{
	int i,nCount;
	NAMEINFO* tmpItem;
	char name[32];
	nCount = (int)m_outpname.GetSize();
	if(m_outport != nCount) {
		if(nCount < m_outport) {
			//ǉ
			for(i = nCount; i < m_outport; i++) {
				try {
					tmpItem = new NAMEINFO;
				}
				catch (CMemoryException* e) {
					e->Delete ();
					return;
				}
				sprintf(name,"%d", i);
				tmpItem->strName = _T(name);
				m_outpname.InsertAt( i, tmpItem );
			}
		}
		else {
			//]ȏ폜
			for(i = nCount-1; i >= m_outport; i--) {
				m_outpname.RemoveAt(i);
			}
		}
	}
}

void CWidget::Serialize (CArchive& ar)
{
	CObject::Serialize (ar);

	if (ar.IsStoring ())
		ar << m_direction << m_point << m_id;
	else 
		ar >> m_point >> m_id >> m_direction;
}

void CWidget::Draw(CDC *pDC)
{
	//image`
	HDC hDCMem;
	char file[_MAX_PATH],modulepath[_MAX_PATH];
	int	row,column,xstart,ystart,xstep,ystep;
	DWORD bfOffBits;

	// rbg}bvt@C
	if(!m_bitmap) {
		if(GetModuleDirectory(modulepath, _MAX_PATH) == NULL)
			return;
		if(m_bmpName.IsEmpty() != 0)
			sprintf(file,"%s\\ncs\\bmp\\%s",modulepath,m_pItem->fBitmap);
		else
			sprintf(file,"%s\\ncs\\bmp\\%s",modulepath,m_bmpName);
		m_bitmap = LoadBitmapFile(file, &bfOffBits);
		if(!m_bitmap)
			return;
		m_bfOffBits = bfOffBits;
	}
	// HDC
	hDCMem = pDC->GetSafeHdc();
	// rbg}bv̕`
	if(m_row*m_column == 1) {
		StretchDIBits(hDCMem,
			m_rect.left, m_rect.top, m_rect.Width(), m_rect.Height(),
			0, 0, 32, 32,
			(BYTE *)(m_bitmap) + m_bfOffBits - sizeof(BITMAPFILEHEADER),
			(BITMAPINFO*)m_bitmap,
			DIB_RGB_COLORS,
			SRCCOPY);
	}
	else {
		//Cellg
		ystart = m_rect.top;
		xstep = m_rect.Width() / m_column;
		ystep = m_rect.Height() / m_row;
		for(row = 0; row < m_row; row++) {
			xstart = m_rect.left;
			for(column = 0; column < m_column; column++) {
				StretchDIBits(hDCMem,
					xstart, ystart, xstep, ystep,
					0, 0, 32, 32,
					(BYTE *)(m_bitmap) + m_bfOffBits - sizeof(BITMAPFILEHEADER),
					(BITMAPINFO*)m_bitmap,
					DIB_RGB_COLORS,
					SRCCOPY);
				xstart += xstep;
			}
			ystart += ystep;
		}
	}
	//o͏
	DrawInport(pDC);
	DrawOutport(pDC);

	//O`
	if(m_id == M_TITLE)
		DrawTitle(pDC);
	else
		DrawName(pDC);
}

void * CWidget::LoadBitmapFile(LPCTSTR lpszPathName, DWORD *bfOffBits) 
{
	char msgbuf[_MAX_PATH];
	CFile file;
	BITMAPFILEHEADER bmpHeader;
	unsigned long fileSize, leftSize;
	void *bitmap;
	BITMAPINFOHEADER bmpInfo;

	// I[v
	if (file.Open(lpszPathName, CFile::modeRead | CFile::shareDenyWrite) == FALSE) {
		sprintf(msgbuf, "%s̃I[vɎs܂", lpszPathName);
		AfxMessageBox(msgbuf, MB_OK, NULL);
		return NULL;
	}

	// t@C̒
	fileSize = (unsigned long)file.GetLength();

	// rbg}bvwb_[̎擾
	if (file.Read((LPSTR)&bmpHeader, BMP_HEADER_SIZE) != BMP_HEADER_SIZE)
		return NULL;
	*bfOffBits = bmpHeader.bfOffBits;

	// rbg}bvt@Cł邱Ƃ̊mFibfType=="BM" ?j
	if (bmpHeader.bfType != BMP_HEADER_ID) {
		AfxMessageBox(_T("BITMAPł͂܂"));
		return NULL;
	}

	// [hp̊m
	bitmap = (void*)new char[fileSize];

	// rbg}bv̓ǂݍ
	leftSize = fileSize - BMP_HEADER_SIZE;
	if (file.Read(bitmap, leftSize) != leftSize) {
		delete bitmap;
		return NULL;
	}

	file.Close();

// rbg}bv
 file.Open(lpszPathName, CFile::modeRead | CFile::shareDenyWrite);
 file.Read((LPSTR)&bmpHeader, BMP_HEADER_SIZE);
 file.Read((LPSTR)&bmpInfo, sizeof(BITMAPINFOHEADER));
 file.Close();

//rbg}bvϊ
	BYTE* pByte;
	BYTE* pSByte;
	BYTE* pLine;
	int i,j;
	BYTE px1,px2;
	BYTE spx1,spx2;
	BYTE tmp;
	void *sbitmap;

	sbitmap = (void*)new char[bmpInfo.biSizeImage];
	if(m_direction == DIR_LEFT) {
		// LeftWidgetɕύX
		pByte = (BYTE*)bitmap+bmpHeader.bfOffBits-sizeof(BITMAPFILEHEADER);
		for(i = 0; i < bmpInfo.biHeight; i++) {
			pLine = pByte + i * bmpInfo.biHeight/2;
			for(j = 0; j < 8; j++) {
				// left
				px1 = *(pLine + j);
				spx2 = px1 & 0xf0;
				spx2 = spx2 >> 4;
				tmp = px1 & 0xf;
				tmp = tmp << 4;
				spx2 |= tmp;
				// right
				px2 = *(pLine+15-j);
				spx1 = px2 & 0xf0;
				spx1 = spx1 >> 4;
				tmp = px2 & 0xf;
				tmp = tmp << 4;
				spx1 |= tmp;
				// 
				*(pLine + j) = spx1;
				*(pLine+15-j) = spx2;
			}
		}
	}
	else if(m_direction == DIR_DOWN) {
		// DowmWidgetɕύX
		pByte = (BYTE*)bitmap+bmpHeader.bfOffBits-sizeof(BITMAPFILEHEADER);
		for(i = 0; i < 16; i++) {
			pLine = pByte + 2 * i * bmpInfo.biHeight/2;
			for(j = 0; j < 16; j++) {
				//this
				px1 = *(pLine + j);
				spx1 = px1 & 0xf0;
				spx2 = px1 & 0xf;
				spx2 = spx2 << 4;
				//
				pSByte = (BYTE*)sbitmap + (16-j-1)*2*16+i;
				*pSByte = spx2;
				pSByte = (BYTE*)sbitmap + ((16-j-1)*2+1)*16+i;
				*pSByte = spx1;
			}
			pLine = pByte + (2 * i + 1) * bmpInfo.biHeight/2;
			for(j = 0; j < 16; j++) {
				//this
				px1 = *(pLine + j);
				spx1 = px1 & 0xf0;
				spx1 = spx1 >> 4;
				spx2 = px1 & 0xf;
				//
				pSByte = (BYTE*)sbitmap + (16-j-1)*2*16+i;
				*pSByte |= spx2;
				pSByte = (BYTE*)sbitmap + ((16-j-1)*2+1)*16+i;
				*pSByte |= spx1;
			}
		}
		// bitmapɖ߂
		pSByte = (BYTE*)sbitmap;
		for(i = 0; i < 32; i++) {
			for(j = 0; j < 16; j++) {
				*pByte++ = *pSByte++;
			}
		}
	}
	else if(m_direction == DIR_UP) {
		// UpWidgetɕύX
		pByte = (BYTE*)bitmap+bmpHeader.bfOffBits-sizeof(BITMAPFILEHEADER);
		for(i = 0; i < 16; i++) {
			pLine = pByte + 2 * i * bmpInfo.biHeight/2;
			for(j = 0; j < 16; j++) {
				//this
				px1 = *(pLine + j);
				spx1 = px1 & 0xf0;
				spx2 = px1 & 0xf;
				spx2 = spx2 << 4;
				//
				pSByte = (BYTE*)sbitmap + j*2*16+i;
				*pSByte = spx1;
				pSByte = (BYTE*)sbitmap + (j*2+1)*16+i;
				*pSByte = spx2;
			}
			pLine = pByte + (2 * i + 1) * bmpInfo.biHeight/2;
			for(j = 0; j < 16; j++) {
				//this
				px1 = *(pLine + j);
				spx1 = px1 & 0xf0;
				spx1 = spx1 >> 4;
				spx2 = px1 & 0xf;
				//
				pSByte = (BYTE*)sbitmap + j*2*16+i;
				*pSByte |= spx1;
				pSByte = (BYTE*)sbitmap + (j*2+1)*16+i;
				*pSByte |= spx2;
			}
		}
		// bitmapɖ߂
		pSByte = (BYTE*)sbitmap;
		for(i = 0; i < 32; i++) {
			for(j = 0; j < 16; j++) {
				*pByte++ = *pSByte++;
			}
		}
	}

	delete sbitmap;

	return bitmap;
}

BYTE* CWidget::GetBitmapBits( void *bitmap )
{
	DWORD numOfColors;
	BITMAPINFOHEADER *pBitmap = (BITMAPINFOHEADER*)bitmap;
	WORD bitCount = pBitmap->biBitCount;

	if (pBitmap->biSize >= 36)
		numOfColors = pBitmap->biClrUsed;
	else
		numOfColors = 0;

	if (numOfColors == 0 && bitCount != 24) 
			numOfColors = 1L << bitCount;

	return (BYTE*)pBitmap + pBitmap->biSize + numOfColors * sizeof(RGBQUAD);
}

void CWidget::DrawSelected(CDC *pDC)
{
	//void *bitmap;
	HDC hDCMem;
	char file[_MAX_PATH], modulepath[_MAX_PATH];
	int	row,column,xstart,ystart,xstep,ystep;
	DWORD bfOffBits;

	// rbg}bvt@C
	if(!m_bitmap) {
		if(GetModuleDirectory(modulepath, _MAX_PATH) == NULL)
			return;
		if(m_bmpName.IsEmpty() != 0)
			sprintf(file,"%s\\ncs\\bmp\\%s",modulepath,m_pItem->fBitmap);
		else
			sprintf(file,"%s\\ncs\\bmp\\%s",modulepath,m_bmpName);
		m_bitmap = LoadBitmapFile(file, &bfOffBits);
		m_bfOffBits = bfOffBits;
	}
	// HDC
	hDCMem = pDC->GetSafeHdc();
	// rbg}bv̕`
	if(m_row*m_column == 1) {
		StretchDIBits(hDCMem,
			m_rect.left, m_rect.top, m_rect.Width(), m_rect.Height(),
			0, 0, 0, m_rect.Height()/*32*/,
			(BYTE *)(m_bitmap) + m_bfOffBits - sizeof(BITMAPFILEHEADER),
			(BITMAPINFO*)m_bitmap,
			DIB_RGB_COLORS,
			SRCCOPY);
	}
	else {
		//Cellg
		ystart = m_rect.top;
		xstep = m_rect.Width() / m_column;
		ystep = m_rect.Height() / m_row;
		for(row = 0; row < m_row; row++) {
			xstart = m_rect.left;
			for(column = 0; column < m_column; column++) {
				StretchDIBits(hDCMem,
					xstart, ystart, xstep, ystep,
					0, 0, 32, 32,
					(BYTE *)(m_bitmap) + m_bfOffBits - sizeof(BITMAPFILEHEADER),
					(BITMAPINFO*)m_bitmap,
					DIB_RGB_COLORS,
					SRCCOPY);
				xstart += xstep;
			}
			ystart += ystep;
		}
	}
	//o͏
	DrawInport(pDC);
	DrawOutport(pDC);

	//IꂽƂ
	CPoint handle;
	handle.x = m_rect.left;
	handle.y = m_rect.top;
	pDC->PatBlt(handle.x - 3, handle.y - 3, 7, 7, DSTINVERT);
	handle.x = m_rect.left;
	handle.y = m_rect.bottom;
	pDC->PatBlt(handle.x - 3, handle.y - 3, 7, 7, DSTINVERT);
	handle.x = m_rect.right;
	handle.y = m_rect.bottom;
	pDC->PatBlt(handle.x - 3, handle.y - 3, 7, 7, DSTINVERT);
	handle.x = m_rect.right;
	handle.y = m_rect.top;
	pDC->PatBlt(handle.x - 3, handle.y - 3, 7, 7, DSTINVERT);
	//O`
	if(m_id == M_TITLE)
		DrawTitle(pDC);
	else
		DrawName(pDC);
}

void CWidget::DrawDragImage(CDC *pDC, POINT point)
{
#ifndef BIMAP_MOVE
    int nOldMode = pDC->SetROP2 (R2_NOT);
    CBrush* pOldBrush = (CBrush*) pDC->SelectStockObject (NULL_BRUSH);

    CPoint points[4];
    points[0].x = point.x;
    points[0].y = point.y + m_rect.Height ();
    points[1].x = point.x;
    points[1].y = point.y;
    points[2].x = point.x + m_rect.Width ();
    points[2].y = point.y;
    points[3].x = point.x + m_rect.Width ();
    points[3].y = point.y + m_rect.Height ();
    pDC->Polygon (points, 4);

    pDC->SelectObject (pOldBrush);
    pDC->SetROP2 (nOldMode);
#else
	HDRAWDIB drawDIB;
	HDC hDCMem;
	UINT uRet;
	BOOL bRet;
	char file[256];
	HPALETTE hPal;
	char drive[16];
	char dir[128];
	char modulepath[128];
	int	row,column,xstart,ystart,xstep,ystep;
	DWORD bfOffBits;

	// rbg}bvt@C
	if(!m_bitmap) {
		::GetModuleFileName(NULL, modulepath, 128);
		// divide
		_splitpath(modulepath, drive, dir, NULL, NULL);
		dir[strlen(dir)-1] = '\0';
		if(m_bmpName.IsEmpty() != 0)
			sprintf(file,"%s%s\\ncs\\bmp\\%s",drive,dir,m_pItem->fBitmap);
		else
			sprintf(file,"%s%s\\ncs\\bmp\\%s",drive,dir,m_bmpName);
		m_bitmap = LoadBitmapFile(file, &bfOffBits);
		m_bfOffBits = bfOffBits;

	}
	// HDC
	hDCMem = pDC->GetSafeHdc();
	// rbg}bv̕`
	if(m_row*m_column == 1) {
		StretchDIBits(hDCMem,
			m_rect.left, m_rect.top, m_rect.Width(), m_rect.Height(),
			0, 0, 32, 32,
			(BYTE *)(m_bitmap) + m_bfOffBits - sizeof(BITMAPFILEHEADER),
			(BITMAPINFO*)m_bitmap,
			DIB_RGB_COLORS,
			SRCCOPY);
	else {
		//Cellg
		ystart = m_rect.top;
		xstep = m_rect.Width() / m_column;
		ystep = m_rect.Height() / m_row;
		for(row = 0; row < m_row; row++) {
			xstart = m_rect.left;
			for(column = 0; column < m_column; column++) {
				StretchDIBits(hDCMem,
					xstart, ystart, xstep, ystep,
					0, 0, 32, 32,
					(BYTE *)(m_bitmap) + m_bfOffBits - sizeof(BITMAPFILEHEADER),
					(BITMAPINFO*)m_bitmap,
					DIB_RGB_COLORS,
					SRCCOPY);
				xstart += xstep;
			}
			ystart += ystep;
		}
	}
	//o͏
	DrawInport(pDC);
	DrawOutport(pDC);

	//O`
	if(m_id == M_TITLE)
		DrawTitle(pDC);
	else
		DrawName(pDC);
#endif
}

int CWidget::PtOnResize(POINT point)
{
	CRect rect;
	rect = CRect(m_rect.left-3,m_rect.top-3,m_rect.left+3,m_rect.top+3);
	if(rect.PtInRect(point))
		return 0;
	rect = CRect(m_rect.left-3,m_rect.bottom-3,m_rect.left+3,m_rect.bottom+3);
	if(rect.PtInRect(point))
		return 1;
	rect = CRect(m_rect.right-3,m_rect.bottom-3,m_rect.right+3,m_rect.bottom+3);
	if(rect.PtInRect(point))
		return 2;
	rect = CRect(m_rect.right-3,m_rect.top-3,m_rect.right+3,m_rect.top+3);
	if(rect.PtInRect(point))
		return 3;
	return -1;
}

// WidgetŃNbNꂽ`FbN
BOOL CWidget::PtInWidget(POINT point)
{
    if (!m_rect.PtInRect (point))
        return FALSE;

    //int cx = min (point.x - m_rect.left, m_rect.right - point.x);
    //return ((m_rect.bottom - point.y) <= (2 * cx));
	return TRUE;
}

void CWidget::DrawName(CDC *pDC)
{
	char name[128];
	int height,width;
	CSize size;

	GetName(m_id, name);
	if(m_row != 1 || m_column != 1) {
		//WidgetgĂ
		strcat(name, "(");
		strcat(name, m_matrix);
		strcat(name, ")");
	}

	height = m_rect.bottom - m_rect.top;
	width = m_rect.right - m_rect.left;
	size = pDC->GetTextExtent(name, (int)strlen(name));
	if(m_id == M_GAP || m_id == M_SYNAPSE) {
			pDC->TextOut(m_rect.left+(width-size.cx) / 2,
				m_rect.bottom-size.cy/2, name);
	}
	else {
		if(m_direction == DIR_UP || m_direction == DIR_DOWN)
			pDC->TextOut(m_rect.left-size.cx,
				m_rect.top+height/2-size.cy/2, name);
		else
			pDC->TextOut(m_rect.left+(width-size.cx) / 2,
				m_rect.bottom+(size.cy) / 2, name);
	}

	//pDC->TextOut(m_rect.left,m_rect.top,name);
	//pDC->ExtTextOut(m_rect.left,m_rect.top,ETO_CLIPPED,
	//	m_rect, name, NULL);

	//Subsystem̏ꍇ́A|[gt
	//́AlKv
//TODO:o͂ɖOĂ
#if 0
	if(m_id == M_SUBSYSTEM) {
		step = (int)((double)m_rect.Height() / (m_inport + 1));
		for(i = 1; i <= m_inport; i++) {
			sprintf(name,"In%d",i);
			size = pDC->GetTextExtent(name, strlen(name));
			pDC->TextOut(m_rect.left-size.cx,
				m_rect.top+i*step-size.cy, name);
		}
		step = m_rect.Height() / (m_outport + 1);
		for(i = 1; i <= m_outport; i++) {
			sprintf(name,"Out%d",i);
			size = pDC->GetTextExtent(name, strlen(name));
			pDC->TextOut(m_rect.right,
				m_rect.top+i*step-size.cy, name);
		}
	}
#endif
}

// m_idM_TITLȄꍇ̏
void CWidget::DrawTitle(CDC *pDC)
{
	char name[128];
	//CSize size;
	CPtrArray* p;
	PARAMINFO* pItem;
	CFont	font;
	CFont*	pOldFont;
	int		height;

	//^Cg
	p = GetParamPointer();
	pItem = (PARAMINFO *)p->GetAt(0);
	strcpy(name, pItem->strValue);

	//`
	pDC->FillSolidRect(m_rect, RGB(192, 255, 255));
	pDC->DrawEdge(m_rect, EDGE_BUMP/*EDGE_SUNKEN*/, BF_RECT);
	//m_rect̍ɍ킹ĕ\
	height = m_rect.Height();
	font.CreateFont((int)(height*0.8),
		0,0,0,FW_NORMAL,0,0,0,SHIFTJIS_CHARSET,
		OUT_STROKE_PRECIS,CLIP_DEFAULT_PRECIS,DRAFT_QUALITY,
		DEFAULT_PITCH,_T("MS P"));
	pOldFont = pDC->SelectObject(&font);
	pDC->SetBkMode( TRANSPARENT );
    pDC->SetTextColor(0x0);
	pDC->DrawText(name, m_rect, DT_SINGLELINE | DT_CENTER | DT_VCENTER);
	pDC->SelectObject(pOldFont);
}

void CWidget::GetName(int id, char name[])
{
	strcpy(name, m_name);
}

void CWidget::SetSel(BOOL sel)
{
	m_selected = sel;
}

BOOL CWidget::GetSel()
{
	return( m_selected );
}

void CWidget::DrawOutport(CDC *pDC)
{
	if(m_outport <= 0)
		return;
	if(m_type == MODULE_SYNAPSE || m_type == MODULE_GAP)
		return;

	CBrush	arrowBrs(RGB(0, 0, 0));
	CBrush	*oldBrs;
	int i,hstep;
	CPoint pt[3];
	NAMEINFO *pItem;
	CSize siz;
	oldBrs = pDC->SelectObject(&arrowBrs);
	switch(m_direction) {
	case	DIR_RIGHT:
		hstep = (m_rect.bottom - m_rect.top) / (m_outport + 1);
		for(i = 1; i <= m_outport; i++) {
			pt[0].x = m_rect.right + 5;
			pt[0].y = m_rect.top + hstep * i;
			pt[1].x = pt[0].x - 5;
			pt[1].y = pt[0].y - 4;
			pt[2].x = pt[0].x - 5;
			pt[2].y = pt[0].y + 4;
			if(!CheckOutport(i))
				pDC->Polygon(pt, 3);
			pItem = (NAMEINFO *)m_outpname.GetAt(i-1);
			siz = pDC->GetTextExtent(pItem->strName);
			pDC->TextOut(pt[0].x-5, pt[0].y-siz.cy-4, pItem->strName);
		}
		break;
	case	DIR_UP:
		hstep = (m_rect.right - m_rect.left) / (m_outport + 1);
		for(i = 1; i <= m_outport; i++) {
			pt[0].x = m_rect.left + hstep * i;
			pt[0].y = m_rect.top - 5;
			pt[1].x = pt[0].x - 4;
			pt[1].y = pt[0].y + 5;
			pt[2].x = pt[0].x + 4;
			pt[2].y = pt[0].y + 5;
			if(!CheckOutport(i))
				pDC->Polygon(pt, 3);
			pItem = (NAMEINFO *)m_outpname.GetAt(i-1);
			siz = pDC->GetTextExtent(pItem->strName);
			pDC->TextOut(pt[0].x-siz.cx, pt[0].y-siz.cy, pItem->strName);
		}
		break;
	case	DIR_LEFT:
		hstep = (m_rect.bottom - m_rect.top) / (m_outport + 1);
		for(i = 1; i <= m_outport; i++) {
			pt[0].x = m_rect.left - 5;
			pt[0].y = m_rect.top + hstep * i;
			pt[1].x = pt[0].x + 5;
			pt[1].y = pt[0].y - 4;
			pt[2].x = pt[0].x + 5;
			pt[2].y = pt[0].y + 4;
			if(!CheckOutport(i))
				pDC->Polygon(pt, 3);
			pItem = (NAMEINFO *)m_outpname.GetAt(i-1);
			siz = pDC->GetTextExtent(pItem->strName);
			pDC->TextOut(pt[0].x-siz.cx, pt[0].y-siz.cy, pItem->strName);
		}
		break;
	case	DIR_DOWN:
		hstep = (m_rect.right - m_rect.left) / (m_outport + 1);
		for(i = 1; i <= m_outport; i++) {
			pt[0].x = m_rect.left + hstep * i;
			pt[0].y = m_rect.bottom + 5;
			pt[1].x = pt[0].x - 4;
			pt[1].y = pt[0].y - 5;
			pt[2].x = pt[0].x + 4;
			pt[2].y = pt[0].y - 5;
			if(!CheckOutport(i))
				pDC->Polygon(pt, 3);
			pItem = (NAMEINFO *)m_outpname.GetAt(i-1);
			siz = pDC->GetTextExtent(pItem->strName);
			pDC->TextOut(pt[0].x-siz.cx, pt[0].y, pItem->strName);
		}
		break;
	}
	pDC->SelectObject(oldBrs);
}

void CWidget::DrawInport(CDC *pDC)
{
	if(m_inport <= 0)
		return;
	if(m_type == MODULE_SYNAPSE || m_type == MODULE_GAP)
		return;
	CBrush	arrowBrs(RGB(0, 0, 0));
	CBrush	*oldBrs;
	int i,hstep;
	CPoint pt[3];
	NAMEINFO *pItem;
	CSize siz;
	oldBrs = pDC->SelectObject(&arrowBrs);
	switch(m_direction) {
	case	DIR_RIGHT:
		hstep = (m_rect.bottom - m_rect.top) / (m_inport + 1);
		for(i = 1; i <= m_inport; i++) {
			pt[0].x = m_rect.left;
			pt[0].y = m_rect.top + hstep * i;
			pt[1].x = pt[0].x - 5;
			pt[1].y = pt[0].y - 4;
			pt[2].x = pt[0].x - 5;
			pt[2].y = pt[0].y + 4;
			if(!CheckInport(i))
				pDC->Polygon(pt, 3);
			pItem = (NAMEINFO *)m_inpname.GetAt(i-1);
			siz = pDC->GetTextExtent(pItem->strName);
			pDC->TextOut(pt[0].x-siz.cx, pt[0].y-siz.cy-4, pItem->strName);
		}
		break;
	case	DIR_UP:
		hstep = (m_rect.right - m_rect.left) / (m_inport + 1);
		for(i = 1; i <= m_inport; i++) {
			pt[0].x = m_rect.left + hstep * i;
			pt[0].y = m_rect.bottom;
			pt[1].x = pt[0].x - 4;
			pt[1].y = pt[0].y + 5;
			pt[2].x = pt[0].x + 4;
			pt[2].y = pt[0].y + 5;
			if(!CheckInport(i))
				pDC->Polygon(pt, 3);
			pItem = (NAMEINFO *)m_inpname.GetAt(i-1);
			siz = pDC->GetTextExtent(pItem->strName);
			pDC->TextOut(pt[0].x-siz.cx, pt[0].y, pItem->strName);
		}
		break;
	case	DIR_LEFT:
		hstep = (m_rect.bottom - m_rect.top) / (m_inport + 1);
		for(i = 1; i <= m_inport; i++) {
			pt[0].x = m_rect.right;
			pt[0].y = m_rect.top + hstep * i;
			pt[1].x = pt[0].x + 5;
			pt[1].y = pt[0].y - 4;
			pt[2].x = pt[0].x + 5;
			pt[2].y = pt[0].y + 4;
			if(!CheckInport(i))
				pDC->Polygon(pt, 3);
			pItem = (NAMEINFO *)m_inpname.GetAt(i-1);
			siz = pDC->GetTextExtent(pItem->strName);
			pDC->TextOut(pt[0].x, pt[0].y-siz.cy, pItem->strName);
		}
		break;
	case	DIR_DOWN:
		hstep = (m_rect.right - m_rect.left) / (m_inport + 1);
		for(i = 1; i <= m_inport; i++) {
			pt[0].x = m_rect.left + hstep * i;
			pt[0].y = m_rect.top;
			pt[1].x = pt[0].x - 4;
			pt[1].y = pt[0].y - 5;
			pt[2].x = pt[0].x + 4;
			pt[2].y = pt[0].y - 5;
			if(!CheckInport(i))
				pDC->Polygon(pt, 3);
			pItem = (NAMEINFO *)m_inpname.GetAt(i-1);
			siz = pDC->GetTextExtent(pItem->strName);
			pDC->TextOut(pt[0].x-siz.cx, pt[0].y-siz.cy, pItem->strName);
		}
		break;
	}
	pDC->SelectObject(oldBrs);
}

BOOL CWidget::CheckInport(int index)
{
	int chk;
	chk = 0x1;
	chk = chk << (index-1);
	if(m_bInportLine & chk)
		return TRUE;
	else
		return FALSE;	
}
BOOL CWidget::CheckOutport(int index)
{
	int chk;
	chk = 0x1;
	chk = chk << (index-1);
	if(m_bOutportLine & chk)
		return TRUE;
	else
		return FALSE;	
}

void CWidget::InvertLine(CDC *pDC, POINT from, POINT to)
{
    int nOldMode = pDC->SetROP2 (R2_NOT);
    pDC->MoveTo (from);
    pDC->LineTo (to);
    pDC->SetROP2 (nOldMode);
}


/////////////////////////////////////////////////////////////////////////////
// CLine

IMPLEMENT_SERIAL(CLine, CObject, 1)

CLine::CLine()
{
}

CLine::CLine (CPoint spt, CPoint ept, int sidx, int eidx, COLORREF color, int arrow, int idx,
			  int inport, int outport, int type, int junc)
{
	m_spt = spt;
	m_ept = ept;
	m_xs = spt.x;
	m_ys = spt.y;
	m_xe = ept.x;
	m_ye = ept.y;
	m_color = color;
	m_arrow = arrow;
	m_sblk = sidx;
	m_eblk = eidx;
	m_selected = FALSE;
	m_index = idx;
	m_inport = inport;
	m_outport = outport;
	m_type = type;
	//l
	m_junction = junc;
}

CLine::~CLine()
{
}

void CLine::Serialize (CArchive& ar)
{
	CObject::Serialize (ar);

	if (ar.IsStoring ())
		ar << m_spt << m_ept << m_sblk << m_eblk << m_color << m_arrow << m_index;
	else 
		ar >> m_spt >> m_ept >> m_sblk >> m_eblk >> m_color >> m_arrow >> m_index;
}

/////////////////////////////////////////////////////////////////////////////
// CLine bZ[W nh

void CLine::SetJunction(int junc)
{
	m_junction = junc;
}
int CLine::GetJunction()
{
	return m_junction;
}

void CLine::SetThickness(int val)
{
	m_thickness = val;
}
int CLine::GetThickness()
{
	return m_thickness;
}

int CLine::GetType()
{
	return m_type;
}
void CLine::DrawDragImage(CDC *pDC, POINT point)
{
    int nOldMode = pDC->SetROP2 (R2_NOT);
	int cx, cy;
	cx = (m_ept.x-m_spt.x);
	cy = (m_ept.y-m_spt.y);
	pDC->MoveTo(point.x,point.y);
	pDC->LineTo(point.x+cx, point.y+cy);
    pDC->SetROP2 (nOldMode);
}

int CLine::GetInport()
{
	return m_inport;
}
void CLine::SetInport(int port)
{
	m_inport = port;
}
int CLine::GetOutport()
{
	return m_outport;
}
void CLine::SetOutport(int port)
{
	m_outport = port;
}
int CLine::GetIndex()
{
	return m_index;
}

CPoint CLine::GetSpos()
{
	return m_spt;
}

CPoint CLine::GetEpos()
{
	return m_ept;
}
void CLine::SetSpos(CPoint pos)
{
	m_spt = pos;
	m_xs = pos.x;
	m_ys = pos.y;
}

void CLine::SetEpos(CPoint pos)
{
	m_ept = pos;
	m_xe = pos.x;
	m_ye = pos.y;
}

COLORREF CLine::GetColor()
{
	return m_color;
}

void CLine::SetSblk(int val)
{
	m_sblk = val;
}
int CLine::GetSblk()
{
	return m_sblk;
}

void CLine::SetEblk(int val)
{
	m_eblk = val;
}
int CLine::GetEblk()
{
	return m_eblk;
}

int CLine::GetArrow()
{
	return m_arrow;
}

// m_arrow = 0		Ȃ
// m_arrow = 1		->
// m_arrow = 2		
// m_arrow = 3		<-

void CLine::SetArrow(int style)
{
	m_arrow = style;
}

void CLine::Draw(CDC *pDC)
{
	CPen pen;
	COLORREF lcolor;
	//if(m_selected)
	//	lcolor = RGB(255,0,0);
	//else
		lcolor = m_color;
	pen.CreatePen(PS_SOLID, m_thickness, lcolor);
	CPen* pOldPen = pDC->SelectObject (&pen);
	CBrush brush (m_color);
	CBrush* pOldBrush = pDC->SelectObject (&brush);
	CRect	branchRect;

	//g`
	pDC->MoveTo(CPoint(m_xs,m_ys));
	pDC->LineTo(CPoint(m_xe,m_ye));
	//[
    CPoint points[3];
	if(m_arrow == 1) {		//
		if(m_xs == m_xe) {
			//
			if(m_ys > m_ye) {
				//
				points[0].x = m_xe;
				points[0].y = m_ye;
				if(m_thickness > 1) {
					points[1].x = m_xe+4;
					points[1].y = m_ye+6;
					points[2].x = m_xe-4;
					points[2].y = m_ye+6;
				}
				else {
					points[1].x = m_xe+3;
					points[1].y = m_ye+5;
					points[2].x = m_xe-3;
					points[2].y = m_ye+5;
				}
			}
			else {
				//
				points[0].x = m_xe;
				points[0].y = m_ye;
				if(m_thickness > 1) {
					points[1].x = m_xe+4;
					points[1].y = m_ye-6;
					points[2].x = m_xe-4;
					points[2].y = m_ye-6;
				}
				else {
					points[1].x = m_xe+3;
					points[1].y = m_ye-5;
					points[2].x = m_xe-3;
					points[2].y = m_ye-5;
				}
			}
		}
		else {
			if(m_xs > m_xe) {
				//
				points[0].x = m_xe;
				points[0].y = m_ye;
				if(m_thickness > 1) {
					points[1].x = m_xe+6;
					points[1].y = m_ye-4;
					points[2].x = m_xe+6;
					points[2].y = m_ye+4;
				}
				else {
					points[1].x = m_xe+5;
					points[1].y = m_ye-3;
					points[2].x = m_xe+5;
					points[2].y = m_ye+3;
				}
			}
			else {
				//E
				points[0].x = m_xe;
				points[0].y = m_ye;
				if(m_thickness > 1) {
					points[1].x = m_xe-6;
					points[1].y = m_ye-4;
					points[2].x = m_xe-6;
					points[2].y = m_ye+4;
				}
				else {
					points[1].x = m_xe-5;
					points[1].y = m_ye-3;
					points[2].x = m_xe-5;
					points[2].y = m_ye+3;
				}
			}
		}
		pDC->Polygon (points, 3);
	}
	else if(m_arrow == 2) {		//_
		if(m_thickness > 1) {
			branchRect.left = m_xs - 3;
			branchRect.top = m_ys - 3;
			branchRect.right = m_xs + 3;
			branchRect.bottom = m_ys + 3;
		}
		else {
			branchRect.left = m_xs - 2;
			branchRect.top = m_ys - 2;
			branchRect.right = m_xs + 2;
			branchRect.bottom = m_ys + 2;
		}
		pDC->Ellipse( branchRect );
	}
	else if(m_arrow == 3) {
		if(m_xs == m_xe) {
			//
			if(m_ys > m_ye) {
				//
				points[0].x = m_xe;
				points[0].y = m_ye;
				if(m_thickness > 1) {
					points[1].x = m_xe+4;
					points[1].y = m_ye+6;
					points[2].x = m_xe-4;
					points[2].y = m_ye+6;
				}
				else {
					points[1].x = m_xe+3;
					points[1].y = m_ye+5;
					points[2].x = m_xe-3;
					points[2].y = m_ye+5;
				}
			}
			else {
				//
				points[0].x = m_xe;
				points[0].y = m_ye;
				if(m_thickness > 1) {
					points[1].x = m_xe+4;
					points[1].y = m_ye-6;
					points[2].x = m_xe-4;
					points[2].y = m_ye-6;
				}
				else {
					points[1].x = m_xe+3;
					points[1].y = m_ye-5;
					points[2].x = m_xe-3;
					points[2].y = m_ye-5;
				}
			}
		}
		else {
			if(m_xs > m_xe) {
				//
				points[0].x = m_xs;
				points[0].y = m_ys;
				if(m_thickness > 1) {
					points[1].x = m_xs-6;
					points[1].y = m_ys-4;
					points[2].x = m_xs-6;
					points[2].y = m_ys+4;
				}
				else {
					points[1].x = m_xs-5;
					points[1].y = m_ys-3;
					points[2].x = m_xs-5;
					points[2].y = m_ys+3;
				}
			}
			else {
				//E
				points[0].x = m_xs;
				points[0].y = m_ys;
				if(m_thickness > 1) {
					points[1].x = m_xs+6;
					points[1].y = m_ys-4;
					points[2].x = m_xs+6;
					points[2].y = m_ys+4;
				}
				else {
					points[1].x = m_xs+5;
					points[1].y = m_ys-3;
					points[2].x = m_xs+5;
					points[2].y = m_ys+3;
				}
			}
		}
		pDC->Polygon (points, 3);
	}

	pDC->SelectObject (pOldPen);
	pDC->SelectObject (pOldBrush);
	pen.DeleteObject();

	if(m_selected) {
		//CIĂ
		pDC->PatBlt(m_xs - 3, m_ys - 3, 7, 7, DSTINVERT);
		pDC->PatBlt(m_xe - 3, m_ye - 3, 7, 7, DSTINVERT);
	}
}

BOOL CLine::PtInLine(POINT point)
{
	CRect rect;
	rect = CRect(m_xs-2, m_ys-2, m_xe+2, m_ye+2);
	rect.NormalizeRect();
    if (!rect.PtInRect (point))
        return FALSE;
	else
		return TRUE;
}

void CLine::SetSel(BOOL sel)
{
	m_selected = sel;
}

BOOL CLine::GetSel()
{
	return( m_selected );
}

//////////////////////////////////////////////////////////////////////

//EӏォAڑɎgp
int CWidget::PtOnRLine(POINT point)
{
#ifndef TRIANGLE_MODE
    if (!m_rect.PtInRect (point))
        return FALSE;
#endif

	int hstep,i,ypos,j,xstep,ystep,xs,ys,index;
	CRect rect;
	CPoint pt;
	CSize size;
	CRgn rgn;
	POINT	npt[3];
	if(m_row*m_column != 1) {
		//gꂽʒuԂ
		xstep = m_rect.Width() / m_column;
		ystep = m_rect.Height() / m_row;
		size = CSize(xstep-2*WAKU_OFFSET, ystep-2*WAKU_OFFSET);
		ys = m_rect.top;
		index = 2;
		for(i = 0; i < m_row; i++) {
			xs = m_rect.left;
			for(j = 0; j < m_column; j++) {
				pt = CPoint(xs+WAKU_OFFSET, ys+WAKU_OFFSET);
				rect = CRect(pt, size);
				if(rect.PtInRect(point))
					return index;
				index++;
				xs += xstep;
			}
			ys += ystep;
		}
	}
	//else {
		switch(m_direction) {
		case	DIR_RIGHT:
			hstep = (m_rect.bottom - m_rect.top) / (m_outport + 1);
			ypos = m_rect.top;
			for(i = 1; i <= m_outport; i++) {
#ifndef TRIANGLE_MODE
				if(abs(m_rect.right-point.x) <= 2) {
					//
					if(abs(ypos+hstep*i-point.y) <= 2) 
						return i;
				}
#else
				npt[0].x = m_rect.right + 5;
				npt[0].y = m_rect.top + hstep * i;
				npt[1].x = npt[0].x - 5;
				npt[1].y = npt[0].y - 4;
				npt[2].x = npt[0].x - 5;
				npt[2].y = npt[0].y + 4;
				rgn.CreatePolygonRgn(npt, 3, ALTERNATE);
				if(rgn.PtInRegion(point)) {
					rgn.DeleteObject();
					return i;
				}
				rgn.DeleteObject();
#endif
			}
			break;
		case	DIR_UP:
			hstep = (m_rect.right - m_rect.left) / (m_outport + 1);
			ypos = m_rect.left;
			for(i = 1; i <= m_outport; i++) {
#ifndef TRIANGLE_MODE
				if(abs(m_rect.top-point.y) <= 2) {
					//
					if(abs(ypos+hstep*i-point.x) <= 2) 
						return i;
				}
#else
				npt[0].x = m_rect.left + hstep * i;
				npt[0].y = m_rect.top - 5;
				npt[1].x = npt[0].x - 4;
				npt[1].y = npt[0].y + 5;
				npt[2].x = npt[0].x + 4;
				npt[2].y = npt[0].y + 5;
				rgn.CreatePolygonRgn(npt, 3, ALTERNATE);
				if(rgn.PtInRegion(point)) {
					rgn.DeleteObject();
					return i;
				}
				rgn.DeleteObject();
#endif
			}
			break;
		case	DIR_LEFT:
			hstep = (m_rect.bottom - m_rect.top) / (m_outport + 1);
			ypos = m_rect.top;
			for(i = 1; i <= m_outport; i++) {
#ifndef TRIANGLE_MODE
				if(abs(m_rect.left-point.x) <= 2) {
					//
					if(abs(ypos+hstep*i-point.y) <= 2) 
						return i;
				}
#else
				npt[0].x = m_rect.left - 5;
				npt[0].y = m_rect.top + hstep * i;
				npt[1].x = npt[0].x + 5;
				npt[1].y = npt[0].y - 4;
				npt[2].x = npt[0].x + 5;
				npt[2].y = npt[0].y + 4;
				rgn.CreatePolygonRgn(npt, 3, ALTERNATE);
				if(rgn.PtInRegion(point)) {
					rgn.DeleteObject();
					return i;
				}
				rgn.DeleteObject();
#endif
			}
			break;
		case	DIR_DOWN:
			hstep = (m_rect.right - m_rect.left) / (m_outport + 1);
			ypos = m_rect.left;
			for(i = 1; i <= m_outport; i++) {
#ifndef TRIANGLE_MODE
				if(abs(m_rect.bottom-point.y) <= 2) {
					//
					if(abs(ypos+hstep*i-point.x) <= 2) 
						return i;
				}
#else
				npt[0].x = m_rect.left + hstep * i;
				npt[0].y = m_rect.bottom + 5;
				npt[1].x = npt[0].x - 4;
				npt[1].y = npt[0].y - 5;
				npt[2].x = npt[0].x + 4;
				npt[2].y = npt[0].y - 5;
				rgn.CreatePolygonRgn(npt, 3, ALTERNATE);
				if(rgn.PtInRegion(point)) {
					rgn.DeleteObject();
					return i;
				}
				rgn.DeleteObject();
#endif
			}
			break;
		}

		return FALSE;
	//}
}

//
//Line̐ڑ
//WCELL̏ꍇ́Aindex=1n߁A
//	̓|[ĝ݃`FbN
//gCELL̏ꍇ́Aindex=2n߁A
//	eCELL̈A̓|[g
//
int CWidget::PtOnLLine(POINT point, CPoint *newpos)
{
#ifndef TRIANGLE_MODE
    if (!m_rect.PtInRect (point))
        return FALSE;
#endif

	int hstep,i,ypos,j,xstep,ystep,xs,ys,index;
	CRect rect;
	CPoint pt;
	CSize size;
	CRgn rgn;
	POINT npt[3];
	if(m_row*m_column != 1) {
		//gꂽʒuԂ
		xstep = m_rect.Width() / m_column;
		ystep = m_rect.Height() / m_row;
		size = CSize(xstep-2*WAKU_OFFSET, ystep-2*WAKU_OFFSET);
		ys = m_rect.top;
		index = 2;
		for(i = 0; i < m_row; i++) {
			xs = m_rect.left;
			for(j = 0; j < m_column; j++) {
				pt = CPoint(xs+WAKU_OFFSET, ys+WAKU_OFFSET);
				rect = CRect(pt, size);
				if(rect.PtInRect(point)) {
					newpos->x = xs + xstep / 2;
					newpos->y = ys + ystep / 2;
					return index;
				}
				index++;
				xs += xstep;
			}
			ys += ystep;
		}
	}
	//else {
		switch(m_direction) {
		case	DIR_RIGHT:
			hstep = (m_rect.bottom - m_rect.top) / (m_inport + 1);
			ypos = m_rect.top;
			for(i = 1; i <= m_inport; i++) {
				//Trianglë
				npt[0].x = m_rect.left;
				npt[0].y = m_rect.top + hstep * i;
				npt[1].x = npt[0].x - 5 - CONNECT_OFFSET;
				npt[1].y = npt[0].y - 4 - CONNECT_OFFSET;
				npt[2].x = npt[0].x - 5 - CONNECT_OFFSET;
				npt[2].y = npt[0].y + 4 + CONNECT_OFFSET;
				npt[0].x += CONNECT_OFFSET;
				rgn.CreatePolygonRgn(npt,3,ALTERNATE);
				if(rgn.PtInRegion(point)) {
					rgn.DeleteObject();
					newpos->x = m_rect.left;
					newpos->y = m_rect.top + hstep*i;
					return i;
				}
				rgn.DeleteObject();
			}
			break;
		case	DIR_UP:
			hstep = (m_rect.right - m_rect.left) / (m_inport + 1);
			ypos = m_rect.left;
			for(i = 1; i <= m_inport; i++) {
#ifndef TRIANGLE_MODE
				if(abs(m_rect.bottom-point.y) <= 4) {
					//
					if(abs(ypos+hstep*i-point.x) <= 4) {
						newpos->x = m_rect.left + hstep*i;
						newpos->y = m_rect.bottom;
						return i;
					}
				}
#else
				npt[0].x = m_rect.left + hstep * i;
				npt[0].y = m_rect.bottom;
				npt[1].x = npt[0].x - 4 - CONNECT_OFFSET;
				npt[1].y = npt[0].y + 5 + CONNECT_OFFSET;
				npt[2].x = npt[0].x + 4 + CONNECT_OFFSET;
				npt[2].y = npt[0].y + 5 + CONNECT_OFFSET;
				npt[0].y -= CONNECT_OFFSET;
				rgn.CreatePolygonRgn(npt,3,ALTERNATE);
				if(rgn.PtInRegion(point)) {
					rgn.DeleteObject();
					newpos->x = m_rect.left + hstep*i;
					newpos->y = m_rect.bottom;
					return i;
				}
				rgn.DeleteObject();
#endif
			}
			break;
		case	DIR_LEFT:
			hstep = (m_rect.bottom - m_rect.top) / (m_inport + 1);
			ypos = m_rect.top;
			for(i = 1; i <= m_inport; i++) {
#ifndef TRIANGLE_MODE
				if(abs(m_rect.right-point.x) <= 4) {
					//
					if(abs(ypos+hstep*i-point.y) <= 4) { 
						newpos->x = m_rect.right;
						newpos->y = m_rect.top + hstep*i;
						return i;
					}
				}
#else
				npt[0].x = m_rect.right;
				npt[0].y = m_rect.top + hstep * i;
				npt[1].x = npt[0].x + 5 + CONNECT_OFFSET;
				npt[1].y = npt[0].y - 4 - CONNECT_OFFSET;
				npt[2].x = npt[0].x + 5 + CONNECT_OFFSET;
				npt[2].y = npt[0].y + 4 + CONNECT_OFFSET;
				npt[0].x -= CONNECT_OFFSET;
				rgn.CreatePolygonRgn(npt,3,ALTERNATE);
				if(rgn.PtInRegion(point)) {
					rgn.DeleteObject();
					newpos->x = m_rect.right;
					newpos->y = m_rect.top + hstep*i;
					return i;
				}
				rgn.DeleteObject();
#endif
			}
			break;
		case	DIR_DOWN:
			hstep = (m_rect.right - m_rect.left) / (m_inport + 1);
			ypos = m_rect.left;
			for(i = 1; i <= m_inport; i++) {
#ifndef TRIANGLE_MODE
				if(abs(m_rect.top-point.y) <= 4) {
					//
					if(abs(ypos+hstep*i-point.x) <= 4) {
						newpos->x = m_rect.left + hstep*i;
						newpos->y = m_rect.top;
						return i;
					}
				}
#else
				npt[0].x = m_rect.left + hstep * i;
				npt[0].y = m_rect.top;
				npt[1].x = npt[0].x - 4 - CONNECT_OFFSET;
				npt[1].y = npt[0].y - 5 - CONNECT_OFFSET;
				npt[2].x = npt[0].x + 4 + CONNECT_OFFSET;
				npt[2].y = npt[0].y - 5 - CONNECT_OFFSET;
				npt[0].y += CONNECT_OFFSET;
				rgn.CreatePolygonRgn(npt,3,ALTERNATE);
				if(rgn.PtInRegion(point)) {
					rgn.DeleteObject();
					newpos->x = m_rect.left + hstep*i;
					newpos->y = m_rect.top;
					return i;
				}
				rgn.DeleteObject();
#endif
			}
			break;
		}

		return FALSE;
	//}
}


//////////////////////////////////////////////////////////////////////////
// WidgetɊւ鏈
// 胂ft@Cp[^[
BOOL CWidget::GetModelParam(int type, CString name)
{
	char modulepath[_MAX_PATH], file[_MAX_PATH];
	char linebuf[128];
	BOOL flag;
	char *cptr;
	int	nCount,i,j,nParam,pos;
	CString msgStr;
	char prmname[128];
	PARAMINFO* pItem;
	CString infoStr[256];
	int infoNum;
	FILE *fp;
	CString strTmp,strNum;

	// WƊgiNCSfjŃpXقȂ
	if(type == MODULE_NCS) {
		strcpy(file, name);
	}
	else {
		// ffBNg
		if(GetModuleDirectory(modulepath, _MAX_PATH) == NULL)
			return FALSE;

		// divide
		sprintf(file,"%s\\ncs\\model\\%s",modulepath,name);
		// check
		if(Access(file, SL_FATTR_FOK) != 0)
			strcpy(file, name);

	}

	//Ŏgpp[^[ǂ
	fp = fopen(file, "r");
	flag = FALSE;
	while(!feof(fp)) {
		if(fgets(linebuf, _MAX_PATH, fp) == NULL)
			break;
		cptr = linebuf;
		if(strstr(linebuf, "parameter:")) {
			cptr += strlen("parameter:");
			flag = TRUE;
		}
		if(strstr(linebuf, "function:")) {
			break;
		}
		if(flag) {
			// 1sparameter
			GetModelParamRead(cptr);
		}
	}
	fclose(fp);

	// WƊgiNCSfjŃpXقȂ
	if(type == MODULE_NCS) {
		//gW[̏ꍇ
		nCount = (int)m_paramArray.GetSize();
		for(i = 0; i < nCount; i++) {
			pItem = (PARAMINFO*) m_paramArray.GetAt(i);
			pItem->type = PARAM_EDIT;
			pItem->strInitial = pItem->strValue;
			pItem->strMessage = pItem->strName;
			pItem->max = 100000;
			pItem->min = -100000;
			pItem->step = 0;
		}
	}
	else {
		//p[^[ݒ_CAOŎgp𓯂t@Cǂ
		//̈CStringzɎ擾
		infoNum = g_pExtncsMain->GetModelInfo(file, infoStr);
		nCount = (int)m_paramArray.GetSize();
		//infoNumParameters = ***
		for(i = 0; i < infoNum; i++) {
			pos = infoStr[i].Find(_T("Parameters"));
			if(pos == -1)
				continue;
			strTmp = infoStr[i].Mid(pos+10);
			pos = strTmp.Find(_T("="));
			if(pos == -1)
				continue;
			strNum = strTmp.Mid(pos+1);
			nParam = atoi(strNum);
			// nParamnCount
			if(nParam == nCount)
				break;
		}
		if(i == infoNum) {
			//gꂽ̂ƂăftHg^
			for(i = 0; i < nCount; i++) {
				pItem = (PARAMINFO*) m_paramArray.GetAt(i);
				pItem->type = PARAM_EDIT;
				pItem->strInitial = pItem->strValue;
				pItem->strMessage = pItem->strName;
				pItem->max = 100000;
				pItem->min = -100000;
				pItem->step = 0;
			}
		}
		else {
			for(i = 0; i < infoNum; i++) {
				strcpy(linebuf, infoStr[i]);
				for(j = 0; j < nCount; j++) {
					pItem = (PARAMINFO*) m_paramArray.GetAt(j);
					strcpy(prmname, pItem->strName);
					if(strstr(linebuf, prmname) != NULL) {
						//v񂠂
						GetParamMessage(linebuf, pItem);
						break;
					}
				}
			}
		}
	}

	return TRUE;
}

void CWidget::GetParamMessage(char *line, PARAMINFO *pItem)
{
	int i,count,step;
	double max,min;
	char buf[128],*cptr;
	CString strInit = _T("");
	CString strMsg = _T("");

	cptr = line;
	count = 0;
	while(*cptr != '\0' && *cptr != '\n' ) {
		if(*cptr == ':') {
			count += 1;
			if(count == 1) {
				//:܂œǂ
				cptr++;
				i = 0;
				while(*cptr != '\0' && *cptr != '\n' && *cptr != ':') {
					buf[i++] = *cptr++;
				}
				buf[i] = '\0';
				strInit = _T(buf);
				cptr--;
			}
			else if(count == 2) {
				//Ōォ:܂œǂ
				cptr++;
				i = 0;
				while(*cptr != '\0' && *cptr != '\n' && *cptr != ':') {
					buf[i++] = *cptr++;
				}
				buf[i] = '\0';
				strMsg = _T(buf);
				cptr--;
			}
		}
		cptr++;
	}

	//type
	if(strInit.GetLength()) {
		if(strInit.GetAt(0) == '(')
			pItem->type = PARAM_COMBO;
		else {
			pItem->type = PARAM_EDIT;
			//őEŏEXebvԊu𓾂
			if(GetParamInfo(strInit, &max, &min, &step) == FALSE) {
				max = 10;
				min = -10;
				step = 0;
			}
		}
	}
	pItem->strInitial = strInit;
	pItem->strMessage = strMsg;
	if(pItem->type == PARAM_EDIT) {
		pItem->max = max;
		pItem->min = min;
		pItem->step = step;
	}
}

//p[^[̍őEŏȂǂ߂
BOOL CWidget::GetParamInfo(CString str, double *mx, double *mi, int *st)
{
	if(str.Find('[') == -1)
		return FALSE;
	if(str.Find(']') == -1)
		return FALSE;

	int i,step,index;
	double min,max;
	char buf[128],val[32],*cptr;

	strcpy(buf, str);	
	cptr = buf;
	step = 0; i = 0; index = 0;
	strcpy(val, "");
	while(*cptr != '\0') {
		if(*cptr != '[') {
			if(*cptr == ',' || *cptr == ']') {
				//ݒ
				val[i] = '\0';
				if(index==0)
					min = atof(val);
				else if(index == 1)
					max = atof(val);
				else
					step = atoi(val);
				i=0;
				index++;
				strcpy(val, "");
			}
			else
				val[i++] = *cptr;
		}
		cptr++;
	}

	*mx = max;
	*mi = min;
	*st = step;
	return TRUE;
}

//p[^
//W a=0.1̂
// num=[1 0 1]̂悤ȃxNg`

void CWidget::GetModelParamRead(char *line)
{
	char buf[256],name[32],val[32];
	int	i,addr,flag,nCount,tfrfg,pos;
	PARAMINFO* pItem;
	CString str,strLeft,strRight;

	//"/*""*/"폜
	str = _T(line);
	pos = str.Find(_T("/*"));
	if(pos != -1) {	//Rg
		strLeft = str.Left(pos);
		strRight = str.Mid(pos+2);
		//PsɕK/**/݂
		str = strRight;
		pos = str.Find(_T("*/"));
		strRight = str.Mid(pos+2);
		str = strLeft + strRight;
		strcpy(buf, str);
	}
	else
		strcpy(buf, line);
	i = 0; addr = 0; flag = 0, tfrfg = 0;
	while(buf[i] != '\n') {
		if(buf[i] != ' ' && buf[i] != '\t') {
			if(buf[i] == '[') {
				//[]ŋLqꂽp[^[
				tfrfg = TRUE;
			}
			if(buf[i] == '=') {
				flag = 1;
				name[addr] = '\0';
				addr = 0;
			}
			else {
				if(buf[i] == ',' || buf[i] == ';') {
					//1parameter
					val[addr] = '\0';
					addr = 0; flag = 0, tfrfg = 0;
					//Xgɓo^
					try {
						pItem = new PARAMINFO;
					}
					catch (CMemoryException* e) {
						e->Delete ();
						return;
					}
					//@ݒ
					pItem->strName = _T(name);
					pItem->strValue = _T(val);
					pItem->type = 0;
					pItem->changed = FALSE;		//ύXĂȂ
					//CfbNX
					nCount = (int)m_paramArray.GetSize();
					//o^
					m_paramArray.InsertAt( nCount, pItem );
				}
				else {
					if(flag)
						val[addr++] = buf[i];
					else
						name[addr++] = buf[i];
				}
			}
		}
		else {	//p[^[ɑΉAnum=[1]Ȃ
			if(tfrfg && buf[i] == ' ') {
				val[addr++] = buf[i];
			}
		}

		i++;
	}
}

//////////////////////////////////////////////////////////////////
// 胂ft@CScope

BOOL CWidget::GetModelScope(int type, CString name)
{
	char file[_MAX_PATH],modulepath[_MAX_PATH];
	FILE *fp;
	char line[128];
	char *cptr;
	CString infoStr[256];
	int infoNum,nCount,i,j;
	SCOPEINFO* pItem;
	char scopename[128];
	int fg;

	// WƊgiNCSfjŃpXقȂ
	if(type == MODULE_NCS) {
		//gNCS
		strcpy(file, name);
	}
	else {
		// WW[t@C
		GetModuleDirectory(modulepath, _MAX_PATH);
		// divide
		sprintf(file,"%s\\ncs\\model\\%s",modulepath,name);
		// check
		if(Access(file, SL_FATTR_FOK) != 0)
			strcpy(file, name);
	}

	if((fp = fopen(file, "r")) == NULL)
		return FALSE;
	fg = -1;
	for(;;) {
		if(fgets(line, 128, fp) == NULL)
			break;
		cptr = line;
		if(strstr(line, "exinput:")) {
			cptr += strlen("exinput:");
			//O
			//GetModelScopeItem( cptr, SCOPE_EXINPUT );
			fg = SCOPE_EXINPUT;
		}
//TODO 2003/4
#if 0
		if(strstr(line, "input:")) {
			cptr += strlen("exinput:");
			//O
			//GetModelScopeItem( cptr, SCOPE_EXINPUT );
			fg = SCOPE_INPUT;
		}
#endif
		if(strstr(line, "output:")) {
			cptr += strlen("output:");
			//o
			//GetModelScopeItem( cptr, SCOPE_OUTPUT );
			fg = SCOPE_OUTPUT;
		}
		if(strstr(line, "observable:")) {
			cptr += strlen("observable:");
			//observable
			//GetModelScopeItem( cptr, SCOPE_OBS );
			fg = SCOPE_OBS;
		}
		if(strstr(line, "parameter:")) {
			break;
		}
		if(strstr(line, "function:")) {
			break;
		}
		if(fg != -1) {
			GetModelScopeItem(line, fg);
		}
	}
	fclose(fp);

	// WƊgiNCSfjŃpXقȂ
	if(type == MODULE_NCS) {
		//gW[̏ꍇ́AGetModelScopeItemŊ{ݒ͒`ς
		//TODO:KvȂ
		nCount = (int)m_scopeArray.GetSize();
		for(i = 0; i < nCount; i++) {
			pItem = (SCOPEINFO*) m_scopeArray.GetAt(i);
		}
	}
	else {
		//ft@C菉Scope擾
		//̈CStringzɎ擾
		infoNum = g_pExtncsMain->GetModelInfo(file, infoStr);
		nCount = (int)m_scopeArray.GetSize();
		for(i = 0; i < infoNum; i++) {
			strcpy(line, infoStr[i]);
			for(j = 0; j < nCount; j++) {
				pItem = (SCOPEINFO*) m_scopeArray.GetAt(j);
				strcpy(scopename, pItem->strName);
				strcat(scopename, ":");
				if(strstr(line, scopename) != NULL) {
					//v񂠂
					GetScopeMessage(line, pItem);
					break;
				}
			}
		}
	}

	return TRUE;
}

//
// j^O
void CWidget::GetModelScopeItem(char *line, int type)
{
	char buf[256],name[32];
	int	i,addr,nCount;
	SCOPEINFO* pItem;
	char *cptr;

	if(type == SCOPE_EXINPUT) {
		cptr = strstr(line, "exinput:");
		if(cptr)
			cptr += strlen("exinput:");
		else
			cptr = line;
		strcpy(buf, cptr);
	}
//TODO 2004/3
	else if(type == SCOPE_INPUT) {
		cptr = strstr(line, "input:");
		if(cptr)
			cptr += strlen("input:");
		else
			cptr = line;
		strcpy(buf, cptr);
	}
	else if(type == SCOPE_OUTPUT) {
		cptr = strstr(line, "output:");
		if(cptr)
			cptr += strlen("output:");
		else
			cptr = line;
		strcpy(buf, cptr);
	}
	else if(type == SCOPE_OBS) {
		cptr = strstr(line, "observable:");
		if(cptr)
			cptr += strlen("observable:");
		else
			cptr = line;
		strcpy(buf, cptr);
	}
	i = 0; addr = 0;
	while(buf[i] != '\n') {
		if(buf[i] != ' ' && buf[i] != '\t') {
			if(buf[i] == ',' || buf[i] == ';') {
				//1 Scope
				name[addr] = '\0';
				addr = 0;
				//Xgɓo^
				try {
					pItem = new SCOPEINFO;
				}
				catch (CMemoryException* e) {
					e->Delete ();
					return;
				}
				//@ݒ
				pItem->strName = _T(name);
				pItem->type = type;
				pItem->strVmax = _T("10.0");
				pItem->strVmin = _T("-10.0");
				pItem->strHmax = _T("5.0");
				pItem->strVunit = _T("V");
				pItem->strHunit = _T("sec");
				pItem->strTs = _T("0.0");		//Start
				pItem->strTe = _T("10.0");		//End
				pItem->width = 1;				//
				pItem->strTime = _T("10.0");	//\
				pItem->size = m_row*m_column;	//ϐTCY
				//lFALSE
				if(type == SCOPE_OUTPUT)
					pItem->visible = TRUE;
				else
					pItem->visible = FALSE;
				//Autoscale
				pItem->autoScale = FALSE;
				//gcolor
				pItem->gcolor = RGB(255,0,0);
				//pScopeWnd
				pItem->pScopeWnd = NULL;
				//CfbNX
				nCount = (int)m_scopeArray.GetSize();
				//o^
				m_scopeArray.InsertAt( nCount, pItem );
			}
			else {
				name[addr++] = buf[i];
			}
		}
		i++;
	}
}

// Scope`摮
void CWidget::GetScopeMessage(char *line, SCOPEINFO *pItem)
{
	CString strRight,strLeft;
	CString scopeAttr[5];
	int count = 0, offset, pos;

	strRight = _T(line);
	pos = strRight.Find(_T(":\""));
	strRight = strRight.Mid(pos+2);
	for(;;) {
		pos = strRight.Find(_T("\",\""));
		if(pos == -1) {
			pos = strRight.Find(_T("\""));
			if(pos == -1)
				break;
			else
				offset = 1;
		}
		else
			offset = 3;
		strLeft = strRight.Left(pos);
		strRight = strRight.Mid(pos+offset);
		scopeAttr[count++] = strLeft;
	}

	if(count == 5) {
		//ǂ߂ꍇ
		pItem->strVmax = scopeAttr[0];
		pItem->strVmin = scopeAttr[1];
		pItem->strHmax = scopeAttr[2];
		pItem->strVunit = scopeAttr[3];
		pItem->strHunit = scopeAttr[4];
	}

}

void CWidget::RemoveSubsys()
{
	int nCount,i;
	nCount = (int)m_subsysArray.GetSize();
	if(nCount > 0) {
		for (i=0; i<nCount; i++)
			delete (SUBSYSINFO*) m_subsysArray.GetAt (i);
		m_subsysArray.RemoveAll();
	}
}

void CWidget::RemoveSubsysWidgets()
{
	int nCount,i;
	nCount = (int)m_subsysWidgets.GetSize();
	if(nCount > 0) {
		for (i=0; i<nCount; i++)
			delete (SUBSYSWIDGET*) m_subsysWidgets.GetAt (i);
		m_subsysWidgets.RemoveAll();
	}
}

void CWidget::RemoveSubsysLines()
{
	int nCount,i;
	nCount = (int)m_subsysLines.GetSize();
	if(nCount > 0) {
		for (i=0; i<nCount; i++)
			delete (SUBSYSLINE*) m_subsysLines.GetAt (i);
		m_subsysLines.RemoveAll();
	}
}

CPoint CWidget::GetWidgetCenter(CPoint point)
{
	int	i,j,xstep,ystep,xs,ys;
	CPoint pt;
	CSize size;
	CRect rect;

	xstep = m_rect.Width() / m_column;
	ystep = m_rect.Height() / m_row;
	size = CSize(xstep, ystep);
	ys = m_rect.top;
	for(i = 0; i < m_row; i++) {
		xs = m_rect.left;
		for(j = 0; j < m_column; j++) {
			pt = CPoint(xs, ys);
			rect = CRect(pt, size);
			if(rect.PtInRect(point))
				return CPoint(xs+xstep/2, ys+ystep/2);
			xs += xstep;
		}
		ys += ystep;
	}
	return CPoint(0,0);
}

//
// CExtncsViewScopeSetĂ΂
// CWidgetɊ֌WĂXy̏ݒ
//
void CWidget::XySet(double simtime, double simstep, int cycle)
{
	int nCount,i,size=0,scope = -1;
	SCOPEINFO* pItem;
	CXyWnd* pXyWnd;

	nCount = (int)m_scopeArray.GetSize();
	if(nCount > 0) {
		for (i=0; i<nCount; i++) {
			pItem = (SCOPEINFO*)m_scopeArray.GetAt (i);
			if(pItem->visible) {
				//֌WĂXY
				size += pItem->size;
				if(scope == -1)
					scope = i;
			}
		}
		if(size > 0) {
			pXyWnd = (CXyWnd*)m_pScopeFrame;
			pXyWnd->ScopeSet(scope, simtime, simstep, cycle, size);
		}
	}
}

//
// CExtncsViewScopeSetĂ΂
// CWidgetɊ֌WĂScopeɃf[^]
// index:m_scopeArraỹCfbNX
//
void CWidget::XyUpdate(int cycle, int index, int size, float* data)
{
	CXyWnd* pXyWnd;

	pXyWnd = (CXyWnd*)m_pScopeFrame;
	pXyWnd->ScopeUpdate(cycle, index, size, data);
}

//
// CWidgetɊ֌WĂScopȅݒ
//
void CWidget::ScopeSet(double simtime, double simstep, int cycle)
{
	int nCount,i;
	SCOPEINFO* pItem;
	CScopeWnd* pScopeWnd;

	nCount = (int)m_scopeArray.GetSize();
	if(nCount > 0) {
		for (i=0; i<nCount; i++) {
			pItem = (SCOPEINFO*)m_scopeArray.GetAt (i);
			if(pItem->visible) {
				//֌WĂScope
				pScopeWnd = (CScopeWnd*)pItem->pScopeWnd;
				pScopeWnd->ScopeSet(i, simtime, simstep, cycle, pItem->size);
			}
		}
	}
}

//
// CWidgetɊ֌WĂScopeɃf[^]
// index:m_scopeArraỹCfbNX
//
void CWidget::ScopeUpdate(int cycle, int index, int size, float* data)
{
	SCOPEINFO* pItem;
	CScopeWnd* pScopeWnd;

	pItem = (SCOPEINFO*)m_scopeArray.GetAt (index);
	pScopeWnd = (CScopeWnd*)pItem->pScopeWnd;
	pScopeWnd->ScopeUpdate(cycle, index, size, data);
}

//
// XyW[ScopeXV
// observabléATRUE
// type=0	x-y
// type=1	x-y-z
//
void CWidget::ChangeXyScope()
{
	int i,nCount,type;
	SCOPEINFO* pItem;
	PARAMINFO* prmItem;
	char name[16];
	CString str;

	//PARAMINFO
	nCount = m_paramArray.GetSize();
	if(nCount == 0)
		return;
	prmItem = (PARAMINFO*)m_paramArray.GetAt (0);
	str = prmItem->strValue;
	type = atoi(str);

	//SCOPE_OBSx폜
	nCount = (int)m_scopeArray.GetSize();
	if(nCount > 0) {
		for (i=nCount-1; i>=0 ; i--) {
			pItem = (SCOPEINFO*)m_scopeArray.GetAt (i);
			if(pItem->type == SCOPE_OBS) {
				delete (SCOPEINFO*) m_scopeArray.GetAt (i);
				m_scopeArray.RemoveAt( i, 1 );
			}
			else
				pItem->visible = FALSE;
		}
	}
	//SCOPE_OBSo^
	for(i = 0; i < type+2; i++) {
		//Xgɓo^
		try {
			pItem = new SCOPEINFO;
		}
		catch (CMemoryException* e) {
			e->Delete ();
			return;
		}
		//@ݒ
		switch(i) {
			case 0:
				pItem->strName = _T("x");
				break;
			case 1:
				pItem->strName = _T("y");
				break;
			case 2:
				pItem->strName = _T("z");
				break;
			default:
				pItem->strName = _T("none");
		}
		pItem->type = SCOPE_OBS;
		pItem->strVmax = _T("10.0");
		pItem->strVmin = _T("-10.0");
		pItem->strHmax = _T("5.0");
		pItem->strVunit = _T("V");
		pItem->strHunit = _T("sec");
		pItem->strTs = _T("0.0");		//Start
		pItem->strTe = _T("10.0");		//End
		pItem->width = 1;				//
		pItem->strTime = _T("10.0");	//\
		pItem->size = m_row*m_column;	//ϐTCY
		//SCOPE_OBS̏ꍇ́AlTRUE
		pItem->visible = TRUE;
		//Autoscale
		pItem->autoScale = FALSE;
		//gcolor
		pItem->gcolor = RGB(255,0,0);
		//pScopeWnd
		pItem->pScopeWnd = NULL;
		//CfbNX
		nCount = (int)m_scopeArray.GetSize();
		//o^
		m_scopeArray.InsertAt( nCount, pItem );
	}
}

void CWidget::ChangeScopeInfo(CWidget* pWidget, CWnd* pWnd, CPtrArray* p)
{
	SCOPEINFO* pItem;
	SCOPEINFO* sItem;
	CPtrArray*	pScopeArray;
	int	i,nScope;
	CScopeWnd* pScopeWnd;
	CXyWnd* pXyWnd;

	// WidgetScopeWndݒ
	m_pScopeFrame = pWnd;
	// WidgetScopeJĂ΁AWidgeto^
	if(pWnd) {
		if(m_id == M_XY)
			((CXyWnd*)pWnd)->m_pWidget = pWidget;
		else
			((CScopeFrame*)pWnd)->m_pWidget = pWidget;
	}
	// WidgetScope|C^[
	pScopeArray = &m_scopeArray;
	// o^Scope
	nScope = (int)p->GetSize();
	for(i = 0; i < nScope; i++) {
		// o^
		sItem = (SCOPEINFO*) p->GetAt(i);
		pItem = (SCOPEINFO*) pScopeArray->GetAt(i);
		//Rs[
		pItem->pScopeWnd = sItem->pScopeWnd;
		if(pItem->pScopeWnd) {
			if(pWidget->GetId() == M_XY) {
				pXyWnd = (CXyWnd*)pItem->pScopeWnd;
				pXyWnd->m_pWidget = pWidget;
			}
			else {
				pScopeWnd = (CScopeWnd*)pItem->pScopeWnd;
				pScopeWnd->m_pWidget = pWidget;
			}
		}
	}
}

