/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: WidgetExtend.h,v 1.2 2004/05/19 04:11:21 yoshihiko Exp $ */

#if !defined(AFX_WIDGETEXTEND_H__9DCA0012_3B82_4CDB_85DC_150686D1F02C__INCLUDED_)
#define AFX_WIDGETEXTEND_H__9DCA0012_3B82_4CDB_85DC_150686D1F02C__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "WidgetObj.h"
typedef CTypedPtrArray<CObArray, CWidget*> CWidgetArray;

/////////////////////////////////////////////////////////////////////////////
// CWidgetExtend _CAO

class CWidgetExtend : public CDialog
{
protected:
	CLineStyle m_style;
// RXgNV
public:
	//CWidgetExtend(CWnd* pParent = NULL);	// W̃RXgN^
	CWidgetExtend();
	~CWidgetExtend();
	BOOL	Create(CView* pView);						// _CAO{bNX̍쐬

// _CAO f[^
	//{{AFX_DATA(CWidgetExtend)
	enum { IDD = IDD_WIDGET_EXTEND };
	CEdit	m_format;
	CEdit	m_name;
	CStatic	m_junc;
	//}}AFX_DATA

// f[^
	CString	m_matrix;
	CString m_cell;			//Z
	int	m_connect;			//X^C
	int	m_id;				//JunctionID
	CExtncsDoc* m_pDoc;
	CImageList*	m_pDragImage;
	CPtrArray	m_paramArray;	//p[^[EBhEǗ
	CView* m_pView;
	BOOL m_bFormat;			//g͗LtO

protected:
	CWidgetArray m_arrWidgets;

public:
	BOOL CheckStateFormat();
	int AddWidget(CPoint point, int id, int cx, int cy);
	void OpenParam(CWidget* pWidget, CPoint point);

// I[o[Ch
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂B
	//{{AFX_VIRTUAL(CWidgetExtend)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV T|[g
	//}}AFX_VIRTUAL

// Cve[V
protected:

	// ꂽbZ[W }bv֐
	//{{AFX_MSG(CWidgetExtend)
	virtual BOOL OnInitDialog();
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnPaint();
	afx_msg void OnChangeWidgetFormat();
	virtual void OnCancel();
	virtual void OnOK();
	afx_msg void OnDestroy();
	//}}AFX_MSG
	afx_msg LRESULT OnDeleteParam(WPARAM wParam, LPARAM lParam);
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ ͑Os̒Oɒǉ̐錾}܂B

#endif // !defined(AFX_WIDGETEXTEND_H__9DCA0012_3B82_4CDB_85DC_150686D1F02C__INCLUDED_)
