/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: SyncThread.cpp,v 1.5 2004/09/01 07:38:35 yoshihiko Exp $ */

#include "stdafx.h"
#include "Extncs.h"

#include "ExtncsDoc.h"
#include "ExtncsView.h"
#include <vfw.h>

#define		START_EVENT_NAME	"rt_start_event"
#define		WAIT_EVENT_NAME		"rt_wait_event"
#define		MAP_SIZE			256
#define		MAPPING_NAME		"rt-ncs"

void BlockGraphBitmap(HDC hDCMem, int xp, int yp, int cx, int cy, int blknum, char* bmpfile);
void InitviewOpen();
void InitviewClose();
BOOL InitviewRead(LPCTSTR lpszPathName); 
void InitviewDraw(HDC hDCMem, CRect rect);
BYTE* GetBitmapBits();
void* LoadBitmapFile(CFile &file);
HGLOBAL GetBitmap();
BOOL	simu_exit;		//~tO

void __cdecl SyncThread(CExtncsView* pView)
{
	char msg[_MAX_PATH];
	CExtncsDoc *pDoc = pView->GetDocument();
	int mapSize;
	mapSize = (pView->m_nMoniMax+3) * 4 + MAP_SIZE;

	HANDLE hStartEvent = CreateEvent(0, TRUE, FALSE, START_EVENT_NAME);
	if(hStartEvent == NULL) {
		sprintf(msg,"ERROR: CreateEvent start error. %d", GetLastError());
		MessageBox(NULL,msg,"Extncs",MB_OK);
		return;
	}
	HANDLE hWaitEvent = CreateEvent(0, TRUE, FALSE, WAIT_EVENT_NAME);
	if(hWaitEvent == NULL) {
		sprintf(msg,"ERROR: CreateEvent wait error. %d", GetLastError());
		MessageBox(NULL,msg,"Extncs",MB_OK);
		return;
	}

	HANDLE hMapFile = CreateFileMapping(INVALID_HANDLE_VALUE /*(HANDLE)0xFFFFFFFF*/,NULL,
		PAGE_READWRITE, 0, mapSize/*MAP_SIZE*/,MAPPING_NAME);
	if(hMapFile == NULL) {
		sprintf(msg,"ERROR: CreateFileMapping error. %d", GetLastError());
		MessageBox(NULL,msg,"Extncs",MB_OK);
		return;
	}

	void *MapPointer = MapViewOfFile(hMapFile, FILE_MAP_ALL_ACCESS,
		0, 0, mapSize/*MAP_SIZE*/);
	if(MapPointer == NULL) {
		sprintf(msg,"ERROR: MapViewOfFile error. %d", GetLastError());
		MessageBox(NULL,msg,"Extncs",MB_OK);
		return;
	}

	//"-1"R[h܂Ŏs
	int *dataptr;
	int index;
	float data[100];
	int	moninum, moni;
	long calc;
	long datalen = long(atof(pDoc->m_strTime) / atof(pDoc->m_strSave));
	BOOL	simu_busy;
	//BOOL	simu_exit;		//~tO
	char	buf[128];

	//p[^[̐ݒ́AύXȂɂĂ
	//s

	//j^[Ă鐔
	pView->Print("----------------------------------------");
	pView->ScopeMode(0);
	moninum = pView->m_nMoniMax;

	simu_exit = FALSE;
	dataptr = (int *)MapPointer;
	*dataptr = simu_exit;
	dataptr++;	//Pi߂ăf[^̈
	*dataptr = 0;
	//҂
	WaitForSingleObject(hWaitEvent, INFINITE);
	ResetEvent(hWaitEvent);
	pView->Print("Simulation start .....");
	simu_busy = TRUE;
	pView->ScopeMode(1);
	for(calc=0;;calc++) {
		//X^[g
		SetEvent(hStartEvent);
		//vZI҂
		WaitForSingleObject(hWaitEvent, INFINITE);
		ResetEvent(hWaitEvent);

		//
		dataptr = (int *)MapPointer;
		*dataptr = simu_exit;		//ItO
		dataptr++;					//f[^̈
		if(*dataptr == -1) {
			break;
		}
		if(*dataptr == 1) {
			//f[^̈ǂݏo
			dataptr++;
			index = *dataptr;
			dataptr++;
			//vZCfbNX
			sprintf(buf,"index -> %d", index);
			//pView->Print(buf);
			for(moni = 0; moni < moninum; moni++) {
				data[moni] = *((float *)dataptr);
				dataptr++;
//sprintf(buf,"data[%d] -> %f",moni,data[moni]);
//pView->Print(buf);
			}
			//j^[XV̂߁AExtncsViewɒʒm
			pView->ScopeUpdate( index, data );

			//p[^̈揑
			dataptr = (int *)MapPointer;
			dataptr += (pView->m_nMoniMax+3);	//
			*dataptr++ = 0;
#if 0
			*prmptr++ = nsim_param.param_num;
			for(i = 0; i < nsim_param.param_num; i++) {
				*prmptr = nsim_param.param[i].modified;
				prmptr++;
				*((float *)prmptr) = nsim_param.param[i].fval;
				prmptr++;
				//ύXp[^́ACς݂Ƃ
				//nsim_param.param[i].modified = FALSE;
			}
#endif
			//TODO:check (datalen+1)
			if(index == (datalen+1))
				break;
		}
	}
	pView->Print("Simulation finished.");
	UnmapViewOfFile(MapPointer);
	CloseHandle(hMapFile);
	pView->ScopeMode(2);
	simu_busy = FALSE;
	pView->m_fSimuState = FALSE;
}

//NXȂ
static	void *m_BitmapBlock;
static HDRAWDIB m_drawDIBBlock;

void BlockGraphBitmap(HDC hDCMem, int xp, int yp, int cx, int cy, int blknum, char* bmpfile)
{
	InitviewOpen();
	InitviewRead(bmpfile);
	CRect blockRect(xp, yp, cx, cy);
	InitviewDraw(hDCMem, blockRect );
	InitviewClose();
}

void InitviewOpen()
{
	// DrawDib APĨI[v
	m_BitmapBlock = NULL;
	m_drawDIBBlock = DrawDibOpen();
}

void InitviewClose()
{
	// DrawDib APĨN[Y
	if (m_drawDIBBlock)
		DrawDibClose(m_drawDIBBlock);
	if (m_BitmapBlock) {
		delete m_BitmapBlock;
		m_BitmapBlock = NULL;
	}
}

BOOL InitviewRead(LPCTSTR lpszPathName) 
{

	// t@C̃I[v
	char msgbuf[_MAX_PATH];
	CFile file;
	if (file.Open(lpszPathName, CFile::modeRead | CFile::shareDenyWrite) == FALSE) {
		sprintf(msgbuf, "%s̃I[vɎs܂", lpszPathName);
		AfxMessageBox(msgbuf, MB_OK, NULL);
		//AfxMessageBox(_T("t@C̃I[vɎs܂"));
		return FALSE;
	}

	// t@C̓ǂݍ
	if (m_BitmapBlock) {
		delete m_BitmapBlock;
		m_BitmapBlock = NULL;
	}
	m_BitmapBlock = LoadBitmapFile(file);

	file.Close();

	return TRUE;
}

void InitviewDraw(HDC hDCMem, CRect rect)
{

	// rbg}bv̎擾
	BITMAPINFOHEADER* bitmap = (BITMAPINFOHEADER*)GetBitmap();

	if (bitmap) {
		// Չc
		int	c_width,c_height;
		c_width = rect.right - rect.left;
		c_height = rect.bottom - rect.top;
		// rbg}bv̍ƕ
		int width, height;
		width = bitmap->biWidth,
		height = bitmap->biHeight;
		UINT uRet;
		BOOL bRet;

		// ݂̂cb̃pbgI
		uRet = DrawDibRealize( m_drawDIBBlock, hDCMem, TRUE);

		// rbg}bv̕`
		bRet = DrawDibDraw(m_drawDIBBlock, hDCMem,
					rect.left, rect.top, c_width, c_height,	// `
					bitmap, (LPVOID) GetBitmapBits(),	// rbg}bv
					0, 0, width, height,					// `挳
					DDF_BACKGROUNDPAL);
	}
}

BYTE* GetBitmapBits()
{
	DWORD numOfColors;
	BITMAPINFOHEADER *pBitmap = (BITMAPINFOHEADER*)GetBitmap();
	WORD bitCount = pBitmap->biBitCount;

	if (pBitmap->biSize >= 36)
		numOfColors = pBitmap->biClrUsed;
	else
		numOfColors = 0;

	if (numOfColors == 0 && bitCount != 24) 
			numOfColors = 1L << bitCount;

	return (BYTE*)pBitmap + pBitmap->biSize + numOfColors * sizeof(RGBQUAD);
}

#define BMP_HEADER_ID       (*((WORD*)"BM"))
#define BMP_HEADER_SIZE		sizeof(BITMAPFILEHEADER)

void* LoadBitmapFile(CFile &file)
{
	BITMAPFILEHEADER bmpHeader;
	unsigned long fileSize, leftSize;
	void *bitmap;

	// t@C̒
	fileSize = (unsigned long)file.GetLength();

	// rbg}bvwb_[̎擾
	if (file.Read((LPSTR)&bmpHeader, BMP_HEADER_SIZE) != BMP_HEADER_SIZE)
		return NULL;

	// rbg}bvt@Cł邱Ƃ̊mFibfType=="BM" ?j
	if (bmpHeader.bfType != BMP_HEADER_ID) {
		AfxMessageBox(_T("BITMAPł͂܂"));
		return NULL;
	}

	// [hp̊m
	bitmap = (void*)new char[fileSize];

	// rbg}bv̓ǂݍ
	leftSize = fileSize - BMP_HEADER_SIZE;
	if (file.Read(bitmap, leftSize) != leftSize) {
		delete bitmap;
		return NULL;
	}

	return bitmap;
}

HGLOBAL GetBitmap()
{
	return m_BitmapBlock;
}
