/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: SubsysWnd.cpp,v 1.4 2004/07/11 03:37:46 yoshihiko Exp $ */

#include "stdafx.h"
#include "Extncs.h"

#include "WidgetObj.h"
#include "SubsysWnd.h"
#include "SubsysDoc.h"
#include ".\subsyswnd.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSubsysWnd

IMPLEMENT_DYNCREATE(CSubsysWnd, CFrameWnd)

CSubsysWnd::CSubsysWnd()
{
}

CSubsysWnd::~CSubsysWnd()
{
}


BEGIN_MESSAGE_MAP(CSubsysWnd, CFrameWnd)
	//{{AFX_MSG_MAP(CSubsysWnd)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
	ON_WM_HELPINFO()
	// O[o wv R}h
	ON_COMMAND(ID_HELP_FINDER, CFrameWnd::OnHelpFinder)
	ON_COMMAND(ID_HELP, CFrameWnd::OnHelp)
	ON_COMMAND(ID_CONTEXT_HELP, CFrameWnd::OnContextHelp)
	ON_COMMAND(ID_DEFAULT_HELP, CFrameWnd::OnHelpFinder)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSubsysWnd bZ[W nh

BOOL CSubsysWnd::PreCreateWindow(CREATESTRUCT& cs) 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	cs.style &= ~FWS_ADDTOTITLE;
	//ʒuƃTCY
	//cs.x = 0;
	//cs.y = 0;
	cs.cx = 480;
	cs.cy = 320;
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	return TRUE;
}

int CSubsysWnd::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	if (!m_wndExtncsBar.Create(this, WS_CHILD | WS_VISIBLE | CBRS_SIZE_FIXED |
		CBRS_TOP | CBRS_TOOLTIPS, AFX_IDW_TOOLBAR ) ||
		!m_wndExtncsBar.LoadToolBar(IDR_TOOLBAR_EXTNCS))
	{
		TRACE0("Failed to create toolbar\n");
		return FALSE;       // 쐬Ɏs
	}

	// ACR\[X[h
	HICON hIcon = AfxGetApp()->LoadIcon(IDI_EXTNCS);
	ASSERT(hIcon);
	// EBhEɐVACRw肷
	this->SendMessage(WM_SETICON, TRUE, (LPARAM)hIcon);
	
	// ^Cg
	char title[_MAX_PATH];
	sprintf(title, "Subsystem : %s", m_pWidget->GetName());
	this->SendMessage(WM_SETTEXT,0,(LPARAM)title);
	
	return 0;
}

BOOL CSubsysWnd::OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext) 
{
	//֘AtꂽCSubsysDoc擾
	CSubsysDoc* pDoc = (CSubsysDoc *)pContext->m_pCurrentDoc;
	m_pWidget = pDoc->m_pWidget;
	m_pExtncsView = pDoc->m_pExtncsView;
	
	return CFrameWnd::OnCreateClient(lpcs, pContext);
}

BOOL CSubsysWnd::OnHelpInfo(HELPINFO* pHelpInfo)
{
	// TODO : ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	//return CFrameWnd::OnHelpInfo(pHelpInfo);
	return TRUE;
}
