/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: SubsysView.h,v 1.4 2004/09/02 11:11:44 yoshihiko Exp $ */

#if !defined(AFX_SUBSYSVIEW_H__97FDC601_1034_445D_9B85_5C08BD5D66CF__INCLUDED_)
#define AFX_SUBSYSVIEW_H__97FDC601_1034_445D_9B85_5C08BD5D66CF__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/////////////////////////////////////////////////////////////////////////////
// CSubsysView r[

class CSubsysView : public CScrollView
{
protected:
	CSubsysView();           // IɎgpveNg RXgN^B
	DECLARE_DYNCREATE(CSubsysView)

// Agr[g
public:

// Iy[V
public:
	void WidgetExtend(int desIndex);
	void CopySubsystem(CWidget* pTargetWidget, CPtrArray* pSrcWidget);
	void NewSubsystem(int inport, int outport);
	void ChangeName(char* name);
	// method
	void CheckConnect(CDC* pDC, CPoint pos);
	void InvertLine(CDC *pDC, POINT from, POINT to);
	void InvertRect(CDC *pDC, POINT from, POINT to);
	void OpenParam(CWidget* pWidget, CPoint point);
	void OpenSubsystem(CWidget* pWidget, CPoint point);
	void CopyParam(CWidget* pWidget, CPtrArray* p);
	BOOL AreaInWidgets(POINT from, POINT to);
	BOOL IntersectLine(CRect rect, CPoint from, CPoint to);
	void SaveWidgetLine(int widget);
	void LoadWidgetLine(int widget, int index);
	int CheckIntersectWidget(CPoint point);
	void JuncWidgetDelete();
	CSubsysDoc* GetDocument();

	//data
	CPoint		m_connectPoint[3];
	CDialog* m_pLineProp;
	CDialog* m_pWidgetExtend;
	CImageList*	m_pDragImage;
	CPtrArray	m_paramArray;	//p[^[EBhEǗ
//TODO:ϐ
	//CScopeDoc	*m_pScopeDoc[MAX_SCOPE];	//ScopeǗ
	//CScopeWnd	*m_pScopeWnd[MAX_SCOPE];
	CDocument	*m_pScopeDoc[MAX_SCOPE];	//ScopeǗ
	CWnd	*m_pScopeWnd[MAX_SCOPE];
	int			m_nScopeMax;
	int			m_nScopeIndex;
	int			m_nMoniMax;
//TODO:ϐ
	//CSubsysDoc	*m_pSubsysDoc[MAX_SUBSYSTEM];
	//CSubsysWnd	*m_pSubsysWnd[MAX_SUBSYSTEM];
	CDocument	*m_pSubsysDoc[MAX_SUBSYSTEM];
	CWnd	*m_pSubsysWnd[MAX_SUBSYSTEM];
	int			m_nSubsysMax;

// I[o[Ch
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂B
	//{{AFX_VIRTUAL(CSubsysView)
	public:
	virtual DROPEFFECT OnDragEnter(COleDataObject* pDataObject, DWORD dwKeyState, CPoint point);
	virtual DROPEFFECT OnDragOver(COleDataObject* pDataObject, DWORD dwKeyState, CPoint point);
	virtual void OnDragLeave();
	virtual BOOL OnDrop(COleDataObject* pDataObject, DROPEFFECT dropEffect, CPoint point);
	protected:
	virtual void OnDraw(CDC* pDC);      // ̃r[`悷邽߂ɃI[o[Ch܂B
	virtual void OnInitialUpdate();     // \zAŏ̏B
	virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
	//}}AFX_VIRTUAL

// Cve[V
protected:
	virtual ~CSubsysView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif
	CWidget* m_pTempWidget;
	CLine* m_pTempLine;
	CSize	m_offset;
	CPoint	m_pointLastImage;
	CPoint	m_pointLastMsg;
	int		m_nSel;
	COleDropTarget m_oleDropTarget;
	HCURSOR m_hCross;
	HCURSOR m_hArrow;
	HCURSOR m_hRSize;
	HCURSOR m_hLSize;
	int		m_srcIndex,m_desIndex;
	BOOL	m_bHitRLine, m_bHitLLine;
	BOOL	m_bLineMode;
	CPoint	m_ptFrom, m_ptTo;
	int		m_nWidgetRLine, m_nWidgetLLine;
	int		m_inIndex, m_outIndex;		//|[gԍ
	int		m_lSel;		//CI̎wW
	BOOL	m_bCtrlKey;		//CtrlL[
	int		m_nSizePoint;	//Resizë
	BOOL	m_bSizeMode;	//Resize
	CPoint	m_popupPos;		//}EXENbNʒu
	CPtrArray m_mouseArray;	//MOUSE_MOVËʒu
	int		m_lSelIndex;	//CfbNX̃AhX
	BOOL	m_bAreaMode;
	CPtrArray m_moveArray;

	// ꂽbZ[W }bv֐
	//{{AFX_MSG(CSubsysView)
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnEditCut();
	afx_msg void OnUpdateEditCut(CCmdUI* pCmdUI);
	afx_msg void OnEditCopy();
	afx_msg void OnUpdateEditCopy(CCmdUI* pCmdUI);
	afx_msg void OnEditPaste();
	afx_msg void OnUpdateEditPaste(CCmdUI* pCmdUI);
	afx_msg void OnEditDelete();
	afx_msg void OnUpdateEditDelete(CCmdUI* pCmdUI);
	afx_msg void OnLineProp();
	afx_msg void OnUpdateLineProp(CCmdUI* pCmdUI);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnWidgetLine();
	afx_msg void OnUpdateWidgetLine(CCmdUI* pCmdUI);
	afx_msg void OnWidgetParam();
	afx_msg void OnUpdateWidgetParam(CCmdUI* pCmdUI);
	afx_msg void OnWidgetScope();
	afx_msg void OnUpdateWidgetScope(CCmdUI* pCmdUI);
	afx_msg void OnWidget0();
	afx_msg void OnUpdateWidget0(CCmdUI* pCmdUI);
	afx_msg void OnWidget90();
	afx_msg void OnUpdateWidget90(CCmdUI* pCmdUI);
	afx_msg void OnWidget180();
	afx_msg void OnUpdateWidget180(CCmdUI* pCmdUI);
	afx_msg void OnWidget270();
	afx_msg void OnUpdateWidget270(CCmdUI* pCmdUI);
	afx_msg void OnWidgetExtend();
	afx_msg void OnUpdateWidgetExtend(CCmdUI* pCmdUI);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnDestroy();
	afx_msg void OnAppExit();
	//}}AFX_MSG
	afx_msg LRESULT OnParamChange(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnDeleteExtend(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnDeleteLineprop(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnDeleteParam(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnDeleteScopeFrame(WPARAM wParam, LPARAM lParam);
	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnExtncsStart();
	afx_msg void OnUpdateExtncsStart(CCmdUI *pCmdUI);
	afx_msg void OnExtncsStop();
	afx_msg void OnUpdateExtncsStop(CCmdUI *pCmdUI);
	afx_msg void OnExtncsCondition();
	afx_msg void OnUpdateExtncsCondition(CCmdUI *pCmdUI);
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ ͑Os̒Oɒǉ̐錾}܂B

#endif // !defined(AFX_SUBSYSVIEW_H__97FDC601_1034_445D_9B85_5C08BD5D66CF__INCLUDED_)
