/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: ScopeView.h,v 1.2 2004/05/19 04:11:21 yoshihiko Exp $ */

#if !defined(AFX_SCOPEVIEW_H__0F9C4B07_1D81_4299_874F_6C5339022BCF__INCLUDED_)
#define AFX_SCOPEVIEW_H__0F9C4B07_1D81_4299_874F_6C5339022BCF__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/////////////////////////////////////////////////////////////////////////////
// CScopeView r[

class CScopeView : public CScrollView
{
protected:
	CScopeView();           // IɎgpveNg RXgN^B
	DECLARE_DYNCREATE(CScopeView)

// Agr[g
public:

// Iy[V
public:
	//method
	void	DrawInit(CDC* pDC, SCOPEINFO* pItem);
	void	DrawScope(CDC* pDC, SCOPEINFO* pItem);
	void	DrawData(CDC* pDC, int size, SCOPEINFO* pItem);
	void	InvertLine(CDC *pDC, POINT from, POINT to);
	void	UpdateData(int cycle, int scope, int size, float* data);
	void	SetUpdateMode(int mode);
	void	SetTitle(CDC *pDC, SCOPEINFO *pItem);
	void	SetUnits(CDC *pDC, SCOPEINFO *pItem);
	void	SetAutoscale();
	void	SetData();
	void	UpdateInit(int scope, double simtime, double simstep, int cycle, int width);
	void	SetSimuParam(double simtime, double simstep);
	void	SetAxis();

	//data
	CWnd*	m_pParentWnd;
	int		m_xs[MONI_SIZE];		//ݒl
	int		m_ys[MONI_SIZE];
	int		m_xInit;				//_
	int		m_yInit;
	int		m_height;
	int		m_width;
	double	m_ymax;
	double	m_ymin;
	int		m_updateMode;
	int		m_targetScope;		//ݒ肵悤ƂĂScope
	int		m_scaleMode;		//WAUTO
	BOOL	m_overlayMode;		//I[o[C
	//f[^obt@֌W
	int		m_index;
	double	m_simtime;
	double	m_simstep;
	int		m_nCycle;
	int		m_nSize;
	double*	m_data;
	CFont	m_font;
	int		m_nStart;			//\JnCfbNX
	int		m_nLength;			//\_
	int		m_nWidth;			//ScopeǗf[^
	int		m_hitScope;			//IꂽScope

// I[o[Ch
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂B
	//{{AFX_VIRTUAL(CScopeView)
	protected:
	virtual void OnDraw(CDC* pDC);      // ̃r[`悷邽߂ɃI[o[Ch܂B
	virtual void OnInitialUpdate();     // \zAŏ̏B
	virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
	//}}AFX_VIRTUAL

// Cve[V
protected:
	virtual ~CScopeView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// ꂽbZ[W }bv֐
	//{{AFX_MSG(CScopeView)
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnScopeAttr();
	afx_msg void OnUpdateScopeAttr(CCmdUI* pCmdUI);
	afx_msg void OnScopeAutoscale();
	afx_msg void OnUpdateScopeAutoscale(CCmdUI* pCmdUI);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnDestroy();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ ͑Os̒Oɒǉ̐錾}܂B

#endif // !defined(AFX_SCOPEVIEW_H__0F9C4B07_1D81_4299_874F_6C5339022BCF__INCLUDED_)
