/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: ScopeView.cpp,v 1.5 2004/09/02 11:11:44 yoshihiko Exp $ */

#include "stdafx.h"
#include "Extncs.h"
#include "shell/satellite4.h"		//TODO:syscomQƂ̂

#include "WidgetObj.h"
#include "ScopeWnd.h"
#include "ScopeView.h"
#include "ExtncsDoc.h"
#include "ScopePage.h"
#include "ScopeSheet.h"

using namespace std;
#define printf          syscom->console->tty_printf

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//`
#define	SCOPE_WIDTH		320
#define	SCOPE_HEIGHT	200
//ScopeAbvf[g
#define	ALL_UPDATE		0
#define	DATA_UPDATE		1
#define DATA_COMPLETE	2
//ScopeXP[
#define	SCALE_NORMAL		0
#define	SCALE_AUTO			1

/////////////////////////////////////////////////////////////////////////////
// CScopeView

IMPLEMENT_DYNCREATE(CScopeView, CScrollView)

CScopeView::CScopeView()
{
	m_updateMode = ALL_UPDATE;
	m_targetScope = -1;
	m_scaleMode = SCALE_NORMAL;
	m_overlayMode = FALSE;
	m_hitScope = -1;

	//f[^obt@[
	m_nCycle = 0;
	m_nSize = 1;
	m_data = NULL;
}

CScopeView::~CScopeView()
{
}


BEGIN_MESSAGE_MAP(CScopeView, CScrollView)
	//{{AFX_MSG_MAP(CScopeView)
	ON_WM_RBUTTONDOWN()
	ON_COMMAND(ID_SCOPE_ATTR, OnScopeAttr)
	ON_UPDATE_COMMAND_UI(ID_SCOPE_ATTR, OnUpdateScopeAttr)
	ON_COMMAND(ID_SCOPE_AUTOSCALE, OnScopeAutoscale)
	ON_UPDATE_COMMAND_UI(ID_SCOPE_AUTOSCALE, OnUpdateScopeAutoscale)
	ON_WM_CREATE()
	ON_WM_ERASEBKGND()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CScopeView `

void CScopeView::OnInitialUpdate()
{
	CScrollView::OnInitialUpdate();

	CSize sizeTotal;
	// TODO: ̃r[Ŝ̃TCYvZĂB
	sizeTotal.cx = sizeTotal.cy = 100;
	SetScrollSizes(MM_TEXT, sizeTotal);
	//Ԏp[^[ݒ肵Ă
	m_nStart = 0;
	m_nLength = 0;
}

void CScopeView::OnDraw(CDC* pDC)
{
	CScopeWnd* pScopeWnd = (CScopeWnd*)(m_pParentWnd/*this->GetParent()*/);
	CWidget *pWidget;
	CPtrArray*	p;
	SCOPEINFO *pItem;

	//\Widget̕ϐ
	pWidget = pScopeWnd->m_pWidget;
	p = pWidget->GetScopePointer();
	pItem = (SCOPEINFO*) p->GetAt (pScopeWnd->m_nVarIndex);
	//`
	DrawScope(pDC, pItem);
}

//
//	Scopeg`
void CScopeView::DrawInit(CDC* pDC, SCOPEINFO* pItem)
{
	int		i,x,y,xs,ys,xe,ye,ym,step;
	CPoint	from,to;
	CPen	lineColor(PS_SOLID, 1, RGB(0, 0, 0));
	CPen	dataColor(PS_SOLID, pItem->width, pItem->gcolor/*RGB(255, 0, 0)*/);
	COLORREF	textColor;
	textColor = RGB(0, 0, 0);
	CPen*	pOldPen;
	pOldPen = pDC->SelectObject(&lineColor);
	CRect	rect, rc, rc3d;
	CString name;
	CSize size;
	CBrush	backBrush( RGB(255,255,255) );
	CRgn newRgn;
	int width, height;

	//
	pDC->SetBkMode( TRANSPARENT );
	pDC->SetTextColor( textColor );
	//_
	x = 0; y = 0;
	//g
	GetClientRect(rect);
	width = rect.Width();
	height = rect.Height();
	rc.left = (long)(x + width * 0.05);
	rc.top = (long)(y + height * 0.05);
	rc.right = (long)(x + width * 0.95);
	rc.bottom = (long)(y + height * 0.95);
	pDC->FillRect( &rc, &backBrush);
	// 3D
	rc3d.left = rc.left+1;
	rc3d.top = rc.top+1;
	rc3d.right = rc.right+1;
	rc3d.bottom = rc.bottom+1;
	COLORREF topColor = GetSysColor(COLOR_3DLIGHT);
	COLORREF bottomColor = GetSysColor(COLOR_3DDKSHADOW);
	pDC->Draw3dRect( &rc, bottomColor, topColor );
	pDC->Draw3dRect( &rc3d, bottomColor, topColor );
	//W
	xs = (int)(x + width * 0.2);
	ys = (int)(y + height * 0.1);
	xe = (int)(x + width * 0.9);
	ye = (int)(y + height * 0.9);
	ym = (int)(y + height * 0.5);
	//ʒu
	if(m_index == 0) {	//0ȊÓA`撆
		for(i = 0; i < pItem->size; i++) {
			m_xs[i] = xs;
			m_ys[i] = ys;
		}
	}
	m_xInit = xs;
	m_yInit = ys;
	m_width = (int)(width*0.7);
	m_height = (int)(height*0.8);
	//c
	from = CPoint(xs, ys);
	to = CPoint(xs, ye);
	InvertLine(pDC, from, to);
	y = ys;
	step = (int)((double)m_height / 4);
	for(i = 0; i <= 4; i++) {
		from = CPoint(xs-5, y+i*step);
		to = CPoint(xs, y+i*step);
		InvertLine(pDC, from, to);
	}
	//
	from = CPoint(xs, ym);
	to = CPoint(xe, ym);
	InvertLine(pDC, from, to);
	x = xs;
	step = (int)((double)m_width / 5);
	for(i = 0; i <= 5; i++) {
		from = CPoint(xs+i*step, ym-3);
		to = CPoint(xs+i*step, ym+3);
		InvertLine(pDC, from, to);
	}

	//ő^ŏ\
	if(!pItem->autoScale) {
		m_ymax = atof(pItem->strVmax);
		m_ymin = atof(pItem->strVmin);
	}
	else
		SetAutoscale();

	//O
	//SetTitle(pDC, pItem);
	//P
	SetUnits(pDC, pItem);
	pDC->SelectObject(pOldPen);
}

// pItem:\ϐ
void CScopeView::DrawScope(CDC* pDC, SCOPEINFO* pItem)
{
	int		i,xs,ys,xe,ye,dindex,ch;
	double data,scl;
	CPoint	from,to;
	CPen	lineColor(PS_SOLID, 1, RGB(0, 0, 0));
	CPen	dataColor(PS_SOLID, pItem->width, pItem->gcolor/*RGB(255, 0, 0)*/);
	COLORREF	textColor;
	textColor = RGB(0, 0, 0);
	CPen*	pOldPen;
	pOldPen = pDC->SelectObject(&lineColor);
	CRect	rc, rc3d;
	CString name;
	CSize size;
	CBrush	backBrush( RGB(255,255,255) );
	CRgn newRgn;

	//
	pDC->SetBkMode( TRANSPARENT );
	pDC->SetTextColor( textColor );

	//Scope
	DrawInit(pDC, pItem);
	//f[^\
	pOldPen = pDC->SelectObject(&dataColor);
	if(m_data) {
		//̈搧
		CPoint pScroll = this->GetScrollPosition();
		newRgn.CreateRectRgn(m_xInit-pScroll.x, m_yInit-pScroll.y,
				m_xInit-pScroll.x+m_width, m_yInit-pScroll.y+m_height);
		pDC->SelectClipRgn(&newRgn);
		for(ch = 0; ch < pItem->size; ch++) {
			xs = m_xs[ch];
			ys = m_ys[ch];
			scl = m_ymax - m_ymin;
			//for(i = 0; i < m_index; i++) {
			for(i=m_nStart; i <m_index; i++) {
				data = m_data[i*pItem->size+ch];
				dindex = i - m_nStart;
				xe = m_xInit + (int)((double)m_width*dindex/m_nLength);
				ye = m_yInit + (int)(m_height*(m_ymax-data)/scl);
				if(dindex != 0) {
					from = CPoint(xs, ys);
					to = CPoint(xe, ye);
					InvertLine(pDC, from, to);
				}
				xs = xe; ys = ye;
			}
		}
		newRgn.DeleteObject();
		pDC->SelectClipRgn(NULL);
	}
	pDC->SelectObject(pOldPen);
}


// \^Cg
void CScopeView::SetTitle(CDC *pDC, SCOPEINFO *pItem)
{
	CString name;
	CSize size;
	int xm;
	CFont*	pOldFont;

	pOldFont = pDC->SelectObject( &m_font );
	xm = m_xInit + m_width / 2;
	name = pItem->strName;
	size = pDC->GetTextExtent(name, name.GetLength());
	pDC->TextOut(xm-size.cx/2, m_yInit, name);
	pDC->SelectObject( pOldFont );
}


void CScopeView::SetUnits(CDC *pDC, SCOPEINFO *pItem)
{
	CString name;
	CSize size;
	char buf[_MAX_PATH];
	double ymid;
	int ym, ye, xe;
	CFont*	pOldFont;

	// Font
	pOldFont = pDC->SelectObject( &m_font );
	// cS
	xe = m_xInit + m_width;
	ye = m_yInit + m_height;
	ym = m_yInit + m_height / 2;
	// Vmax
	sprintf(buf,"%.1f",m_ymax);
	name = _T(buf);
	size = pDC->GetTextExtent(name, name.GetLength());
	pDC->TextOut(m_xInit-size.cx-5, m_yInit, name);
	// Vmin
	sprintf(buf,"%.1f",m_ymin);
	name = _T(buf);
	size = pDC->GetTextExtent(name, name.GetLength());
	pDC->TextOut(m_xInit-size.cx-5, ye-size.cy, name);
	// _
	ymid = m_ymin + (m_ymax - m_ymin) / 2;
	sprintf(buf,"%.1f",ymid);
	name = _T(buf);
	size = pDC->GetTextExtent(name, name.GetLength());
	pDC->TextOut(m_xInit-size.cx-5, ym-size.cy/2, name);

	// time
	sprintf(buf,"%.1f",m_nStart*m_simstep);
	name = _T(buf);
	size = pDC->GetTextExtent(name, name.GetLength());
	pDC->TextOut(m_xInit, ym, name);
	sprintf(buf,"%.1f",(m_nStart+m_nLength)*m_simstep);
	name = _T(buf);
	size = pDC->GetTextExtent(name, name.GetLength());
	pDC->TextOut(xe-size.cx, ym, name);
	pDC->SelectObject( pOldFont );
}

void CScopeView::InvertLine(CDC *pDC, POINT from, POINT to)
{
    //int nOldMode = pDC->SetROP2 (R2_NOT);
    pDC->MoveTo (from);
    pDC->LineTo (to);
    //pDC->SetROP2 (nOldMode);
}

//
//	Scopee`
//  size : Scope\f[^TCY
void CScopeView::DrawData(CDC* pDC, int size, SCOPEINFO* pItem)
{
	int	xs,ys,xe,ye,dindex,i;
	double data,scl;
	CPoint from,to;
	CPen	dataColor(PS_SOLID, pItem->width, pItem->gcolor/*RGB(255, 0, 0)*/);
	CPen*	pOldPen;
	CRgn newRgn;

	if(!m_data)
		return;
	this->OnPrepareDC(pDC);
	CPoint pScroll = this->GetScrollPosition();
	newRgn.CreateRectRgn(m_xInit-pScroll.x, m_yInit-pScroll.y,
			m_xInit-pScroll.x+m_width, m_yInit-pScroll.y+m_height);
	pDC->SelectClipRgn(&newRgn);
	pOldPen = pDC->SelectObject(&dataColor);
	//\CfbNXmF
	dindex = m_index - m_nStart;
	//Am_nLength𒴂
	if(dindex > m_nLength) {
		if((m_nStart+dindex) < m_nCycle) {
			m_nStart += m_nLength;
			DrawInit(pDC, pItem);
			dindex = m_index - m_nStart;
		}
	}

	// size\
	for(i = 0; i < size; i++) {
		xs = m_xs[i];
		ys = m_ys[i];
		scl = m_ymax - m_ymin;
		data = m_data[m_index*size+i];
		xe = m_xInit + (int)((double)m_width*dindex/m_nLength);
		ye = m_yInit + (int)(m_height*(m_ymax-data)/scl);
		if((dindex-1) != 0) {
			//ŏ̃f[^
			from = CPoint(xs, ys);
			to = CPoint(xe, ye);
			InvertLine(pDC, from, to);
		}
		m_xs[i] = xe; m_ys[i] = ye;
	}
	pDC->SelectObject(pOldPen);
	newRgn.DeleteObject();
}

/////////////////////////////////////////////////////////////////////////////
// CScopeView ff

#ifdef _DEBUG
void CScopeView::AssertValid() const
{
	CScrollView::AssertValid();
}

void CScopeView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CScopeView bZ[W nh

//\ScopeɕύXꍇɌĂ΂
void CScopeView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
#if 0
	CSize sizeTotal;
	//CScopeDoc* pDoc = GetDocument();
	CWidget *pWidget;
	int i,nCount,index;
	CPtrArray*	p;
	SCOPEINFO *pItem;
	
    if (lHint == 0x5C) {
		pWidget = this->GetParent()->m_pWidget;
		p = pWidget->GetScopePointer();
		nCount = p->GetSize();
		if(nCount > 0) {
			index = 0;
			for (i=0; i<nCount; i++) {
				pItem = (SCOPEINFO*) p->GetAt (i);
				if(pItem->visible)
					index++;
			}
			sizeTotal.cx = SCOPE_WIDTH;
			sizeTotal.cy = SCOPE_HEIGHT * index;
			SetScrollSizes(MM_TEXT, sizeTotal);
			pDoc->m_docSize = sizeTotal;
			//ScopdDocɃj^[ݒ
			m_nSize = index;
			//f[^
			if(m_data) {
				m_index = 0;
//printf("\nHeapFree\n");
				HeapFree( GetProcessHeap(), 0, (LPVOID)m_data );
				//delete m_data;
				m_data = NULL;
				//Scale߂
				m_scaleMode = SCALE_NORMAL;
				SetAxis();
			}

			//XV
			Invalidate(TRUE);
		}
	}
	else if (lHint == 0x5D || lHint == 0x5E) {
		//Overlay mode
		if(lHint == 0x5D) {
			m_overlayMode = TRUE;
		}
		else {
			m_overlayMode = FALSE;
		}
		Invalidate(TRUE);
	}
#endif
}

//eScopeW\(pItem->autoScale=FALSE)ɖ߂
void CScopeView::SetAxis()
{
	CScopeWnd* pScopeWnd = (CScopeWnd*)(m_pParentWnd/*this->GetParent()*/);
	CWidget *pWidget;
	CPtrArray*	p;
	SCOPEINFO *pItem;

	pWidget = pScopeWnd->m_pWidget;
	p = pWidget->GetScopePointer();
	pItem = (SCOPEINFO*) p->GetAt (pScopeWnd->m_nVarIndex);
	m_ymax = atof(pItem->strVmax);
	m_ymin = atof(pItem->strVmin);
	pItem->autoScale = FALSE;
}

// f[^o^
// WidgetĂяo
// scope:Widgetŕ\ϐԍ
void CScopeView::UpdateData(int cycle, int scope, int size, float* data)
{
	int i;
//printf("UpdateData[%4d] ",cycle);
	for(i = 0; i < size; i++) {
		m_data[cycle*size+i] = (double)(*data++);
//printf("%f ",m_data[cycle*size+i]);
	}
	m_index = cycle;
//printf("\n");

	//vZɕ\
	CScopeWnd* pScopeWnd = (CScopeWnd*)(m_pParentWnd/*this->GetParent()*/);
	CWidget* pWidget;
	CPtrArray*	p;
	SCOPEINFO* pItem;
	pWidget = pScopeWnd->m_pWidget;
	p = pWidget->GetScopePointer();
	pItem = (SCOPEINFO*) p->GetAt (scope);
	CDC *pDC = GetDC();
	DrawData(pDC, size, pItem);
	ReleaseDC(pDC);
}

// Scope̕`惂[hݒ肷邽߁AExtncsDocĂяo
// 0:SāA1:f[^̂
void CScopeView::SetUpdateMode(int mode)
{
	m_updateMode = mode;
}

void CScopeView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	// ǂScopeIĂ邩
	CScopeWnd* pScopeWnd = (CScopeWnd*)(m_pParentWnd/*this->GetParent()*/);
	CWidget *pWidget;
	CPtrArray*	p;
	SCOPEINFO *pItem;

	pWidget = pScopeWnd->m_pWidget;
	p = pWidget->GetScopePointer();
	pItem = (SCOPEINFO*) p->GetAt (pScopeWnd->m_nVarIndex);

	m_targetScope = 0;
	// }EX|C^XN[Wɕϊ
	ClientToScreen( &point );
	// gɃtH[JXݒ
	SetForegroundWindow();
	// |bvAbvj[̍쐬
	CMenu menu;
	// IDR_MENUPOPUP_SCOPE̓j[̃\[XID
	menu.LoadMenu( IDR_POPUP_SCOPE );
	// set check
	// Autuscale
	if(pItem->autoScale)
		menu.CheckMenuItem(ID_SCOPE_AUTOSCALE, MF_CHECKED);
	else
		menu.CheckMenuItem(ID_SCOPE_AUTOSCALE, MF_UNCHECKED);
	// Overlayj[
	menu.EnableMenuItem(ID_SCOPE_OVERLAY, MF_GRAYED);
	// X-Yj[
	//if (m_nSize == 2)
	//	menu.EnableMenuItem(ID_SCOPE_XY, MF_ENABLED);
	//else
		menu.EnableMenuItem(ID_SCOPE_XY, MF_GRAYED);
	// 3Dj[
	//if (m_nSize == 3)
	//	menu.EnableMenuItem(ID_SCOPE_3D, MF_ENABLED);
	//else
		menu.EnableMenuItem(ID_SCOPE_3D, MF_GRAYED);

	CMenu* pPopup = menu.GetSubMenu( 0 );
	// |bvAbvj[\
	pPopup->TrackPopupMenu( TPM_LEFTALIGN | TPM_RIGHTBUTTON,
			point.x, point.y, this);
	// LoadMenuJ
	menu.DestroyMenu();
	
	CScrollView::OnRButtonDown(nFlags, point);
}

void CScopeView::OnScopeAttr() 
{
	CScopeWnd* pScopeWnd = (CScopeWnd*)(m_pParentWnd/*this->GetParent()*/);
	CWidget *pWidget;
	CPtrArray*	p;
	SCOPEINFO *pItem;
	double simtime,disptime;

	CScopeSheet *pSheet;
	CString title;

	title = _T("'Scope' properties");
	pSheet = new CScopeSheet(title, this, 0);
	//pWidget = pDoc->m_pWidget;
	pWidget = pScopeWnd->m_pWidget;
	p = pWidget->GetScopePointer();
	pItem = (SCOPEINFO*) p->GetAt (pScopeWnd->m_nVarIndex);
	// Range
	pSheet->m_scopeRange.m_pView = this;
	pSheet->m_scopeRange.m_strVmax = pItem->strVmax;
	pSheet->m_scopeRange.m_strVmin = pItem->strVmin;
	pSheet->m_scopeRange.m_strTime = pItem->strTime;
	// Graph
	pSheet->m_scopeGraph.m_pView = this;
	pSheet->m_scopeGraph.m_nWidth = pItem->width;
	pSheet->m_scopeGraph.m_nColor = pItem->gcolor;
	if (pSheet->DoModal() == IDOK) {
		// ScopeXV
		pItem->strVmax = pSheet->m_scopeRange.m_strVmax;
		pItem->strVmin = pSheet->m_scopeRange.m_strVmin;
		pItem->strTime = pSheet->m_scopeRange.m_strTime;
		pItem->width = pSheet->m_scopeGraph.m_nWidth;
		pItem->gcolor = pSheet->m_scopeGraph.m_nColor;
		// \_
		simtime = atof(pItem->strTe) - atof(pItem->strTs);
		disptime = atof(pItem->strTime);
		m_nLength = (int)(m_nCycle * disptime / simtime);
		//ݒ肳ꂽ
		Invalidate(TRUE);		//wiAĕ`
	}
	delete pSheet;
	
}

void CScopeView::OnUpdateScopeAttr(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	
}

void CScopeView::OnScopeAutoscale() 
{
	CScopeWnd* pScopeWnd = (CScopeWnd*)(m_pParentWnd/*this->GetParent()*/);
	CWidget *pWidget;
	CPtrArray*	p;
	SCOPEINFO *pItem;

	pWidget = pScopeWnd->m_pWidget;
	p = pWidget->GetScopePointer();
	pItem = (SCOPEINFO*) p->GetAt (pScopeWnd->m_nVarIndex);
	if(pItem->autoScale)
		pItem->autoScale = FALSE;
	else
		pItem->autoScale = TRUE;
	//ĕ`
	Invalidate(TRUE);
	
}

void CScopeView::OnUpdateScopeAutoscale(CCmdUI* pCmdUI) 
{
	CScopeWnd* pScopeWnd = (CScopeWnd*)(m_pParentWnd/*this->GetParent()*/);
	CWidget *pWidget;
	CPtrArray*	p;
	SCOPEINFO *pItem;

	pWidget = pScopeWnd->m_pWidget;
	p = pWidget->GetScopePointer();
	pItem = (SCOPEINFO*) p->GetAt (pScopeWnd->m_nVarIndex);
	if(pItem->autoScale)
	//if(m_scaleMode == SCALE_AUTO)
		pCmdUI->SetCheck(TRUE);
	else
		pCmdUI->SetCheck(FALSE);
	
}

//ef[^̍ŏ^ő匟o	
void CScopeView::SetAutoscale() 
{
	CScopeWnd* pScopeWnd = (CScopeWnd*)(m_pParentWnd/*this->GetParent()*/);
	CWidget *pWidget;
	CPtrArray*	p;
	SCOPEINFO *pItem;
	pWidget = pScopeWnd->m_pWidget;
	p = pWidget->GetScopePointer();
	pItem = (SCOPEINFO*) p->GetAt (pScopeWnd->m_nVarIndex);
	int	i;
	double data,max,min;

	if(m_index > 0) {
		//0ȏ̏ꍇ
		max = -1e6;
		min = 1e6;
		for(i = 0; i < m_index*pItem->size; i++) {
			//m_targetScopeԖ
			data = m_data[i];
			if(max < data)
				max = data;
			if(min > data)
				min = data;
		}
		m_ymax = max;
		m_ymin = min;
	}
}

//sĂ邩
//ۑpɍ쐬Ă
void CScopeView::SetData()
{
}

// X^[gɏ
// Scope:ScopeCfbNX
void CScopeView::UpdateInit(int scope, double simtime, double simstep, int cycle, int width)
{
	CScopeWnd* pScopeWnd = (CScopeWnd*)(m_pParentWnd/*this->GetParent()*/);
	CWidget* pWidget;
	CPtrArray* p;
	SCOPEINFO* pItem;

	//f[^̈
	m_index = 0;			//ԃCfbNX
	m_nCycle = cycle;		//ԓ_
	m_simtime = simtime;
	m_simstep = simstep;
	m_nWidth = width;		//f[^
	if(m_data) {
		HeapFree( GetProcessHeap(), 0, (LPVOID)m_data );
		m_data = NULL;
	}

	if (!m_data) {
//printf("\nHeapAlloc(%ld)\n",m_nCycle*m_nWidth+2*m_nWidth);
		m_data = (double *)HeapAlloc( GetProcessHeap(), HEAP_ZERO_MEMORY, (m_nCycle*m_nWidth+2*m_nWidth) * sizeof( double ));
	}


	//_ݒ
	pWidget = pScopeWnd->m_pWidget;
	p = pWidget->GetScopePointer();
	pItem = (SCOPEINFO*) p->GetAt (scope);
	m_nLength = (int)(m_nCycle * atof(pItem->strTime) / simtime);
	m_nStart = 0;

	//TRUEƔwiĂ܂
	Invalidate(TRUE);
}


int CScopeView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CScrollView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// ̫Đݒ
	m_font.CreateFont(12,
		0,0,0,FW_NORMAL,0,0,0,SHIFTJIS_CHARSET,
		OUT_STROKE_PRECIS,CLIP_DEFAULT_PRECIS,DRAFT_QUALITY,
		DEFAULT_PITCH,_T("MS PSVbN"));
#if 0
	HWND hWnd;
	HBRUSH hBrush;
	DWORD dw;

	hWnd = this->GetSafeHwnd();
	//hWnd = lpCreateStruct->hwndParent;
	hBrush = CreateSolidBrush(RGB(128, 255, 255));	
	dw = ::SetClassLong(hWnd, GCL_HBRBACKGROUND, (LONG)hBrush);
#endif;
	
	return 0;
}

BOOL CScopeView::OnEraseBkgnd(CDC* pDC) 
{
	CRect rcClient;
	GetClientRect(&rcClient);
	CBrush bkBrush( ::GetSysColor(COLOR_MENU)/*RGB(128, 255, 255)*/ );
	pDC->FillRect( &rcClient, &bkBrush );
	return TRUE;
	
	//return CScrollView::OnEraseBkgnd(pDC);
}

void CScopeView::OnDestroy() 
{
	CScrollView::OnDestroy();
	
	// ̫ĵ޼ު
	m_font.DeleteObject();
#if 0
	int index;
	CExtncsDoc* pExtncsDoc = (CExtncsDoc *)(GetDocument()->m_pExtncsDoc);
	index = GetDocument()->m_nThisIndex;
	//pExtncsDoc->m_bScopeWnd[index] = FALSE;
	((CView *)(pExtncsDoc->GetExtncsView()))->PostMessage(WM_DELETE_SCOPE, index, 0L);
#endif
}

void CScopeView::SetSimuParam(double simtime, double simstep)
{
	m_simtime = simtime;
	m_simstep = simstep;
}

